// demoLoginDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoLoginDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"

// demoLoginDlg Ի

IMPLEMENT_DYNAMIC(demoLoginDlg, CDialogEx)

demoLoginDlg::demoLoginDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_LOGIN_DIALOG, pParent)
{

}

demoLoginDlg::~demoLoginDlg()
{
}

void demoLoginDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_ACCOUNT, m_loginAccountEdit);
    DDX_Control(pDX, IDC_EDIT_PASSWORD, m_loginPwdEdit);
    DDX_Control(pDX, IDC_CHECK_IS_USE_CODE_LOGIN, m_isTokenLoginCheck);
}


BEGIN_MESSAGE_MAP(demoLoginDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_LOGIN, &demoLoginDlg::OnBnClickedButtonLogin)
END_MESSAGE_MAP()


// demoLoginDlg Ϣ

BOOL demoLoginDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    // ļȡϴε¼ʺ
    CString loginAccount = _T("");
    CTools::getIniConfigParam(_T("LoginConfig"), _T("account"), loginAccount);
    m_loginAccountEdit.SetWindowText(loginAccount);

    return TRUE;  // ǽõؼ򷵻 TRUE
}

/**
* ¼
*/
int demoLoginDlg::Login()
{
    //ȡϢ
    m_loginAccountEdit.GetWindowText(m_loginAccount);
    m_loginPwdEdit.GetWindowText(m_loginPwd);

    //ת
    string account = CTools::UNICODE2UTF(m_loginAccount.GetString());
    string password = CTools::UNICODE2UTF(m_loginPwd.GetString());

    int ret;
    //жǷtoken¼
    if (m_isTokenLoginCheck.GetCheck())
    {
        //װνṹ
        hwmsdkagent::HwmAccountAndTokenAuthInfo loginParam{};

        strncpy_s(loginParam.account, account.c_str(), HWM_MAX_ACCOUNT_LEN);
        strncpy_s(loginParam.token, password.c_str(), HWM_MAX_TOKEN_LEN);
        //õ¼ӿ
        ret = hwmsdkagent::LoginByToken(&loginParam);
        memset(&loginParam, 0, sizeof(hwmsdkagent::HwmAccountAndTokenAuthInfo));
    }
    else
    {
        //װνṹ
        hwmsdkagent::HwmLoginInfo loginParam{};
      
        strncpy_s(loginParam.accountAndPasswordAuthInfo.account, account.c_str(), HWM_MAX_ACCOUNT_LEN);
        strncpy_s(loginParam.accountAndPasswordAuthInfo.password, password.c_str(), HWM_MAX_PASSWORD_LEN);
        loginParam.authType = hwmsdkagent::HWM_AUTH_TYPE_ACCOUNT_AND_PASSWORD;
        //õ¼ӿ
        ret = hwmsdkagent::Login(&loginParam);
        memset(&loginParam, 0, sizeof(hwmsdkagent::HwmLoginInfo));
    }
    password.assign(password.length(), '\0');

    return ret;
}

void demoLoginDlg::OnBnClickedButtonLogin()
{
    int ret = Login();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Login error");
    }
    else
    {
        //¼ӿڵóɹ󽫵¼Ϣ浽ļ´ȡ
        CTools::writeIniConfigParam(_T("LoginConfig"), _T("account"), m_loginAccount);
        //رյǰ
        OnOK();
    }
}
