﻿// demoCustomSceneImageDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "resource.h"
#include "demoTools.h"
#include "demoCustomSceneImageDlg.h"
#include "afxdialogex.h"

// demoCustomSceneImageDlg 对话框

IMPLEMENT_DYNAMIC(demoCustomSceneImageDlg, CDialogEx)

demoCustomSceneImageDlg::demoCustomSceneImageDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_CUSTOM_SCENE_IMAGE, pParent)
{

}

demoCustomSceneImageDlg::~demoCustomSceneImageDlg()
{
}

void demoCustomSceneImageDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    // 获取空间
    DDX_Control(pDX, IDC_EDIT_CUSTOM_SCENE_IMAGE_PATH, m_imagePath);
    DDX_Control(pDX, IDC_COMBO_IMAGE_SCENE, m_comboBoxScene);
    DDX_Control(pDX, IDC_EDIT_CUSTOM_SCENE_IMAGE_WIDTH, m_width);
    DDX_Control(pDX, IDC_EDIT_CUSTOM_SCENE_IMAGE_HEIGHT, m_height);
}

BOOL demoCustomSceneImageDlg::OnInitDialog()
{
    CDialog::OnInitDialog();
    // 插入顺序与场景枚举顺序一致
    m_comboBoxScene.InsertString(0, _T("会中云录制主图标"));
    m_comboBoxScene.InsertString(1, _T("主窗口云录制ICON小图标"));
    m_comboBoxScene.InsertString(2, _T("主窗口云录制LOGO大图标"));
    m_comboBoxScene.SetCurSel(0);

    return TRUE;
}


BEGIN_MESSAGE_MAP(demoCustomSceneImageDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_CUSTOM_SCENE_IMAGE_STORE, &demoCustomSceneImageDlg::OnBnClickedButtonCustomSceneImageStore)
    ON_BN_CLICKED(IDOK, &demoCustomSceneImageDlg::OnBnClickedOk)
END_MESSAGE_MAP()

void demoCustomSceneImageDlg::OnBnClickedButtonCustomSceneImageStore()
{
    // 获取场景图标信息
    hwmsdkagent::HwmCustomSceneImageInfo imageInfo;
    int ccomboxIndex = m_comboBoxScene.GetCurSel();
    imageInfo.scene = static_cast<hwmsdkagent::HwmUICustomImageScene>(ccomboxIndex);
    CString tempCString;
    m_imagePath.GetWindowText(tempCString);
    strncpy_s(imageInfo.imagePath, CTools::UNICODE2UTF(tempCString.GetString()).c_str(), HWM_MAX_FILE_PATH_LEN);
    m_width.GetWindowText(tempCString);
    imageInfo.width = static_cast<unsigned int>(_ttoi(tempCString));
    m_height.GetWindowText(tempCString);
    imageInfo.height = static_cast<unsigned int>(_ttoi(tempCString));

    hwmsdkagent::HwmCustomSceneImageInfoList data{};
    data.customSceneImageInfoListSize = 1;
    data.customSceneImageInfoList = new (std::nothrow)hwmsdkagent::HwmCustomSceneImageInfo[data.customSceneImageInfoListSize];
    data.customSceneImageInfoList[0] = std::move(imageInfo);
    hwmsdk::HwmErrCode ret = hwmsdkagent::SetCustomUIImage(&data);
    if (ret != hwmsdk::HWM_COMMON_SUCCESS)
    {
        CTools::OutputRetStr("Custom scene content error");
    }
    // 释放结构体内存
    if (data.customSceneImageInfoList != nullptr)
    {
        delete data.customSceneImageInfoList;
        data.customSceneImageInfoList = nullptr;
    }
}


void demoCustomSceneImageDlg::OnBnClickedOk()
{
    CDialogEx::OnOK();
}
