/*****************************************************************************
 *               Copyright (C) 2006, Huawei Tech. Co., Ltd.
 *                           ALL RIGHTS RESERVED
 * FileName: base64.c
 * Version: 1.0
 * Description:  ļBASE64㷨ʵ
 *
 * History:
 * 1. 2005-12-25,h00356641 ֲļγɱ׼ͳһӿ.
******************************************************************************/
#include "stdlib.h"
#include "base64.h"

static const char cb64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
static const char cd64[] = "|$$$}rstuvwxyz{$$$$$$$>?@ABCDEFGHIJKLMNOPQRSTUVW$$$$$$XYZ[\\]^_`abcdefghijklmnopq";
static const char acBase64Char[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\r\n";
// BASE64ת-1ʾǷַ-2ʾҪַ
static const int table[128] =
{
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -1, -1, -2, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1,
    -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,
    -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1
};

using namespace std;

// ȡBASE64ַ
void RtcBase64Encode(const unsigned char *input, unsigned int length, string &base64)
{
    unsigned char *bytes = (unsigned char *)input;
    const char pad = '=';
    const static char base64Table[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        "abcdefghijklmnopqrstuvwxyz"
        "0123456789+/";
    int i;

    /******************************************
    |    [i]   | [i + 1] | [i + 2] |
    | ...... ..|.... ....|.. ......|
    | ......|.. ....|.... ..|......|
    |   C1  |   C2  |   C3  |  C4  |
    ******************************************/
    for (i = 0, base64.clear(); i < length; i += 3)
    {
        // C1
        base64.append(1, base64Table[bytes[i] >> 2]);

        if (i == length - 1)
        {
            // [i]һֽ
            base64.append(1, base64Table[(bytes[i] & 0x03) << 4]);
            base64.append(2, pad);
            return;
        }

        // C2
        base64.append(1, base64Table[((bytes[i] & 0x03) << 4) | (bytes[i + 1] >> 4)]);

        if (i == length - 2)
        {
            // [i + 1]һֽ
            base64.append(1, base64Table[(bytes[i + 1] & 0x0F) << 2]);
            base64.append(1, pad);
            return;
        }

        // C3
        base64.append(1, base64Table[((bytes[i + 1] & 0x0F) << 2) | ((bytes[i + 2] & 0xC0) >> 6)]);

        // C4
        base64.append(1, base64Table[bytes[i + 2] & 0x3F]);
    }
}

// ȡBASE64
unsigned int RtcBase64Decode(const unsigned char *base64, unsigned int length, unsigned char** output)
{
    if (output == nullptr)
    {
        return 0;
    }

    int str_len = length;
    int out_len = (str_len + 4 - 1) / 4 * 3 + 1;

    unsigned char* out = (unsigned char*)malloc(sizeof(unsigned char) * out_len);
    if (out == nullptr)
    {
        return 0;
    }

    int i = 0, j = 0;
    int state = 0;

    /********************************
    |   C1  |   C2  |   C3  |  C4  |
    | ...... ..|.... ....|.. ......|
    |    [i]   | [i + 1] | [i + 2] |
    ********************************/
    for (; i < str_len; i++)
    {
        if ((base64[i] & 0x80) || (-1 == table[(unsigned char)base64[i]]))
        {
            // ַ߷Ƿַ
            break;
        }

        int oct = table[(unsigned char)base64[i]];

        if (-2 == oct)
        {
            // '\r''\n''\t'' '
            continue;
        }

        switch (state)
        {
        case 0:
            // C1
            out[j] = ((unsigned char)oct << 2);
            state++;
            break;

        case 1:
            // C2
            out[j++] |= ((unsigned char)oct >> 4);
            out[j] = (((unsigned char)oct << 4) & 0xF0);
            state++;
            break;

        case 2:
            // C3
            out[j++] |= ((unsigned char)oct >> 2);
            out[j] = (((unsigned char)oct << 6) & 0xC0);
            state++;
            break;

        case 3:
            // C4
            out[j++] |= (unsigned char)oct;
            state = 0;
            break;
        default:
            break;
        }
    }

    *output = out;
    return j;
}
