// demoAddAttendeeDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoAddAttendeeDlg.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"

// demoAddAttendeeDlg Ի

IMPLEMENT_DYNAMIC(demoAddAttendeeDlg, CDialogEx)

demoAddAttendeeDlg::demoAddAttendeeDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_ADD_ATTENDEE_DIALOG, pParent)
{

}

demoAddAttendeeDlg::~demoAddAttendeeDlg()
{
}

void demoAddAttendeeDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_DELETE_HWM_CONF_ATTENDEE, m_editDeleteAttendee);
    DDX_Control(pDX, IDC_EDIT_ADD_HWM_CONF_ATTENDEE_LIST, m_attendeesEdit);
}

BEGIN_MESSAGE_MAP(demoAddAttendeeDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_ADD_ATTENDEE_OK, &demoAddAttendeeDlg::OnBnClickedButtonOk)
    ON_BN_CLICKED(IDC_BUTTON_ADD_HWM_CONF_ATTENDEE, &demoAddAttendeeDlg::OnBnClickedButtonAddHwmConfAttendee)
    ON_BN_CLICKED(IDC_BUTTON_DELETE_HWM_CONF_ATTENDEE, &demoAddAttendeeDlg::OnBnClickedButtonDeleteHwmConfAttendee)
END_MESSAGE_MAP()


// demoAddAttendeeDlg Ϣ


int demoAddAttendeeDlg::clickAddAttendee()
{
    hwmsdkagent::HwmConfAttendee* participants = nullptr;
    unsigned int realCount = 0;
    std::vector<hwmsdkagent::HwmConfAttendee>& attendeeList = m_addAttendeeLogic.GetAttendeeList();
    if (!attendeeList.empty())
    {
        participants = attendeeList.data();
        realCount = attendeeList.size();
    }
    return hwmsdkagent::AddAttendee(participants, realCount);
}

void demoAddAttendeeDlg::OnBnClickedButtonOk()
{
    int ret = clickAddAttendee();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Addattendees error");
        return;
    }
    CDialogEx::OnOK();
}


void demoAddAttendeeDlg::OnBnClickedButtonAddHwmConfAttendee()
{
    bool isAddSuc = m_addAttendeeLogic.AddAttendee();
    if (isAddSuc)
    {
        fillAttendees();
    }
}

void demoAddAttendeeDlg::OnBnClickedButtonDeleteHwmConfAttendee()
{
    CString input;
    m_editDeleteAttendee.GetWindowText(input);
    bool isDeleteSuc = m_addAttendeeLogic.DeleteAttendee(input);
    if (isDeleteSuc)
    {
        fillAttendees();
    }
}

void demoAddAttendeeDlg::fillAttendees()
{
    std::string attendeeStr = m_addAttendeeLogic.GetAttendeeStr();
    m_attendeesEdit.SetWindowTextW(CTools::UTF2UNICODE(attendeeStr).c_str());
}