﻿// demoAddCycleConf.cpp: 实现文件
//

#include "stdafx.h"
#include "demoAddCycleConf.h"
#include "afxdialogex.h"

#include "demoData.h"
#include "demoTools.h"
#include "resource.h"
#include "demoCustomMessage.h"

// demoAddCycleConf 对话框

IMPLEMENT_DYNAMIC(demoAddCycleConf, CDialogEx)

demoAddCycleConf::demoAddCycleConf(CWnd* pParent /*=nullptr*/)
    : CDialogEx(IDD_BOOK_CYCLE_CONF_DIALOG, pParent)
    , m_confInfo()
    , m_cycleConfParam{0}, m_isEditConf(false)
{

}

demoAddCycleConf::~demoAddCycleConf()
{
}

hwmsdkagent::HwmCycleConfParam demoAddCycleConf::GetCycleConfParam() const
{
    return m_cycleConfParam;
}

void demoAddCycleConf::SetIsEditCycleConf(bool isEdit)
{
    m_isEditConf = isEdit;
}

BOOL demoAddCycleConf::OnInitDialog()
{
    const auto ret = CDialogEx::OnInitDialog();

    m_editCycleType.InsertString(0,_T("day") );
    m_editCycleType.InsertString(1,_T("week"));
    m_editCycleType.InsertString(2, _T("month"));

    m_editCycleType.SetCurSel(1);
    UpdateDialogData();
    return ret;
}

void demoAddCycleConf::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_BOOK_CYCLE_CONF_END_DATA, m_confEndDateCtrl);
    DDX_Control(pDX, IDC_BOOK_CYCLE_TYPE, m_editCycleType);
    DDX_Control(pDX, IDC_BOOK_CYCLE_INTERVAL, m_editInterval);
    DDX_Control(pDX, IDC_BOOK_CYCLE_LISTPOINTS, m_editListPoints);
    DDX_Control(pDX, IDC_BOOK_CYCLE_PREREMINDDAYS, m_editPreRemindDays);
}

void demoAddCycleConf::OnOK()
{
    CTime endDate;
    m_confEndDateCtrl.GetTime(endDate);
    m_cycleConfParam.endTimeStamp = endDate.GetTime();

    CString input;

    int cycleType =  m_editCycleType.GetCurSel();
    m_cycleConfParam.cycleType =  static_cast<hwmsdkagent::HwmCycleType>(cycleType);

    m_editInterval.GetWindowText(input);
    std::string interval(CW2A(input.GetString()));
    m_cycleConfParam.interval = CTools::stringToType<unsigned int>(interval);

    CTools::GetEditValue(m_cycleConfParam.listPoints, sizeof(m_cycleConfParam.listPoints), m_editListPoints);

    m_editPreRemindDays.GetWindowText(input);
    std::string preRemindDays(CW2A(input.GetString()));
    m_cycleConfParam.preRemindDays = CTools::stringToType<unsigned int>(preRemindDays);


    CDialogEx::OnOK();

}

void demoAddCycleConf::OnCancel()
{
    CDialogEx::OnCancel();
}

void demoAddCycleConf::UpdateDialogData()
{
    if(m_isEditConf)
    {
        m_confInfo = demoData::GetInstance().GetConfDetail();
        CTime endData = m_confInfo.confListInfo.cycleParam.endTimeStamp;
        m_confEndDateCtrl.SetTime(&endData);

        m_editCycleType.SetCurSel(m_confInfo.confListInfo.cycleParam.cycleType);
        std::wstring interval(std::to_wstring(m_confInfo.confListInfo.cycleParam.interval));
        m_editInterval.SetWindowTextW(interval.c_str());

        std::wstring preRemindDays(std::to_wstring(m_confInfo.confListInfo.cycleParam.preRemindDays));
        m_editPreRemindDays.SetWindowTextW(preRemindDays.c_str());

        std::string listPoints(m_confInfo.confListInfo.cycleParam.listPoints);
        m_editListPoints.SetWindowTextW(CTools::UTF2UNICODE(listPoints).c_str());
    }
}

LRESULT demoAddCycleConf::OnConfDetail(WPARAM wparam, LPARAM lparam)
{
    UpdateDialogData();
    return 0;
}


BEGIN_MESSAGE_MAP(demoAddCycleConf, CDialogEx)
    ON_MESSAGE(WM_CONFDETAIL_UPDATE, &demoAddCycleConf::OnConfDetail)
END_MESSAGE_MAP()


// demoAddCycleConf 消息处理程序
