// demoSetRawDataExternalConfigDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demo.h"
#include "demoSetRawDataExternalConfigDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"
#include "demoNotifyProc.h"
#include "demoCallBackProc.h"

// demoSetRawDataExternalConfigDlg Ի

IMPLEMENT_DYNAMIC(demoSetRawDataExternalConfigDlg, CDialogEx)

demoSetRawDataExternalConfigDlg::demoSetRawDataExternalConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_SET_RAW_DATA_EXTERANL_CONFIG, pParent)
{

}

demoSetRawDataExternalConfigDlg::~demoSetRawDataExternalConfigDlg()
{
}

void demoSetRawDataExternalConfigDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_CHECK_ENABLE_E2EE, m_enableE2EE);
    DDX_Control(pDX, IDC_EDIT_LIBRARYPATH, m_libraryPath);
    DDX_Control(pDX, IDC_EDIT_AUDIOENCRYPT, m_audioEncrypt);
    DDX_Control(pDX, IDC_EDIT_AUDIODECRYPT, m_audioDecrypt);
    DDX_Control(pDX, IDC_EDIT_VIDEOENCRYPT, m_videoEncrypt);
    DDX_Control(pDX, IDC_EDIT_VIDEODECRYPT, m_videoDecrypt);
}

BEGIN_MESSAGE_MAP(demoSetRawDataExternalConfigDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSetRawDataExternalConfigDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDC_BTN_BROWSER, &demoSetRawDataExternalConfigDlg::OnBnClickedBtnBrowser)
END_MESSAGE_MAP()

// demoSetRawDataExternalConfigDlg Ϣ

void demoSetRawDataExternalConfigDlg::OnBnClickedOk()
{
    // TODO: ڴӿؼ֪ͨ

    // ö˵˼ӽܺӿ
    //װνṹ
    hwmsdkagent::HwmRawDataExternalConfigInfo rawDataExternalConfigInfo{};
    rawDataExternalConfigInfo.enableE2EE = m_enableE2EE.GetCheck();

    CString csLibraryPath;
    m_libraryPath.GetWindowText(csLibraryPath);
    const auto libraryPath = CTools::UNICODE2UTF(csLibraryPath.GetString());
    strcpy_s(rawDataExternalConfigInfo.libraryPath, sizeof(rawDataExternalConfigInfo.libraryPath), libraryPath.c_str());
    CString csAudioEncrypt;
    m_audioEncrypt.GetWindowText(csAudioEncrypt);
    const auto audioEncrypt = CTools::UNICODE2UTF(csAudioEncrypt.GetString());
    strcpy_s(rawDataExternalConfigInfo.audioEncrtptFuncName, sizeof(rawDataExternalConfigInfo.audioEncrtptFuncName), audioEncrypt.c_str());
    CString csAudioDecrypt;
    m_audioDecrypt.GetWindowText(csAudioDecrypt);
    const auto audioDecrypt = CTools::UNICODE2UTF(csAudioDecrypt.GetString());
    strcpy_s(rawDataExternalConfigInfo.audioDecrtptFuncName, sizeof(rawDataExternalConfigInfo.audioDecrtptFuncName), audioDecrypt.c_str());
    CString csVideoEncrypt;
    m_videoEncrypt.GetWindowText(csVideoEncrypt);
    const auto videoEncrypt = CTools::UNICODE2UTF(csVideoEncrypt.GetString());
    strcpy_s(rawDataExternalConfigInfo.videoEncrtptFuncName, sizeof(rawDataExternalConfigInfo.videoEncrtptFuncName), videoEncrypt.c_str());
    CString csVideoDecrypt;
    m_videoDecrypt.GetWindowText(csVideoDecrypt);
    const auto videoDecrypt = CTools::UNICODE2UTF(csVideoDecrypt.GetString());
    strcpy_s(rawDataExternalConfigInfo.videoDecrtptFuncName, sizeof(rawDataExternalConfigInfo.videoDecrtptFuncName), videoDecrypt.c_str());

    int ret = hwmsdkagent::SetRawDataExternalConfig(&rawDataExternalConfigInfo);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        AfxMessageBox(_T("SetRawDataExternalConfig failed"));
        return;
    }
    
    //ӿڵóɹϢ浽ļ´ȡ
    CString enableE2EE(m_enableE2EE.GetCheck() == 1 ? "true" : "false");
    CTools::writeIniConfigParam(_T("RawDataExternal"), _T("EnableE2EE"), enableE2EE);
    CTools::writeIniConfigParam(_T("RawDataExternal"), _T("LibraryPath"), csLibraryPath);
    CTools::writeIniConfigParam(_T("RawDataExternal"), _T("AudioEncryptFuncName"), csAudioEncrypt);
    CTools::writeIniConfigParam(_T("RawDataExternal"), _T("AudioDecryptFuncName"), csAudioDecrypt);
    CTools::writeIniConfigParam(_T("RawDataExternal"), _T("VideoEncryptFuncName"), csVideoEncrypt);
    CTools::writeIniConfigParam(_T("RawDataExternal"), _T("VideoDecryptFuncName"), csVideoDecrypt);
    CDialogEx::OnOK();
}

void demoSetRawDataExternalConfigDlg::OnBnClickedBtnBrowser()
{
    // TODO: ڴӿؼ֪ͨ
    CFileDialog fileDlg(TRUE, NULL, NULL, 0, _T("dll File(*.dll)|*.dll|All File(*.*)|*.*||"));
    if (IDOK == fileDlg.DoModal())
    {
        m_libraryPath.SetWindowText(fileDlg.GetPathName());
    }
}

BOOL demoSetRawDataExternalConfigDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    // TODO:  ڴӶĳʼ
    // ļȡϴϢ
    CString temp = _T("");
    CTools::getIniConfigParam(_T("RawDataExternal"), _T("EnableE2EE"), temp);
    if (temp.IsEmpty() || temp == "true")
    {
        m_enableE2EE.SetCheck(1);
    }

    CTools::getIniConfigParam(_T("RawDataExternal"), _T("LibraryPath"), temp);
    m_libraryPath.SetWindowText(temp);
    CTools::getIniConfigParam(_T("RawDataExternal"), _T("AudioEncryptFuncName"), temp);
    temp = temp.IsEmpty() ? CString("AudioEncryptionFunc") : temp;
    m_audioEncrypt.SetWindowText(temp);
    CTools::getIniConfigParam(_T("RawDataExternal"), _T("AudioDecryptFuncName"), temp);
    temp = temp.IsEmpty() ? CString("AudioDecryptionFunc") : temp;
    m_audioDecrypt.SetWindowText(temp);
    CTools::getIniConfigParam(_T("RawDataExternal"), _T("VideoEncryptFuncName"), temp);
    temp = temp.IsEmpty() ? CString("VideoEncryptionFunc") : temp;
    m_videoEncrypt.SetWindowText(temp);
    CTools::getIniConfigParam(_T("RawDataExternal"), _T("VideoDecryptFuncName"), temp);
    temp = temp.IsEmpty() ? CString("VideoDecryptionFunc") : temp;
    m_videoDecrypt.SetWindowText(temp);

    return TRUE;  // return TRUE unless you set the focus to a control
                  // 쳣: OCX ҳӦ FALSE
}
