﻿// demoOpenWaitingroomDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demoOpenWaitingroomDlg.h"
#include "afxdialogex.h"
#include "demo.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"


// demoOpenWaitingroomDlg 对话框

IMPLEMENT_DYNAMIC(demoOpenWaitingroomDlg, CDialogEx)

demoOpenWaitingroomDlg::demoOpenWaitingroomDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_OPEN_WAITINGROOM, pParent)
{

}

demoOpenWaitingroomDlg::~demoOpenWaitingroomDlg()
{
}

void demoOpenWaitingroomDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_COMBO_OPEN_WAITINGROOM_IS_OPEN, m_isOpenCombo);
}

BOOL demoOpenWaitingroomDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_isOpenCombo.SetWindowText(_T("Open"));
    m_isOpenCombo.InsertString(0, _T("Open"));
    m_isOpenCombo.InsertString(1, _T("Close"));

    return TRUE;
}


BEGIN_MESSAGE_MAP(demoOpenWaitingroomDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoOpenWaitingroomDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// demoOpenWaitingroomDlg 消息处理程序


int demoOpenWaitingroomDlg::ClickOpenWaitingRoom()
{
    bool isOpen = true;
    CString strIsOpen;
    m_isOpenCombo.GetWindowText(strIsOpen);
    if (_T("Open") == strIsOpen)
    {
        isOpen = true;
    }
    else if (_T("Close") == strIsOpen)
    {
        isOpen = false;
    }

    int ret = hwmsdkagent::OpenWaitingRoom(isOpen);
    return ret;
}

void demoOpenWaitingroomDlg::OnBnClickedOk()
{
    int ret = ClickOpenWaitingRoom();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("OpenWaitingRoom error");
        return;
    }
    CDialogEx::OnOK();
}
