// demoSetCAVerifyInfoDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demoSetCAVerifyInfoDlg.h"
#include "afxdialogex.h"
#include "resource.h"
#include "hwmSdkAgent.h"
#include <string>
#include "demoTools.h"

// demoSetCAVerifyInfoDlg Ի

IMPLEMENT_DYNAMIC(demoSetCAVerifyInfoDlg, CDialogEx)

demoSetCAVerifyInfoDlg::demoSetCAVerifyInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_SET_SAVE_CA_VERIFY_INFO_DIALOG, pParent)
{

}

demoSetCAVerifyInfoDlg::~demoSetCAVerifyInfoDlg()
{
}

void demoSetCAVerifyInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_COMBO_VERIFY_MODE, m_verifyMode);
    DDX_Control(pDX, IDC_EDIT_CERT_PATH, m_certPathEdit);
}

BEGIN_MESSAGE_MAP(demoSetCAVerifyInfoDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSetCAVerifyInfoDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// demoSetCAVerifyInfoDlg Ϣ

BOOL demoSetCAVerifyInfoDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    m_verifyMode.SetWindowText(_T("Verify None"));
    m_verifyMode.InsertString(0, _T("Verify None"));
    m_verifyMode.InsertString(1, _T("Verify Server"));

    return TRUE;  
}

void demoSetCAVerifyInfoDlg::OnBnClickedOk()
{
    int iMode = m_verifyMode.GetCurSel();
    if (iMode < 0 || iMode > 1)
    {
        iMode = 0;
    }

    hwmsdkagent::HwmCAVerifyInfo info{};
    info.verifyMode = static_cast<hwmsdkagent::HwmVerifyMode>(iMode);

    CString certPathCString;
    m_certPathEdit.GetWindowText(certPathCString);
    std::string certPath = CTools::UNICODE2UTF(certPathCString.GetString());
    errno_t res = strcpy_s(info.certPath, sizeof(info.certPath), certPath.c_str());
    if (res != 0)
    {
        AfxMessageBox(_T("certPath copy error"));
    }

    int ret = hwmsdkagent::SetCAVerifyInfo(&info);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("SetCAVerifyInfo error, ret=" + std::to_string(ret));
        return;
    }

    CDialogEx::OnOK();
}