﻿/**
 * @file HwmAgentDefReserved.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 结构体、枚举定义文件
 */

#ifndef _HWM_AGENT_DEF_RESERVED_H_
#define _HWM_AGENT_DEF_RESERVED_H_

#include "HwmAgentCallback.h"
#include "HwmAgentNotify.h"
#include "HwmAgentDef.h"

namespace hwmsdkagent
{
    /*********************************************以下是新添加的接口所需的参数*********************************************/
    /**
     * [en]This enum is used to describe attendee type
     * [cn]弹出窗口类型
     */
    typedef enum tagHwmPopupWindowType
    {
        NETWORK_CHECK_WND = 0,                                  /**< [en]Network check window
                                                                     [cn]网络检测窗口 */
        MEDIA_SETTING_WND,                                      /**< [en]Media setting window
                                                                     [cn]音视频设置界面 */
    } HwmPopupWindowType;

    /**
     * [en]Contact department info parameters.
     * [cn]联系人部门信息参数
     */
    typedef struct tagHwmContactDepartmentInfo
    {
        char departmentName[HWM_MAX_DEPARTMENT_INFO_LEN];       /**< [en]First part of contact department info
                                                                     [cn]联系人部门信息 */
        char expandInfo[HWM_MAX_DEPARTMENT_INFO_LEN];           /**< [en]Second part of contact department info
                                                                     [cn]联系人部门信息扩展部分 */
    } HwmContactDepartmentInfo;

    /**
     * [en]Contact department info parameters.
     * [cn]设置联系人信息参数
     */
    typedef struct tagHwmSetContactInfo
    {
        HwmContactDepartmentInfo contactDepartmentInfo;         /**< [en]Contact department info
                                                                     [cn]联系人部门信息 */
        char number[HWM_MAX_NUMBER_LEN];                        /**< [en]Contact sip number
                                                                     [cn]联系人号码 */
    } HwmSetContactInfo;

    /*
    * [cn]匿名链接入会需要的信息(新接口，需手机号验证)
    */
    typedef struct tagHwmAnonymousVerifyLinkConfInfo
    {
        char siteUrl[HWM_MAX_URL_LEN];                          /**< [en]Server address that parses from links
                                                                     [cn]根据链接解析出的服务器地址 */
        char random[HWM_MAX_RANDOM_LEN];                        /**< [en]Random num that parses from links
                                                                     [cn]根据链接解析出的随机数 */
        char name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Join conf name
                                                                     [cn]入会呢称 */
        char confIdPrefix[HWM_MAX_CONFID_PREFIX_LEN];           /**< [en]Prefix of site that belongs to conf id
                                                                     [cn]会议id所属站点的前缀 */
        char confId[HWM_MAX_CONF_ID_LEN];                       /**< [en]Conf id
                                                                     [cn]会议id, 离线入会时使用 */
        bool isOfflineJoin;                                     /**< [en]Indicates is offline join conf.
                                                                     [cn]是否离线入会 */
    } HwmAnonymousVerifyLinkConfInfo;

    /*
    * [cn]匿名id入会需要的信息(新接口，需手机号验证)
    */
    typedef struct tagHwmAnonymousIdConfInfo
    {
        char confId[HWM_MAX_CONF_ID_LEN];                       /**< [en]Conf id
                                                                     [cn]会议id */
        char password[HWM_MAX_CONF_PASSWORD_LEN];               /**< [en]Conf password
                                                                     [cn]会议密码 */
        char name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Join conf name
                                                                     [cn]入会呢称 */
    } HwmAnonymousIdConfInfo;

    /*
    * [cn]校验滑块并获取验证码需要的信息
    */
    typedef struct tagHwmCheckSliderAndGetVerifyCodeInfo
    {
        unsigned int pointX;                                    /**< [en]The point of X
                                                                     [cn]x坐标点 */
        long long slideTime;                                    /**< [en]Slider time
                                                                     [cn]滑动时间 */
    } HwmCheckSliderAndGetVerifyCodeInfo;

    /*
    * [cn]请求验证码或获取滑块需要的信息
    */
    typedef struct tagHwmRequestVerifyCodeOrGetSliderInfo
    {
        char phoneNumber[HWM_MAX_PHONE_NUM_LEN];                /**< [en]Phone number
                                                                     [cn]手机号 */
        char countryCode[HWM_MAX_COUNTRY_CODE_LEN];             /**< [en]CountryCode
                                                                     [cn]国家码 */
    } HwmRequestVerifyCodeOrGetSliderInfo;

    /**
    * [en]This structure is used to describe auto register mode.
    * [cn]自动注册模式
    */
    typedef enum tagHwmAutoRegisterMode
    {
        AUTO_REGISTER_MODE_DISABLED,         /**< [en]Indicates disabled.
                                                  [cn]不注册（默认） */
        AUTO_REGISTER_MODE_AUTO,             /**< [en]Indicates auto.
                                                  [cn]自动注册 */
        AUTO_REGISTER_MODE_REUSED,           /**< [en]Indicates reused.
                                                  [cn]不注册但支持使用已有账号（手机号匹配到的账号） */
    }HwmAutoRegisterMode;

    /*
    * [cn]根据验证码入会需要的信息
    */
    typedef struct tagHwmAnonymousJoinConfByVerifyCodeInfo
    {
        char verifyCode[HWM_MAX_VER_CODE_LEN];                  /**< [en]Verify code
                                                                     [cn]验证码 */
        HwmAutoRegisterMode autoRegMode;                        /**< [en]This structure is used to describe auto register mode
                                                                     [cn]自动注册模式 */
    } HwmAnonymousJoinConfByVerifyCodeInfo;

    /*
    * [cn]ctd会议与会者信息(入会前)
    */
    typedef struct tagHwmCtdConfAttendeeInfo
    {
        char number[HWM_MAX_NUMBER_LEN];                        /**< [en]Indicates number.
                                                                     [cn]号码 */
        char name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Indicates name.
                                                                     [cn]可选，与会者名称 */
        char aliasCN[HWM_MAX_DISPLAY_NAME_LEN];                 /**< [en]Indicates chinese alias.
                                                                     [cn]可选，中文别名 */
        char aliasEN[HWM_MAX_DISPLAY_NAME_LEN];                 /**< [en]Indicates english alias.
                                                                     [cn]可选，英文别名 */
        char extendedField[HWM_MAX_EXTENDED_FIELD_LEN];         /**< [en]Indicates extended field.
                                                                     [cn]扩展字段 */
        char email[HWM_MAX_EMAIL_LEN];                          /**< [en]Indicates email.
                                                                     [cn]可选，电子邮箱地址 */
        char sms[HWM_MAX_PHONE_NUM_LEN];                        /**< [en]Indicates sms.
                                                                     [cn]可选，短信通知手机号码 */
        char acountId[HWM_MAX_ACCOUNT_LEN];                     /**< [en]Indicates account id.
                                                                     [cn]可选，华为云会议账号 */
        char userUuid[HWM_MAX_USER_NAME_LEN];                   /**< [en]Indicates user account
                                                                     [cn]与会唯一标识 */
    } HwmCtdConfAttendeeInfo;

    /**
     * [cn]预约ctd会议需要的信息(新内部接口)
     */
    typedef struct tagHwmCtdCallInfo
    {
        HwmCtdConfAttendeeInfo callerInfo;                      /**< [en]Ctd conf caller info.
                                                                     [cn]ctd会议呼叫者（主席） */
        HwmCtdConfAttendeeInfo calleeInfo;                      /**< [en]Ctd conf callee info.
                                                                     [cn]ctd会议被呼叫者（普通与会者） */
        char applicationsAttribute[HWM_MAX_APP_ATTRIBUTE_LEN];  /**< [en]Indicates appServer attribute
                                                                     [cn]第三方应用参数属性 */
    } HwmCtdCallInfo;

    /**
    * [en]This structure is used to One join conference by conference details.
    * [cn]一键入会
    */
    typedef struct tagHwmConfAccessInfo
    {
        char confId[HWM_MAX_CONF_ID_LEN];                       /**< [en]Conf id
                                                                     [cn]会议id */
        char password[HWM_MAX_CONF_PASSWORD_LEN];               /**< [en]Conf password
                                                                     [cn]会议密码 */
        char accessCode[HWM_MAX_CONF_ACCESS_LEN];               /**< [en]Conference access code
                                                                     [cn]会议接入码*/
        HwmConfMediaType confType;                              /**< [en]Conference Type
                                                                     [cn]会议类型*/
        bool isStopConflictConf;                                /**< [en]Is stop conflictConf.
                                                                     [cn]强制结束和当前VMR会议资源冲突的会议（必需是vmr资源的拥有者才有权限，否则无效）*/
        bool supportTerminal;                                   /**< [en]Indicates whether is support invite Terminal.
                                                                     [cn]是否邀请硬终端入会 */
    }HwmConfAccessInfo;

    /**
    * [en]Avatar Param
    * [cn]设置头像参数
    */
    typedef struct tagHwmAvatarParam
    {
        char number[HWM_MAX_NUMBER_LEN];                        /**< [en]number
                                                                     [cn]号码参数（number和thirdUserId二选一） */
        char thirdUserId[HWM_MAX_USER_ID_LEN];                  /**< [en]The third user id
                                                                     [cn]三方账号（number和thirdUserId二选一） */
        char avatarPath[HWM_MAX_FILE_PATH_LEN];                 /**< [en]avatar path
                                                                     [cn]头像路径 */
    }HwmAvatarParam;

    /**
     * [en]This enum is used to describe encrypt mode
     * [cn]加密类型
     */
    typedef enum tagHwmEncryptModeForWelink
    {
        ENCRYPT_MODE_AUTO = 0,                                  /**< [en]Indicates auto encrypt mode
                                                                     [cn]自适应加密 */
        ENCRYPT_MODE_MUST,                                      /**< [en]Indicates must encrypt mode
                                                                     [cn]强制加密 */
        ENCRYPT_MODE_NONE                                       /**< [en]Indicates none encrypt
                                                                     [cn]不加密 */
    } HwmEncryptModeForWelink;

    /**
     * [en]This enum is used to describe user type
     * [cn]用户类型
     */
    typedef enum tagHwmConfUserTypeForWelink
    {
        CONF_USER_TYPE_WEB = 0,                                 /**< [en]Indicates web type
                                                                     [cn]WEB方式 */
        CONF_USER_TYPE_PC                                       /**< [en]Indicates pc terminal
                                                                     [cn]PC软终端 */
    } HwmConfUserTypeForWelink;

    

    /**
     * [en]This enum is used to describe mediax conf type<br>
     * [cn]Mediax会议类型: 顺序必须和REST_E_CONF_MEDIAX_TYPE一致
     */
    typedef enum tagHwmMediaxConfTypeForWelink
    {
        MEDIAX_CONF_TYPE_INVALID = 0,                           /**< [en]Indicates invalid
                                                                     [cn]无效值 */
        MEDIAX_CONF_TYPE_SCHEDULE = 1,                          /**< [en]Indicates schedule conference
                                                                     [cn]预定会议 */
        MEDIAX_CONF_TYPE_MASS,                                  /**< [en]Indicates mass conference
                                                                     [cn]免预定会议 */
        MEDIAX_CONF_TYPE_SELF,                                  /**< [en]Indicates self conference
                                                                     [cn]自助会议 */
        MEDIAX_CONF_TYPE_ADHOC,                                 /**< [en]Indicates adhoc conference
                                                                     [cn]adHoc会议 */
        MEDIAX_CONF_TYPE_MCU,                                   /**< [en]Indicates MCU conference
                                                                     [cn]等同于ScheduleConference */
        MEDIAX_CONF_TYPE_PRIVATE,                               /**< [en]Indicates private conference
                                                                     [cn]个人专用会议 */
        MEDIAX_CONF_TYPE_TELEPRESENCE,                          /**< [en]Indicates telepresence
                                                                     [cn]智真视频会议，与MCU配套 */
        MEDIAX_CONF_TYPE_GROUP_CALL,                            /**< [en]Indicates group call
                                                                     [cn]GroupCall会议 */
        MEDIAX_CONF_TYPE_SMS_GROUP,                             /**< [en]Indicates SMS group
                                                                     [cn]短信群组业务 */
        MEDIAX_CONF_TYPE_GROUP_BROADCAST,                       /**< [en]Indicates group broadcast
                                                                     [cn]群组语音广播 */
        MEDIAX_CONF_TYPE_GROUP_PLAYBACK,                        /**< [en]Indicates group playback
                                                                     [cn]群组语音回放 */
        MEDIAX_CONF_TYPE_GROUP_ALARM,                           /**< [en]Indicates group alarm
                                                                     [cn]报警会议 */
        MEDIAX_CONF_TYPE_PLAY_BACK,                             /**< [en]Indicates conf playback
                                                                     [cn]会议录音回放 */
        MEDIAX_CONF_TYPE_ASSISTANT,                             /**< [en]Indicates conf assistant
                                                                     [cn]会议助手 */
        MEDIAX_CONF_TYPE_PERSONAL_VMR,                          /**< [en]Indicates personal VMR
                                                                     [cn]个人VMR */
        MEDIAX_CONF_TYPE_PROJECT_VMR,                           /**< [en]Indicates project VMR
                                                                     [cn]项目VMR */
        MEDIAX_CONF_TYPE_BUTT
    } HwmMediaxConfTypeForWelink;

    /**
     * [en]This struct is used to describe extra conference config info
     * [cn]会议其他配置信息
     */
    typedef struct tagHwmExtraConfigInfoForWelink
    {
        bool isGuestFreePwd;                                    /**< [en]Indicates whether is guest free password.
                                                                     [cn]是否来宾免密 */
        bool isSendNotify;                                      /**< [en]Indicates whether is send email notify.
                                                                     [cn]是否发送邮件通知 */
        bool isSendSms;                                         /**< [en]Indicates whether is send sms.
                                                                     [cn]是否发送短信通知 */
        bool isSendCalendarNotify;                              /**< [en]Indicates whether is send calendar notify.
                                                                     [cn]是否发送日历通知 */
        bool supportTerminal;                                   /**< [en]Indicates whether is support invite Terminal.
                                                                     [cn]是否邀请硬终端入会 */
        HwmJoinConfPermissionType callInRestriction;            /**< [en]Call in restriction.
                                                                     [cn]呼入限制 */
    } HwmExtraConfigInfoForWelink;

    /**
     * [en]This struct is used to describe attendee info(before join conference)
     * [cn]与会者信息(入会前)
     */
    typedef struct tagHwmAttendeeInfoForWelink
    {
        char number[HWM_MAX_NUMBER_LEN];                        /**< [en]Indicates number.
                                                                     [cn]号码 */
        char name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Indicates name.
                                                                     [cn]可选，与会者名称 */
        char email[HWM_MAX_EMAIL_LEN];                          /**< [en]Indicates email.
                                                                     [cn]可选，电子邮箱地址 */
        char sms[HWM_MAX_PHONE_NUM_LEN];                        /**< [en]Indicates sms.
                                                                     [cn]可选，短信通知手机号码 */
        char acountId[HWM_MAX_ACCOUNT_LEN];                     /**< [en]Indicates account id.
                                                                     [cn]可选，华为云会议账号 */
        char userUuid[HWM_MAX_DEVICE_UUID_LEN];                 /**< [en]Indicates user account
                                                                     [cn]与会唯一标识 */
        bool isMute;                                            /**< [en]Indicates whether is mute.
                                                                     [cn]是否闭音 */
        bool isAutoInvite;                                      /**< [en]Indicates whether is auto invite
                                                                     [cn]是否自动外邀 */
        HwmConfRole  role;                                      /**< [en]Indicates role.
                                                                     [cn]会议成员角色 */
        HwmAttendeeType type;                                   /**< [en]Indicates attendee type.
                                                                     [cn]成员类型 */
        char appId[HWM_MAX_ACCOUNT_LEN];                        /**< [en]App id.
                                                                     [cn]应用ID */
        char thirdAccount[HWM_MAX_ACCOUNT_LEN];                 /**< [en]Third account.
                                                                     [cn]第三方用户账号 */
        bool isHidePhone;                                       /**< [en]Indicates whether hide phone.
                                                                     [cn]隐藏手机号（新增参数） */   
    } HwmAttendeeInfoForWelink;

    /**
     * [en]This enumeration is used to describe the video window type.
     * [cn]视频窗口类型
     */
    typedef enum tagHwmVideoWndTypeForWelink
    {
        VIDEO_WND_TYPE_REMOTE = 0,                              /**< [en]Indicates remote call window
                                                                     [cn]通话远端窗口 */
        VIDEO_WND_TYPE_LOCAL,                                   /**< [en]Indicates local call window
                                                                     [cn]通话本地窗口 */
        VIDEO_WND_TYPE_PREVIEW,                                 /**< [en]Indicates preview window
                                                                     [cn]预览窗口 */
        VIDEO_WND_TYPE_DATA,                                    /**< [en]Indicates auxiliary data window
                                                                     [cn]辅流窗口 */
        CK_CONF_E_VIDEOWND_BUTT
    } HwmVideoWndTypeForWelink;

    /**
 * [en]This enum is used to describe conf res type
 * [cn]会议资源类型
 */
    typedef enum tagHwmConfResTypeForWelink
    {
        CONF_RESTYPE_DEFAULT = 0,                 /**< [en]default
                                                       [cn]默认*/
        CONF_RESTYPE_SHARE_VMR = 3,               /**< [en]share vmr
                                                       [cn]共享vmr*/
    } HwmConfResTypeForWelink;

    /**
     * [cn]会议摄像头设置
     */
    typedef struct tagHwmCameraDeviceSetForWelink
    {
        unsigned int captureIndex;                              /**< [en]Acquisition device (camera) index
                                                                     [cn]采集设备(摄像头)索引 */
        unsigned int captureRotation;                           /**< [en]Camera acquisition angle
                                                                     [cn]摄像头采集角度 {0,1,2,3} 仅对移动平台有效，默认为0 */
        unsigned int displayRotation;                           /**< [en]Video display direction
                                                                     [cn]视频显示方向 */
        HwmVideoWndTypeForWelink renderType;                    /**< [en]Video display type
                                                                     [cn]视频窗口类型 */
        bool isCamClose;                                        /**< [en]Is Closed
                                                                     [cn]是否关闭 */
    } HwmCameraDeviceSetForWelink;

    /**
     * [en]This struct is used to describe conference creating info(Instant conference)<br>
     * [cn]创会信息(立即会议)内部接口
     */
    typedef struct tagHwmCreateConfInfoForWelink
    {
        char  subject[HWM_MAX_SUBJECT_LEN];                     /**< [en]Indicates conference subject  ,this param is optional.
                                                                     [cn]可选，会议主题 */
        char  groupUri[HWM_MAX_GROUP_URI_LEN];                  /**< [en]Indicates group uri.
                                                                     [cn]可选，群组uri */
        bool  multiStreamFlag;                                  /**< [en]Indicates whether conference is multi-stream flag  ,this param is optional.
                                                                     [cn]可选，是否为多流视频会议 */
        unsigned int mediaType;                                 /**< [en]Indicates media type, value refer to CONFCTRL_E_CONF_MEDIATYPE_FLAG, can do "|" operate.
                                                                     [cn]媒体类型，取值参考CONFCTRL_E_CONF_MEDIATYPE_FLAG，可进行"|"操作 */
        HwmLanguage language;                                   /**< [en]Indicates default language of conference  ,this param is optional.
                                                                     [cn]可选，会议的默认语言 */
        HwmEncryptModeForWelink confEncryptMode;                /**< [en]Indicate conference media encrypt mode  ,this param is optional.
                                                                     [cn]可选，会议媒体加密模式  */
        HwmConfUserTypeForWelink userType;                      /**< [en]Indicates user type of conference created user  ,this param is optional.
                                                                     [cn]可选，创会用户的用户类型 */
        unsigned int numOfAttendee;                             /**< [en]Indicates attendee number.
                                                                     [cn]与会者个数 */
        HwmAttendeeInfoForWelink* attendee;                     /**< [en]Indicates attendee info.
                                                                     [cn]与会者信息 */
        char  timeZone[HWM_MAX_TIME_ZONE_LEN];                  /**< [en]Indicates time zone, optional, standard time zone for example "Asia/Shanghai" in PBX internal conference; Beijing is "56" in Mediax conference,refer to CONFCTRL_E_TIMEZONE.
                                                                     [cn]时区 */
        bool  noPassword;                                       /**< [en]Indicates whether conference need password. 0:need password; 1:no password.
                                                                     [cn]可选，是否需要密码. 0:需要密码; 1:无密码*/
        HwmMediaxConfTypeForWelink mediaxConfType;              /**< [en]Indicates mediax conference type.
                                                                     [cn]mediax会议类型*/
        unsigned int recordType;                                /**< [en]Indicates conference record type: 0.disable; 1.direct broadcast; 2.record; 3. record + direct broadcast.
                                                                     [cn]可选，录制类型：0.禁用；1.直播；2.录播；3.直播+录播 */
        bool  recordAuxStream;                                  /**< [en]Indicates whether record aux stream: 0.do not record; 1.record.
                                                                     [cn]可选，会议是否录制辅流：0.不录制；1.录制 */
        bool recordOperationMode;                               /**< [en]Record Operation
                                                                     是否自动录制： 1：手动 2：自动 */
        bool  vmrFlag;                                          /**< [en]Indicates whether is VMR conference,this param is optional.
                                                                     [cn]可选，是否是VMR会议. */
        char  vmrId[HWM_MAX_VMR_CONF_ID_LEN];                   /**< [en]Indicates VMR conference id . 
                                                                     [cn]VMR会议ID. 新会义as在vmr flag为1时选填 */
        HwmExtraConfigInfoForWelink  exConfigInfo;              /**< [en]Indicates extra config infomation .
                                                                     [cn]会议配置信息 */
        HwmCameraDeviceSetForWelink camDeviceSet;               /**< [en]Camera set
                                                                     [cn]摄像头设置 */
        bool isMicClose;                                        /**< [en]Micophone closed
                                                                     [cn]是否麦克风关闭 */
        bool isSpkClose;                                        /**< [en]Speaker Closed
                                                                     [cn]是否扬声器关闭 */
        unsigned int callId;                                    /**< [en]Call Id
                                                                     [cn]呼叫id，点对点转会议时候使用 */
        char applicationsAttribute[HWM_MAX_APP_ATTRIBUTE_LEN];  /**< [en]Indicates appServer attribute
                                                                     [cn]第三方应用参数属性 */
        char customInfo[HWM_MAX_CUSTOM_INFO_LEN];               /**< [en]Indicates User-defined extended information
                                                                     [cn]自定义扩展信息 */
        HwmConfResTypeForWelink confResType;                    /**< [en]Indicates conf res type
                                                                     [cn]会议资源类型 */
    } HwmCreateConfInfoForWelink;

    /**
     * [en]Number.
     * [cn]号码
     */
    typedef struct tagHwmNumber
    {
        char number[HWM_MAX_NUMBER_LEN];                        /**< [en]The number
                                                                     [cn]号码 */
    }HwmNumber;

    /**
     * [en]Other number info.
     * [cn]其他号码信息
     */
    typedef struct tagHwmOtherNumberInfo
    {
        HwmNumber* numbers;                                     /**< [en]The number
                                                                     [cn]号码 */
        unsigned int numberCount;                               /**< [en]The size of numbers
                                                                     [cn]号码个数 */
        char sipNumber[HWM_MAX_NUMBER_LEN];                     /**< [en]The sip number
                                                                     [cn]sip号码 */
        int hideType;                                           /**< [en]hide type
                                                                     [cn]号码隐藏类型(1: 显示号码, 2: 隐藏号码, 3: 打码号码) */
    }HwmOtherNumberInfo;

    /**
     * [en]Conf settings.
     * [cn]会中配置项
     */
    typedef enum tagHwmConfSettings
    {
        HWM_CONF_SETTINGS_HOWLING_DETECTION,                    /**< [en]Howling
                                                                     [cn]啸叫检测开关 */
        HWM_CONF_SETTINGS_ANC,                                  /**< [en]ANC
                                                                     [cn]音频降噪开关 */
        HWM_CONF_SETTINGS_BEAUTY,                               /**< [en]Beatuty
                                                                     [cn]美颜开关 */
        HWM_CONF_SETTINGS_HIGH_RESOLUTION,                      /**< [en]High Resolution
                                                                     [cn]1080P开关 */
        HWM_CONF_SETTINGS_VQE,                                  /**< [en]VQE
                                                                     [cn]使用原始语音开关 */
        HWM_CONF_SETTINGS_HIGH_RESOLUTION_SVC_MODE,             /**< [en]High Resolution svc mode
                                                                     [cn]高分辨率多流模式开关 */
        HWM_CONF_SETTINGS_PNR,                                  /**< [en]PNR
                                                                     [cn]声纹降噪开关 */
    } HwmConfSettings;

    /**
    * [en] Nonce conf info
    * [cn] nonce入会参数
    */
    typedef struct tagHwmJoinConfByNonceInfo
    {
        char nonce[HWM_MAX_NONCE_LEN];                          /**< [en]nonce
                                                                     [cn]随机数 */
        char confId[HWM_MAX_CONF_ID_LEN];                       /**< [en]Conf id
                                                                     [cn]会议id */
        char password[HWM_MAX_CONF_PASSWORD_LEN];               /**< [en]Conf password
                                                                     [cn]会议密码 */
        char name[HWM_MAX_USER_NAME_LEN];                       /**< [en]Join conf name
                                                                     [cn]入会呢称 */
    }HwmJoinConfByNonceInfo;

    /**
    * [en] Client type
    * [cn] 客户端类型
    */
    typedef enum tagHwmClientType
    {
        CLIENT_WIN = 0,                                   /**< [en]Indicates win.
                                                               [cn]win平台 */
        CLIENT_SMARTROOMS = 8,                            /**< [en]Indicates smartrooms.
                                                               [cn]smartrooms */
        CLIENT_TYPE_BUTT
    }HwmClientType;

    /**
    * [en] Extend conf duration info
    * [cn] 延长会议时长信息
    */
    typedef struct tagHwmExtendConfDurationInfo
    {
        unsigned int duration;               /**< [en]Duration
                                                  [cn]延长会议时长 */
    }HwmExtendConfDurationInfo;

    // CPU 阈值信息
    typedef struct tagHwmCpuThresholdInfo
    {
        unsigned int above;
        unsigned int belowSlow;
        unsigned int belowQuick;
    }HwmCpuThresholdInfo;

    /**
    * [en]Capability type.
    * [cn]能力类型
    */
    typedef enum tagHwmCapabilityType
    {
        HWM_CAPABILITY_SUPPORT_TO_BE_COHOST,            /**< [en]Is support to be cohost.
                                                             [cn]是否支持被设置为联席主持人 */
        HWM_CAPABILITY_SUPPORT_INVITED_SHARING,         /**< [en]Is support invited sharing.
                                                             [cn]是否支持被邀请共享 */
        HWM_CAPABILITY_SUPPORT_MOVED_TO_WAITING_ROOM,   /**< [en]Is support moved to waiting room.
                                                             [cn]是否支持被移入等候室 */
        HWM_CAPABILITY_SUPPORT_INVITED_OPEN_MIC_TIPS,   /**< [en]Is support invited to open the microphone tips.
                                                             [cn]是否支持被邀请打开麦克风提醒，
                                                                 设置为不支持时主持人对本端取消静音时直接打开麦克风*/
        HWM_CAPABILITY_SUPPORT_INVITED_OPEN_CAM,        /**< [en]Is support invited to open/close the camera.
                                                             [cn]是否支持被邀请打开摄像头和关闭摄像头*/
        HWM_CAPABILITY_SUPPORT_PRIVATE_CHAT,            /**< [en]Is support private chat.
                                                             [cn]是否支持私聊 */
        HWM_CAPABILITY_SUPPORT_CLIENT_LOCAL_RECORDING,  /**< [en]Is support client local recording.
                                                             [cn]是否支持客户端本地录制，
                                                                 设置为不支持时需要同步在Config里面配置隐藏录制按钮*/
        HWM_CAPABILITY_SUPPORT_ANONYMOUS_USE_PNR,       /**< [en]Is support anonymous use pnr.
                                                             [cn]是否支持匿名用户使用声纹降噪 */
        HWM_CAPABILITY_SUPPORT_REQUEST_CLOUD_RECORD,    /**< [en]Is support request cloud record.
                                                             [cn]是否支持请求云录制 */
        HWM_CAPABILITY_SUPPORT_REQUEST_LOCAL_RECORD,    /**< [en]Is support request local record.
                                                             [cn]是否支持请求本地录制 */
        HWM_CAPABILITY_SUPPORT_ADD_VRBK_IMAGE,          /**< [en]Is support add vrbk image.
                                                             [cn]是否支持添加虚拟背景图 */
        HWM_CAPABILITY_SUPPORT_WAITING_ROOM_CHAT,       /**< [en]Is support waiting room chat.
                                                             [cn]是否支持等候室聊天 */
        HWM_CAPABILITY_SUPPORT_COMPLAIN,                /**< [en]Is support complain.
                                                             [cn]是否支持举报 */
        HWM_CAPABILITY_SUPPORT_P2P_MINI_WINDOW,         /**< [en]Is support p2p mini window.
                                                             [cn]是否支持点对点迷你窗口 */
        HWM_CAPABILITY_BUTT
    } HwmCapabilityType;

    typedef struct tagHwmUtilsSmartRoomParam
    {
        char macAddr[HWM_MAX_MAC_LEN];                   /**< [en]Indicates the mac address information.
                                                              [cn]Mac地址信息
                                                              [cs_allowNull:Y][cs_length:1-32] */
    }HwmUtilsSmartRoomParam;

    /**
    * [en]Ctd Mode.
    * [cn]ctd模式
    */
    typedef enum tagHwmCtdMode
    {
        HWM_CTD_MODE_VOIP,              //网络直呼
        HWM_CTD_MODE_CALL_BACK,         //自动回呼
        HWM_CTD_MODE_BUTT
    }HwmCtdMode;

    // 回呼号码信息
    typedef struct tagHwmCtdCallNumberInfo
    {
        char country[HWM_MAX_COUNTRY_LEN];
        HwmCtdMode callMode;
        char callBackNumber[HWM_MAX_PHONE_NUM_LEN];
    }HwmCtdCallNumberInfo;

    /**
    * [en]This struct is used to describe query doc dictionary info<br>
    * [cn]查询文档结果
    */
    typedef struct tagHwmDocFileInfo
    {
        long long   fileId;                           /**< [en]Indicates limit fileId. [cn]文件id  */
        char        fileGuid[HWM_MAX_CONF_UUID_LEN];  /**< [en]Indicates file guid. [cn]文件guid  */
        char        name[HWM_MAX_NAME_LEN];           /**< [en]Indicates file or dic name. [cn]文件/文件夹名字 */
        long long   parentId;                         /**< [en]Indicates limit fileId. [cn]parent文件id  */
    }HwmDocFileInfo;

    /**
    * [en]This struct is used to describe query doc dictionary result<br>
    * [cn]申请协作权限
    */
    typedef struct tagHwmApplyDocOperRightResult
    {
        char        tempAccessUrl[HWM_MAX_URL_LEN];            /**< [en]Indicates tempAccessUrl. [cn]临时授权访问url**/
    }HwmApplyDocOperRightResult;

    /***
    * [en]cloud desktop mode.
    * [cn]云桌面模式
    */
    typedef enum tagClientMode
    {
        CLIENT_DEFAULT,
        CLIENT_CLOUD_DESKTOP
    }HwmClientMode;

    /**
    * [en]concurrent resources.
    * [cn]并发资源
    */
    typedef struct tagHwmConcurrentResource
    {
        bool isValid;                                          /**< [en]is valid
                                                                    [cn]是否有效 */
        char expireDate[HWM_MAX_EXPIRE_DATE_LEN];              /**< [en]expire date
                                                                    [cn]截止时间 */
    }HwmConcurrentResource;

    /**
    * [en]vmr resource
    * [cn]vmr会议资源
    */
    typedef struct tagHwmVmrResource
    {
        bool    isValid;                                       /**< [en]is valid
                                                                    [cn]是否有效 */
        char    vmrId[HWM_MAX_VMR_ID_LEN];                     /**< [en]vmrid
                                                                    [cn]vmrid */
        char    vmrConfId[HWM_MAX_VMR_CONF_ID_LEN];            /**< [en]vmr conf id
                                                                    [cn]vmr会议id */
        char    expireDate[HWM_MAX_EXPIRE_DATE_LEN];           /**< [en]expire date
                                                                    [cn]截止时间 */
        char    guestPwd[HWM_MAX_CONF_PASSWORD_LEN];           /**< [en]guest password
                                                                    [cn]来宾密码 */
        unsigned int   maxParties;                             /**< [en]max parties
                                                                    [cn]并发方数 */
        unsigned int   duration;                               /**< [en]duration
                                                                    [cn]持续时间(分钟, 最大1440), 0-不限制*/
        unsigned int   status;                                 /**< [en]status
                                                                    [cn]0-正常状态 1-停用状态 2-已到期 */
    }HwmVmrResource;

    /**
    * [en]access resource
    * [cn]接入账号资源
    */
    typedef struct tagHwmAccessAccountResource
    {
        unsigned int   status;                                 /**< [en]status
                                                                    [cn]0-正常状态 1-停用状态 */
        char    expireDate[HWM_MAX_EXPIRE_DATE_LEN];           /**< [en]expire date
                                                                    [cn]截止时间 */
    }HwmAccessAccountResource;

    /**
    * [en]device resource
    * [cn]设备资源
    */
    typedef struct tagHwmDeviceResource
    {
        HwmConcurrentResource concurrentResource;           /**< [en]concurrent resources
                                                                 [cn]并发资源 */
        HwmVmrResource vmrResource;                         /**< [en]vmr resource
                                                                 [cn]vmr会议资源, 可能是免费配送, 也可能是商用资源 */
        HwmAccessAccountResource accessAccountResource;     /**< [en]access account resource
                                                                 [cn]接入账号资源 */
        bool    isResourceExpireNotify;                     /**< [en]is resource expire notify
                                                                 [cn]资源过期是否提醒, false: 不提醒 true: 即将到期提醒 */
        unsigned int   resourceStatus;                      /**< [en]resource status
                                                                 [cn]0-正常状态 1-只能加入会议（接入正常，无并发、vrm资源） 2-完全停用状态 */
        bool    isEnableShareVmr;                           /**< [en]is shard vmr notify
                                                                 [cn]共享vmr */
    }HwmDeviceResource;

    /**
    * [en]Default Sharing Frame Rate Options
    * [cn]默认共享帧率选项
    */
    typedef enum tagHWMShareFrameRateType
    {
        SHARE_FRAME_RATE_30,                                /**< [en]set to 30 fps
                                                                 [cn]默认帧率设置为30帧/秒 */
        SHARE_FRAME_RATE_20,                                /**< [en]set to 20 fps
                                                                 [cn]默认帧率设置为20帧/秒 */
        SHARE_FRAME_RATE_15,                                /**< [en]set to 15 fps
                                                                 [cn]默认帧率设置为15帧/秒 */
        SHARE_FRAME_RATE_10,                                /**< [en]set to 10 fps
                                                                 [cn]默认帧率设置为10帧/秒 */
        SHARE_FRAME_RATE_5,                                /**< [en]set to 5 fps
                                                                 [cn]默认帧率设置为5帧/秒 */
        SHARE_FRAME_RATE_1,                                /**< [en]set to 1 fps
                                                                 [cn]默认帧率设置为1帧/秒 */
    }HWMShareFrameRateType;


    /**
    * [en]This struct is used to describe query doc access url result<br>
    * [cn]查询文档链接结果
    */
    typedef struct tagHwmQueryDocAccessUrlResult
    {
        char        docAccessUrl[HWM_MAX_URL_LEN];            /**< [en]Indicates doc access url. [cn]文档权限链接**/
        char        folderGuid[HWM_MAX_NAME_LEN];             /**< [en]Indicates folder guid. [cn]文件夹id**/
    }HwmQueryDocAccessUrlResult;

    /**
    * [en]This struct is used to describe query doc access url result<br>
    * [cn]查询企业部门信息结果
    */

    typedef struct tagHwmSetCorpDepartmentInfo
    {
        unsigned int userNumberCount;                         /**< [en]The size of userNumber
                                                                   [cn]号码个数 */
        HwmNumber* userNumber;                                /**< [en]User number
                                                                   [cn]用户号码 */
        int hideType;                                         /**< [en]Hide type.
                                                                   [cn]号码隐藏类型(1: 显示号码, 2: 隐藏号码, 3: 打码号码) */
        char departmentInfo[HWM_MAX_APP_WND_TITLE_LEN];       /**< [en]Department info.
                                                                   [cn]部门信息 */
        char sipNumber[HWM_MAX_NUMBER_LEN];                   /**< [en]sip Number.
                                                                   [cn]sip号码 */
        char email[HWM_MAX_EMAIL_LEN];                        /**< [en]email.
                                                                   [cn]邮箱 */
        char name[HWM_MAX_USER_NAME_LEN];                     /**< [en]name.
                                                                   [cn]用户名 */
        char mobile[HWM_MAX_PHONE_NUM_LEN];                   /**< [en]mobile.
                                                                   [cn]手机号码 */
    }HwmSetCorpDepartmentInfo;


    /**
    * [en]Ut event public param.
    * [cn]打点公共参数
    */
    typedef struct tagHwmUTEventPublicParam
    {
        char version[HWM_MAX_VERSION_LEN];                     /**< [en]Indicates the software version.
                                                                    [cn]终端软件版本号
                                                                    [cs_allowNull:Y][cs_length:1-16] */
        char appId[HWM_MAX_APPID_LEN];                         /**< [en]Indicates the app id.
                                                                    [cn]应用标识，服务器提供平台绑定应用，目前服务器暂不支持，所以暂时填充应用名称，具体为：应用名称 华为会议设置为CloudLink、workplace这边设置为WeLink、opensdk集成使用集成商提供的名称+SDK类型 例如：正集源OKODM：AndroidNativeSDK, AndroidUISDK, iOSNativeSDK, iOSUISDK, WindowsNativeSDK, WindowsUISDK, WebSDK
                                                                    [cs_allowNull:Y][cs_length:1-64] */
        char osName[HWM_MAX_OPERATE_SYSTEM_NAME_LEN];          /**< [en]Indicates the operate system name.
                                                                    [cn]系统名称
                                                                    [cs_allowNull:Y][cs_length:1-16] */
        char tenantId[HWM_MAX_TENANT_ID_LEN];                  /**< [en]Indicates the tenant ID.
                                                                    [cn]租户id，用于welink
                                                                    [cs_allowNull:Y][cs_length:1-256] */
        char channelId[HWM_MAX_DEVICE_ID_LEN];                 /**< [en]Indicates the channel ID.
                                                                    [cn]渠道id
                                                                    [cs_allowNull:Y][cs_length:1-128] */
    }HwmUTEventPublicParam;


    /**
    * [en]User track param.
    * [cn]用户打点轨迹参数
    */
    typedef struct tagHwmUserTrackParam
    {
        char eventId[HWM_MAX_EVENT_ID_LEN];                     /**< [en]Indicates the event ID.
                                                                     [cn]预定义的事件ID
                                                                     [cs_allowNull:N][cs_length:1-16] */
        char arg1[HWM_MAX_ARG1_LEN];                            /**< [en]Indicates the first argument.
                                                                     [cn]单个事件中需要快速提取进行统计的字段(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                                     [cs_allowNull:Y][cs_length:0-256] */
        char arg2[HWM_MAX_ARG2_LEN];                            /**< [en]Indicates the second argument.
                                                                     [cn]单个事件中需要快速提取进行统计的字段(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                                     [cs_allowNull:Y][cs_length:0-256] */
        char arg3[HWM_MAX_ARG3_LEN];                            /**< [en]Indicates the third argument.
                                                                     [cn]单个事件中需要快速提取进行统计的字段(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                                     [cs_allowNull:Y][cs_length:0-256] */
        char args[HWM_MAX_ARG_LEN];                             /**< [en]Indicates the other argument.
                                                                     [cn]事件中其他字段，内容为json体,key跟value自定义(需要各个打点事件根据实际情况使用，不一定需要用到)
                                                                     [cs_allowNull:Y][cs_length:0-8192] */
        unsigned int maxIntervalMs;                             /**< [en]max interval for finishEvent.
                                                                     [cn]统计时长的最大时间间隔，单位为毫秒，FinishEvent传递该值，如果统计超过该时间间隔则不打点 */
    }HwmUserTrackParam;

    /**
    * [en]event key info.
    * [cn]打点事件 key 信息
    */
    typedef struct tagHwmEventKeyInfo
    {
        char eventName[HWM_MAX_EVENT_NAME_LEN];            /**< [en]Indicates the event name.
                                                                [cn]事件名称
                                                                [cs_allowNull:N][cs_length:1-256] */
    }HwmEventKeyInfo;

    /**
    * [en]app auth info.
    * [cn]App鉴权信息
    */
    typedef struct tagHwmAppAuthInfo
    {
        char corpId[HWM_MAX_CORP_ID_LEN];          /**< [en]Corporation Id
                                                        [cn]企业Id*/
        char userId[HWM_MAX_USER_ID_LEN];          /**< [en]user id.
                                                        [cn]用户ID */
        char signature[HWM_MAX_SIGNATURE_LEN];     /**< [en]The signature
                                                        [cn]鉴权信息 */
        char nonce[HWM_APPID_NONCE_LEN];           /**< [en]The nonce
                                                        [cn]随机字符串，用于计算鉴权信息 */
        long long expireTime;                      /**< [en]The expire time(s)
                                                        [cn]鉴权信息时间戳（s） */
    }HwmAppAuthInfo;

    /**
    * [en]Anonymous join conf by signature info.
    * [cn]安全会议匿名入会需要的信息
    */
    typedef struct tagHwmAnonymousSignatureConfInfo
    {
        char confId[HWM_MAX_CONF_ID_LEN];                /**< [en]Conf id
                                                              [cn]会议id */
        char password[HWM_MAX_CONF_PASSWORD_LEN];        /**< [en]Conf password
                                                              [cn]会议密码 */
        char confRandom[HWM_MAX_RANDOM_LEN];             /**< [en]Indicates conference random.
                                                              [cn]会议随机数，用于直接使用会议随机数入会，等同于会议ID+会议密码，公司局快速匿名入会场景使用 */
        char name[HWM_MAX_DISPLAY_NAME_LEN];             /**< [en]name
                                                              [cn]会场名 */
        char aliasCN[HWM_MAX_DISPLAY_NAME_LEN];          /**< [en]Indicates chinese alias.
                                                              [cn]中文别名 */
        char aliasEN[HWM_MAX_DISPLAY_NAME_LEN];          /**< [en]Indicates english alias.
                                                              [cn]英文别名 */
        char extendedField[HWM_MAX_EXTENDED_FIELD_LEN];  /**< [en]Indicates extended field.
                                                              [cn]扩展字段 */
        bool isCloseSpk;                                 /**< [en]is close loudspeaker
                                                              [cn]是否关闭扬声器 */
        HwmAppAuthInfo appAuthInfo;                      /**< [en]app auth info
                                                              [cn]app鉴权信息 */
    }HwmAnonymousSignatureConfInfo;
}
#endif /* _HWM_AGENT_DEF_H_ */
