﻿/**
 * @file HwmAgentNotifyReserved.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] Notify class file.
 *        [cn] 通知类(供welink使用)
 */

#ifndef _HWM_AGENT_NOTIFY_RESERVED_H_
#define _HWM_AGENT_NOTIFY_RESERVED_H_

#include "HwmAgentDef.h"
#include "HwmAgentNotifyDef.h"
#include "HwmAgentNotify.h"
#include "HwmAgentNotifyDefReserved.h"

namespace hwmsdkagent
{
    //通知类
    class HwmAgentNotifyReserved
    {
    public:
        /**
        * @brief [en] query other number notify
        *        [cn] 查询其他号码通知
        *
        * @param [in] hWnd                      [en] window handle
        *                                       [cn] 窗口句柄
        * @param [in] number                    [en] number
        *                                       [cn] 号码
        * @param [in] name                      [en] name
        *                                       [cn] 名字
        * @param [in] isAnonymous               [en] is Anonymous
        *                                       [cn] 是否匿名
        */
        virtual void OnQueryOtherNumber(unsigned int hWnd, const char* number, const char* name, bool isAnonymous) {};

        /**
        * @brief[en] Notify of query other number info
        *       [cn] 请求其他号码
        *
        * @param complainInfo [type:HwmQueryOtherNumberInfo*]
        * [en] Query other number info
        * [cn] 请求其他号码信息
        *
        * @mac:disable
        */
        virtual void OnQueryOtherNumberNotify(const HwmQueryOtherNumberInfo* queryOtherNumberInfo) {};

        /**
        * @brief [en] query avatar notify
        *        [cn] 查询头像通知
        *
        * @param [in] number                    [en] number
        *                                       [cn] 号码        
        */
        virtual void OnQueryAvatar(const char* number) {};

        /**
        * @brief [en] query avatar notify
        *        [cn] 查询头像通知
        *
        * @param [in] contactInfo                      [en] Query external avatar contact info
        *                                              [cn] 查询外部头像的联系人信息
        *
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnQueryAvatarNotify(const HwmContactInfo* contactInfo) {};

        /**
        * @brief [en] meeting config notify
        *        [cn] 会议配置项下发
        *
        * @param [in] meetingConfig             [en] meeting config
        *                                       [cn] 会议配置项
        */
        virtual void OnMeetingConfig(const char* meetingConfig) {};

        /**
         * @brief [en] conf list notify. when login / bookconf / cancelconf, will receive this notify
         *        [cn] 会议列表通知，预约会议或者获取会议列表时收到此通知，更新会议列表(添加三个url)
         *
         * @param [in] HwmConflistUpdateType updateType                                 [en] Update type of conf list
         *                                                                              [cn] 会议信息更新类型
         * @param [in] const HwmConfListInfoForWelink *confInfoListForWelink            [en] conf info list
         *                                                                              [cn] 会议信息列表
         * @param [in] unsigned int confInfoLen                                         [en] the size of conf list
         *                                                                              [cn] 会议信息列表长度
         */
        virtual void OnConfListForWelink(HwmConflistUpdateType updateType, const HwmConfListInfoForWelink *confInfoListForWelink, unsigned int confInfoLen) {};

        /**
        * @brief [en] refresh login result notify. when refresh login result, will receive this notify
        *        [cn] 刷新登陆结果通知
        *
        * @param [in] confToken                 [en] conf token
        *                                       [cn] 会议token
        * @param [in] isUsgEnable               [en] is usg enable
        *                                       [cn] usg是否可用
        * @param [in] isCallEnable              [en] is call enable
        *                                       [cn] 呼叫是否可用
        */
        virtual void OnRefreshLoginResult(const char* confToken, int isUsgEnable, int isCallEnable, bool basicCallAbility) {};

        /**
        * @brief [en] refresh login result notify. when refresh login result, will receive this notify
        *        [cn] 刷新登陆结果通知
        *
        * @param [in] const HwmLoginResult* loginResult                 [en] login result
        *                                                               [cn] 登录结果
        */
        virtual void OnRefreshLoginResult(const HwmRefreshLoginResult* loginResult) {};

        /**
        * @brief [en] Annotion state updata notify. when annotion state is updated, will receive this notify
        *        [cn] 标注状态变更通知,当标注状态发生更新时会收到该通知
        *
        * @param [in] state                     [en] annotion state
        *                                       [cn] 标注状态
        */
        virtual void OnAnnotationStateUpdataNotify(int state) {};

        /**
        *@brief[en] Notify of mic input level change
        *[cn] 麦克风输入等级变化通知
        *
        * @param[in] level                      [en] level.
        *                                       [cn] 输入等级
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnMicInputLevelChange(unsigned int level) {};

        /**
        * @brief [en] Notify of speaker output level change
        *        [cn] 扬声器输出等级变化通知
        *
        * @param [in] level                     [en] level.
        *                                       [cn] 输出等级
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnSpeakerOutputLevelChange(unsigned int level) {};

        /**
        *@brief[en] Notify of mic level change
        *[cn] 麦克风音柱变化通知
        *
        * @param[in] unsigned int level         [en] Mic level.
        *                                       [cn] 音柱等级
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnMicLevelChange(unsigned int level) {};

        /**
        *@brief[en] Notify of attendee count change
        *[cn] 与会者人数变化通知
        *
        * @param[in] const HwmAttendeeCountInfo* info [en] Attendee countinfo.
        *                                             [cn] 与会者人数信息
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnAttendeeCountChange(const HwmAttendeeCountInfo* info) {};


        /**
        *@brief[en] Notify of join vmr conf conflict info
        *[cn] 加入vmr会议冲突信息上报
        *
        * @param[in] const HwmConfConflictInfo* info [en] conflict vmr conf info.
        *                                            [cn] 冲突的vmr会议信息
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnJoinVmrConfConflictInfoNotify(const HwmConfConflictInfo* info) {};

        /**
        * @brief [en] Notify of Reserved inject btn.
        *        [cn] 点击注入保留按钮通知
        *
        * @param [in] HwmReservedClickInjectBtn injectBtn     [en] Button type
        *                                                     [cn] 按钮类型
        * @param [in] void* data                              [en] Notify data
        *                                                     [cn] 通知所带参数
        * @param [in] const char* id                          [en] User custome menu id
        *                                                     [cn] 用户自定义菜单id
        * @attention [en] NA
        *            [cn] NA
        **/
        virtual void OnClickReservedInjectBtn(HwmReservedClickInjectBtn injectBtn, void* data, const char* id) {};

        /**
        * @brief [en] Notify of extend conf duration
        *        [cn] 会议即将结束，需要延长会议时间的通知
        *
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnExtendConfNotify() {};

        /**
        * @brief [en] Notify of application info
        *        [cn] 收到会议应用通知消息
        *
        * @param [in] const char* applicationJsonInfo         [en] application json info
        *                                                     [cn] 应用信息 json字符串
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnApplicationNotify(const char* applicationJsonInfo) {};

        /**
        * @brief [en] Notify of query corp department info
        *        [cn] 批量查询部门信息通知
        * @param [in] queryInfoList                           [en] query info list
        *                                                     [cn] 查询信息列表
        * @param [in] queryInfoLen                            [en] the length of query info list
        *                                                     [cn] 查询信息长度
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnQueryCorpDepartmentInfo(HwmQueryCorpDepartmentInfoParam* queryInfoList, unsigned int queryInfoLen) {};

        /**
        * @brief
        * [en] Notify of contact avatar changed
        * [cn] 联系人头像变更通知
        *
        * @detail
        * [en]
        * [cn] 收到该通知时，表示联系人头像发生了变化
        *
        * @param avatarInfo [type:HwmContactAvatarInfo*]
        * [en] Contact avatar info.
        * [cn] 联系人头像信息
        *
        * @mac:disable
        */
        virtual void OnContactAvatarChanged(const HwmContactAvatarInfo* avatarInfo) {};

        /**
        *@brief[en] Notify of server domain strategy
        *[cn] 域名策略变化通知
        *
        * @param[in] const HwmServerDomainStrategy* domainStrategy [en] domain strategy.
        *                                                          [cn] 域名策略信息
        * @attention [en] Reserved
        *            [cn] 保留通知
        */
        virtual void OnServerDomainStrategyNotify(const HwmServerDomainStrategy* domainStrategy) {};

        /**
        * @brief
        * [en]This class is about audio quality notify.
        * [cn]音频质量通知
        *
        * @param info[type:AudioQualityInfo*]
        * [en]audio quality info
        * [cn]音频质量信息
        * @see AudioQualityInfo
        *
        * @return [type:HWM_VOID]
        */
        virtual void OnAudioQualityNotify(const AudioQualityInfo* info) {};

        /**
        * @brief [en] Notify of proxy account info changed
        *        [cn] 代理账号信息变更通知
        *
        * @param [in] HwmProxyAccountInfo* accountInfo     [en] proxy account info
        *                                                  [cn] 代理账号信息
        * @mac:disable
        */
        virtual void OnProxyAccountInfoChanged(const HwmProxyAccountInfo* accountInfo) {};

        /**
        * @brief [en]Notify of conf event info
        *        [cn]会中事件信息上报通知
        *
        * @param eventInfo [type:HWM_CHAR*]
        * [en] Conf state info
        * [cn] 会议状态信息
        */
        virtual void OnConfEventInfoNotify(const char* eventInfo) {};

        /**
        * @brief [en] Notify of scan join conf result
        *        [cn] 扫码入会通知
        *
        * @param scanJoinConfResult [type:HwmScanJoinConfResult*]
        * [en] scan join conf result info
        * [cn] 扫码入会结果信息
        *
        * @mac:disable
        */
        virtual void OnScanInfoForJoinConfNotify(const HwmScanJoinConfResult* scanJoinConfResult) {};
        /**
        * @brief [en] meeting config notify
        *        [cn] 跟随高级参数返回的会议配置项
        *
        * @param meetingConfig [type:HWM_CHAR*]
        * [en] json config
        * [cn] json配置
        */
        virtual void OnAppCfgChanged(const char* meetingConfig) {};

        /**        
        * @brief [en] Notify of pair verify code.        
        *        [cn] 配对验证码通知        
        *        
        * @param pairVerifyCodeInfo [type:HwmPairVerifyCodeInfo*]        
        * [en] Pair verify code info        
        * [cn] 配对验证码        
        *        
        * @js:disable        
        * @mac:disable        
        */
        virtual void OnPairVerifyCodeNotify(const HwmPairVerifyCodeInfo* pairVerifyCodeInfo) {};

        /**        
        * @brief [en] Notify of pair link list.        
        *        [cn] 配对链路列表通知        
        *        
        * @param pairLinkListInfo [type:HwmPairLinkListInfo*]        
        * [en] Pair link list info        
        * [cn] 配对链路列表        
        *       
        * @js:disable        
        * @mac:disable        
        */
        virtual void OnPairLinkListNotify(const HwmPairLinkListInfo* pairLinkListInfo) {};

        /**        
        * @brief [en] Notify of msg from pair link.        
        *        [cn] 配对链路中消息上报        
        *        
        * @param msgInfo [type:HWM_CHAR*]        
        * [en] 消息信息        
        * [cn] Msg info        
        *        
        * @js:disable        
        * @mac:disable        
        */
        virtual void OnRecvMsgFromPairLinkNotify(const char* msgInfo) {};

        /**
        * @brief [en] Notify of pair link suceess.
        *        [cn] 配对链路成功通知
        *
        * @js:disable
        * @mac:disable
        */
        virtual void OnPairLinkSuccessNotify() {};

        /**
        * @brief [en] Notify of request media separate log
        *        [cn] 请求媒体分离日志，拷贝日志操作的通知
        *
        * @param ret [type:HwmErrorResult*]        * [en] operate result        * [cn] 操作结果
        *
        * @mac:disable
        **/
        virtual void OnRequestMediaSeparateLogNotify(const HwmErrorResult* ret) {};

        /**
         * @brief [en] Notify of proxy info change
         *        [cn] 代理信息变化通知
         *
         * @param info [type:HwmProxyInfo*]        * [en] proxy info.        * [cn] 代理信息
         *
         * @mac:disable
         */
        virtual void OnProxyInfoChange(const HwmProxyInfo* info) {};

        /**
        * @brief
        * [en] Notice of abnormal leave meeting
        * [cn] 异常断开的会议通知
        *
        * @param abnormalLeaveMeetingInfo [type:HwmAbnormalLeaveMeetingInfo*]
        * [en] Abnormal leave meeting info
        * [cn] 异常断开的会议信息
        *
        * @js:disable
        */
        virtual void OnAbnormalLeaveMeetingNotify(const HwmAbnormalLeaveMeetingInfo* abnormalLeaveMeetingInfo) {};

        /**
        * @brief [en] Notify external invitee of invite、hangup 、recall or call other 
        *        [cn] 外部与会者的邀请、挂断、重呼、呼叫其他号码等操作的通知
        *
        * @param operateInfo[type:HwmOperateExternalInviteeInfo*]
        * [en] external invitee notifys
        * [cn] 操作外部与会者通知
        *
        * @mac:disable
        * @js:disable
        **/
        virtual void OnOperateExternalAttendeeNotify(const HwmOperateExternalInviteeInfo* operateInfo) {};

        /**
        * @brief[en] Notify of complain
        *       [cn] 举报通知
        *
        * @param complainInfo [type:HwmComplainInfo*]
        * [en] Complain Info
        * [cn] 举报信息
        *
        * @mac:disable
        * @js:disable
        */
        virtual void OnComplainNotify(const HwmComplainInfo* complainInfo) {};

        /**
        * @brief [en] Notify external invitee of invite all not in conf
        *        [cn] 外部与会者的批量邀请操作的通知
        *
        * @param operateInfo[type:HwmCallAllExternalAttendeesInfo*]
        * [en] external invitees notify
        * [cn] 操作外部与会者通知
        *
        * @mac:disable
        * @js:disable
        **/
        virtual void OnCallAllExternalAttendeesNotify(const HwmCallAllExternalAttendeesInfo* operateInfo) {};

        /**
        * @brief
        * [en] Notify of multi-share type change
        * [cn] 会议是否支持多人共享通知
        *
        * @detail
        * [en] (only for windows)
        * [cn] 收到该通知时，表示会议是否支持多人共享通知(仅对windows平台生效)。
        *
        * @param multiShareType [type:HwmAllowMultiShareType]
        * [en]multi-share type
        * [cn]多人共享类型
        *
        * @mac:disable
        */
        virtual void OnMultiShareTypeChanged(HwmAllowMultiShareType multiShareType) {};

        /**
        * @brief
        * [en] Notify of share audio state change
        * [cn] 共享音频状态变化通知
        *
        * @param shareAudioStateInfo [type:HwmShareAudioStateInfo*]
        * [en] Share audio state info
        * [cn] 共享音频状态信息
        *
        * @mac:disable
        */
        virtual void OnShareAudioStateChanged(const HwmShareAudioStateInfo* shareAudioStateInfo) {};

/* auto generate code insert, forbit delete */
    };
}

#endif /* _HWM_AGENT_NOTIFY_RESERVED_H_ */