﻿#pragma once
#include <vector>
#include "HwmSdkAgent.h"

// 添加与会者逻辑部分
template<typename _Tv, typename _dlg>
class AddAttendeeLogic
{
public:
    // 添加与会者
    bool AddAttendee();
    // 删除与会者
    bool DeleteAttendee(const CString input);
    // 获取与会者列表展示的字符串
    std::string GetAttendeeStr();
    // 获取与会者列表
    std::vector< _Tv>& GetAttendeeList();

private:
    std::vector< _Tv> m_attendeeList;  // 与会者列表
};

template<typename _Tv, typename _dlg>
inline bool AddAttendeeLogic<_Tv, _dlg>::AddAttendee()
{
    _dlg dlg;
    const auto ret = dlg.DoModal();
    if (ret == IDOK)
    {
        auto attendeeInfo = dlg.GetAttendeeInfo();
        for (const auto &element : m_attendeeList)
        {
            if (attendeeInfo.number[0] != 0) // 如果number不为空，number需要唯一
            {
                if (strcmp(attendeeInfo.number, element.number) == 0)
                {
                    AfxMessageBox(_T("attendee with the same number has already been added"));
                    return false;
                }
            }
            else // 否则，userId需要唯一
            {
                if (strcmp(attendeeInfo.thirdUserId, element.thirdUserId) == 0)
                {
                    AfxMessageBox(_T("attendee with the same userId has already been added"));
                    return false;
                }
            }
        }
        m_attendeeList.push_back(attendeeInfo);
    }
    return true;
}

template<typename _Tv, typename _dlg>
inline bool AddAttendeeLogic<_Tv, _dlg>::DeleteAttendee(const CString input)
{
    if (input.IsEmpty())
    {
        AfxMessageBox(_T("please input the number of the attendee to delete"));
        return false;
    }

    const auto number = CTools::UNICODE2UTF(input.GetString());
    for (auto it = m_attendeeList.begin(); it != m_attendeeList.end(); it++)
    {
        if (number == it->number || number == it->thirdUserId)
        {
            m_attendeeList.erase(it);
            return true;
        }
    }
    AfxMessageBox(_T("cannot find the attendee!"));
    return false;
}

template<typename _Tv, typename _dlg>
inline std::string AddAttendeeLogic<_Tv, _dlg>::GetAttendeeStr()
{
    std::string attendeeStr;
    for (const auto &item : m_attendeeList)
    {
        std::string numberId = item.number;
        if (numberId.empty())
        {
            numberId = item.thirdUserId;
        }
        attendeeStr.append(std::string(item.name) + '-' + numberId + ';');
    }

    return attendeeStr;
}

template<typename _Tv, typename _dlg>
inline std::vector< _Tv>& AddAttendeeLogic< _Tv, _dlg>::GetAttendeeList()
{
    return m_attendeeList;
}