// demoConfigDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demoConfigDlg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include <string>
#include "demoTools.h"

// demoConfigDlg Ի
using namespace std;

IMPLEMENT_DYNAMIC(demoConfigDlg, CDialogEx)

demoConfigDlg::demoConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(demoConfigDlg::IDD, pParent)
    , m_hIcon(0)
{

}

demoConfigDlg::~demoConfigDlg()
{
}

void demoConfigDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_CONFIG, m_configEdit);
}


BOOL demoConfigDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    // ...˵ӵϵͳ˵С

    // IDM_ABOUTBOX ϵͳΧڡ
    ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
    ASSERT(IDM_ABOUTBOX < 0xF000);

    CMenu* pSysMenu = GetSystemMenu(FALSE);
    if (pSysMenu != NULL)
    {
        BOOL bNameValid;
        CString strAboutMenu;
        bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
        ASSERT(bNameValid);
        if (!strAboutMenu.IsEmpty())
        {
            pSysMenu->AppendMenu(MF_SEPARATOR);
            pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
        }
    }

    // ô˶Իͼꡣ  ӦóڲǶԻʱܽԶ
    //  ִд˲
    SetIcon(m_hIcon, TRUE);     // ôͼ
    SetIcon(m_hIcon, FALSE);    // Сͼ

    wchar_t path[MAX_PATH] = { 0 };
    GetModuleFileNameW(nullptr, path, MAX_PATH - 1);
    std::wstring exePath(path);
    size_t pos = exePath.rfind('\\');
    if (pos != std::string::npos)
    {
        exePath = exePath.substr(0, pos);
    }
    std::wstring pathTmp = exePath + L"\\demoResource\\icon-whiteboard.svg";
    CString imagePath = pathTmp.c_str();
    imagePath.Replace(L"\\", L"/");

    CString config = LR"json({
  "frame": {
    "name": "demo",
    "primaryRect": {
      "left": 0,
      "top": 0,
      "width": 1600,
      "height": 900
    },
    "secondaryRect": {
      "left": 1920,
      "top": 0,
      "width": 1600,
      "height": 900
    },
    "border": false,
    "isUseExternalAddressBook": false,
    "isUseExternalConfInfoWnd": false,
    "isCloseSideWindow": true,
    "isUploadKeyLog":true,
    "isHideCallIncomingWindow": false,
    "isHideConfIncomingWindow": false,
    "isHideTransferHostBeforeLeave": false,
    "defaultViewMode": 1,
    "defaultWindowMode": 2,
    "defaultWindowMonitor": 0,
    "linkPrefix": "https://www.demo.com/",
    "confMenu": {
      "hoverBar": {
        "button": [
          {
            "id": "full_screen",
            "showAsAction": "never"
          },
          {
            "id": "view_mode",
            "showAsAction": "never"
          }
        ]
      },
      "titleBar": {
        "showAsAction": "ifRoom",
        "confDetail": {
          "showAsAction": "ifRoom",
          "button": [
            {
              "id": "copy_conf_info",
              "isCustomizedClick": false
            },
            {
              "id": "copy_audience_conf_info",
              "isCustomizedClick": false
            }
          ]
        }
      },
      "statusBar": {
         "button": [
          {
            "id": "record",
            "showAsAction": "never"
          },
        ]
      },
      "toolBar": {
        "dataToolHideMode": 1,
        "customButton": [
          {
            "id": "customMenu",
            "title": "Զ尴ť",
            "buttonPos": 1,
            "buttonImg": "imagePath",
            "subMenu":[
             {
                "id": "customSecondMenu",
                "title": "˵",
                "buttonImg": "imagePath"
             }
            ]
          },
          {
            "id": "customMore",
            "title": "Զ",
            "buttonPos": 0,
            "buttonImg": "imagePath"
          },
          {
            "id": "customShare",
            "title": "Զ干",
            "buttonPos": 2,
            "buttonImg": "imagePath"
          }
        ],
        "button": [
          {
            "id": "microphone",
            "showAsAction": "never"
          },
          {
            "id": "speaker",
            "showAsAction": "never"
          },
          {
            "id": "camera",
            "showAsAction": "never"
          },
          {
            "id": "invite",
            "showAsAction": "never",
            "isCustomizedClick": true
          },
          {
            "id": "meeting_assistant",
            "showAsAction": "ifRoom",
          },
          {
            "id": "guest_invite",
            "showAsAction": "never",
            "isCustomizedClick": false
          },
          {
            "id": "leave",
            "showAsAction": "never",
            "isCustomizedClick": true
          },
          {
            "id": "call_other_number",
            "showAsAction": "never",
            "isCustomizedClick": true
          },
          {
            "id": "attendee",
            "showAsAction": "never",
            "isCustomizedClick": true,
            "dialogPos": "center"
          },
          {
            "id": "share",
            "showAsAction": "never",
            "isCustomizedClick": true
          },
          {
            "id": "chat",
            "showAsAction": "never",
            "isCustomizedClick": true,
            "dialogPos": "center"
          },
          {
            "id": "annotation",
            "showAsAction": "never"
          },
          {
            "id": "stop_share",
            "showAsAction": "never"
          },
          {
            "id": "feedback",
            "showAsAction": "ifRoom",
            "isCustomizedClick": true
          },
          {
            "id": "dual_screen",
            "showAsAction": "never"
          },
          {
            "id": "remote_control",
            "showAsAction": "never"
          },
          {
            "id": "hands_up",
            "showAsAction": "never"
          },
          {
            "id": "change_chairman_auth",
            "showAsAction": "never"
          },
          {
            "id": "rename",
            "showAsAction": "never"
          },
          {
            "id": "lock_conf",
            "showAsAction": "never"
          },
          {
            "id": "export_participants",
            "showAsAction": "never"
          },
          {
            "id": "record",
            "showAsAction": "never"
          },
          {
            "id": "attendee_access_control",
            "showAsAction": "never"
          },
          {
            "id": "lock_Share",
            "showAsAction": "never"
          },
          {
            "id": "subtitle",
            "showAsAction": "never"
          },
          {
            "id": "security",
            "showAsAction": "never"
          },
          {
            "id": "invite_or_cancel_share",
            "showAsAction": "never"
          },
          {
            "id": "hide_no_video_view",
            "showAsAction": "never"
          },
          {
            "id": "video_smart_sorting",
            "showAsAction": "never"
          },
          {
            "id": "network_detection",
            "showAsAction": "never"
          },
          {
            "id": "mute_all",
            "showAsAction": "never"
          },
          {
            "id": "allow_unmute",
            "showAsAction": "never"
          },
          {
            "id": "vote",
            "showAsAction": "never"
          },
          {
            "id": "share_strategy",
            "showAsAction": "never"
          },
          {
            "id": "share_hide_video",
            "showAsAction": "never"
          },
          {
            "id": "share_audio",
            "showAsAction": "never"
          },
          {
            "id": "annotation",
            "showAsAction": "never"
          },
          {
            "id": "virtual_background",
            "showAsAction": "never"
          },
          {
            "id": "moveall_to_waitingroom",
            "showAsAction": "never"
          },
          {
            "id": "participant_detail",
            "isCustomizedClick": true
          },
          {
            "id": "call_all",
            "showAsAction": "never",
            "isCustomizedClick": true
          },
          {
            "id": "recall",
            "isCustomizedClick": true
          }
        ]
      }
    }
  }
}
)json";

    config.Replace(L"imagePath", imagePath);
    config.Replace(L"\n", L"\r\n");
    //ûĬ϶Ʋ˵
    m_configEdit.SetWindowText(config);

    return TRUE;  // ǽõؼ򷵻 TRUE
}

BEGIN_MESSAGE_MAP(demoConfigDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_CONFIG, &demoConfigDlg::OnBnClickedButtonConfig)
    ON_BN_CLICKED(IDC_BUTTON_CLEAN_CONFIG, &demoConfigDlg::OnBnClickedButtonCleanConfig)
END_MESSAGE_MAP()


// demoConfigDlg Ϣ


void demoConfigDlg::OnBnClickedButtonConfig()
{
    //ȡ
    CString cMenu;
    m_configEdit.GetWindowText(cMenu);
    string menu = CTools::UNICODE2UTF(cMenu.GetString());

    int ret = hwmsdkagent::Config((char*)menu.c_str());
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Config error");
    }
}


void demoConfigDlg::OnBnClickedButtonCleanConfig()
{
    string menu("");
    int ret = hwmsdkagent::CleanConfig();
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Clean Config error");
    }
}
