﻿// demoCustomSceneContentDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "resource.h"
#include "demoTools.h"
#include "demoCustomSceneContentDlg.h"
#include "afxdialogex.h"

// demoCustomSceneContentDlg 对话框

IMPLEMENT_DYNAMIC(demoCustomSceneContentDlg, CDialogEx)

demoCustomSceneContentDlg::demoCustomSceneContentDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_CUSTOM_SCENE_CONTENT, pParent)
{

}

demoCustomSceneContentDlg::~demoCustomSceneContentDlg()
{
}

void demoCustomSceneContentDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    // 获取空间
    DDX_Control(pDX, IDC_EDIT_CUSTOM_SCENE_CONTENT_CN, m_editCN);
    DDX_Control(pDX, IDC_EDIT_CUSTOM_SCENE_CONTENT_EN, m_editEN);
    DDX_Control(pDX, IDC_EDIT_CUSTOM_SCENE_CONTENT_CU, m_editCU);
    DDX_Control(pDX, IDC_EDIT_CUSTOM_SCENE_CONTENT_CU_CODE, m_editCUCode);
    DDX_Control(pDX, IDC_CHECK_CUSTOM_SCENE_CONTENT_CN, m_checkCN);
    DDX_Control(pDX, IDC_CHECK_CUSTOM_SCENE_CONTENT_EN, m_checkEN);
    DDX_Control(pDX, IDC_CHECK_CUSTOM_SCENE_CONTENT_CU, m_checkCU);
    DDX_Control(pDX, IDC_COMBO_SCENE, m_ccomboBoxScene);
}

BOOL demoCustomSceneContentDlg::OnInitDialog()
{
    CDialog::OnInitDialog();
    // 插入顺序与场景枚举顺序一致
    m_ccomboBoxScene.InsertString(0, _T("云录制结束提示"));
    m_ccomboBoxScene.InsertString(1, _T("会中云录制结束弹窗内容修改(win无效)"));
    m_ccomboBoxScene.InsertString(2, _T("录制弹框菜单中的云录制标题"));
    m_ccomboBoxScene.InsertString(3, _T("录制弹框菜单中的云录制描述"));
    m_ccomboBoxScene.InsertString(4, _T("主窗口中的云录制描述"));
    m_ccomboBoxScene.SetCurSel(0);

    return TRUE;
}


BEGIN_MESSAGE_MAP(demoCustomSceneContentDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_CUSTOM_SCENE_CONTENT_STORE, &demoCustomSceneContentDlg::OnBnClickedButtonCustomSceneContentStore)
    ON_BN_CLICKED(IDOK, &demoCustomSceneContentDlg::OnBnClickedOk)
END_MESSAGE_MAP()

// demoCustomSceneContentDlg 消息处理程序
void demoCustomSceneContentDlg::AssembleCustomSceneTextInfo(hwmsdkagent::HwmCustomSceneTextInfo& data)
{
    // 文案信息
    std::vector<hwmsdkagent::HwmUICustomTextInfo> customTextInfo;
    GetAllCustomText(customTextInfo);
    // 无任何文案
    if (customTextInfo.size() == 0)
    {
        data.sceneTextListSize = 0;
        data.sceneTextList = nullptr;
        return;
    }
    else
    {
        data.sceneTextListSize = customTextInfo.size();
        data.sceneTextList = new hwmsdkagent::HwmUICustomTextInfo[data.sceneTextListSize];
        if (data.sceneTextList != nullptr)
        {
            for (int i = 0; i < data.sceneTextListSize; i++)
            {
                data.sceneTextList[i].languageType = customTextInfo[i].languageType;
                errno_t ret = strcpy_s(data.sceneTextList[i].customText, sizeof(data.sceneTextList[i].customText), customTextInfo[i].customText);
                ret += strcpy_s(data.sceneTextList[i].languageCode, sizeof(data.sceneTextList[i].languageCode), customTextInfo[i].languageCode);
                if (ret != 0)
                {
                    AfxMessageBox(_T("text copy error"));
                    return;
                }
            }
            int ccomboxIndex = m_ccomboBoxScene.GetCurSel();
            data.scene = static_cast<hwmsdkagent::HwmUICustomTextScene>(ccomboxIndex);
        }
    }
}

void demoCustomSceneContentDlg::OnBnClickedButtonCustomSceneContentStore()
{
    // 获取场景文案信息
    hwmsdkagent::HwmCustomSceneTextInfo textInfo;
    AssembleCustomSceneTextInfo(textInfo);

    hwmsdkagent::HwmCustomSceneTextInfoList data{};
    if (textInfo.sceneTextListSize == 0)
    {
        data.customSceneTextInfoListSize = 0;
        data.customSceneTextInfoList = nullptr;
    }
    else
    {
        data.customSceneTextInfoListSize = 1;
        // 申请结构体内存
        data.customSceneTextInfoList = new (std::nothrow)hwmsdkagent::HwmCustomSceneTextInfo[data.customSceneTextInfoListSize];
        if (data.customSceneTextInfoList == nullptr)
        {
            return;
        }
        data.customSceneTextInfoList[0] = std::move(textInfo);
    }

    hwmsdk::HwmErrCode ret = hwmsdkagent::SetCustomUIText(&data);
    if (ret != hwmsdk::HWM_COMMON_SUCCESS)
    {
        CTools::OutputRetStr("Custom scene content error");
    }
    // 释放结构体内存
    for (int i = 0; i < data.customSceneTextInfoListSize; i++)
    {
        if (data.customSceneTextInfoList[i].sceneTextList != nullptr)
        {
            delete data.customSceneTextInfoList[i].sceneTextList;
            data.customSceneTextInfoList[i].sceneTextList = nullptr;
        }
    }

    if (data.customSceneTextInfoList != nullptr)
    {
        delete data.customSceneTextInfoList;
        data.customSceneTextInfoList = nullptr;
    }
}

void demoCustomSceneContentDlg::GetCustomTextByLanguage(hwmsdkagent::HwmLanguage languageType, hwmsdkagent::HwmUICustomTextInfo & info)
{
    CString text{""};
    CString code{""};
    std::string type{""};
    if (languageType == hwmsdkagent::HwmLanguage::HWM_LANGUAGE_ZH_CN)
    {
        m_editCN.GetWindowTextW(text);
        type = "ZN";
    }
    else if (languageType == hwmsdkagent::HwmLanguage::HWM_LANGUAGE_EN_GB)
    {
        m_editEN.GetWindowTextW(text);
        type = "EN";
    }
    else if(languageType == hwmsdkagent::HwmLanguage::HWM_LANGUAGE_CUSTOMIZED)
    {
        m_editCU.GetWindowTextW(text);
        m_editCUCode.GetWindowTextW(code);
        type = "CU";
    }
    std::string textStr = CTools::UNICODE2UTF(text.GetString());
    std::string codeStr = CTools::UNICODE2UTF(code.GetString());
    CTools::OutputRetStr("Custom content info(" + type + "): " + textStr + ", code: " + codeStr);
    info.languageType = languageType;
    errno_t res = strcpy_s(info.customText, sizeof(info.customText), textStr.c_str());
    res += strcpy_s(info.languageCode, sizeof(info.languageCode), codeStr.c_str());
    if (res != 0)
    {
        AfxMessageBox(_T("text copy error"));
    }
}

void demoCustomSceneContentDlg::GetAllCustomText(std::vector<hwmsdkagent::HwmUICustomTextInfo>& infos)
{
    // 中文文案
    if (m_checkCN.GetCheck())
    {
        hwmsdkagent::HwmUICustomTextInfo infoCN;
        GetCustomTextByLanguage(hwmsdkagent::HwmLanguage::HWM_LANGUAGE_ZH_CN, infoCN);
        infos.push_back(infoCN);
    }   
    // 英文文案
    if (m_checkEN.GetCheck())
    {
        hwmsdkagent::HwmUICustomTextInfo infoEN;
        GetCustomTextByLanguage(hwmsdkagent::HwmLanguage::HWM_LANGUAGE_EN_GB, infoEN);
        infos.push_back(infoEN);
    }
    // 自定义文案
    if (m_checkCU.GetCheck())
    {
        hwmsdkagent::HwmUICustomTextInfo infoCU;
        GetCustomTextByLanguage(hwmsdkagent::HwmLanguage::HWM_LANGUAGE_CUSTOMIZED, infoCU);
        infos.push_back(infoCU);
    }
}

void demoCustomSceneContentDlg::OnBnClickedOk()
{
    CDialogEx::OnOK();
}
