﻿/**
 * @file HwmAgentNotifyDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 通知结构体、枚举定义文件
 */

#ifndef _HWM_AGENT_NOTIFY_DEF_H_
#define _HWM_AGENT_NOTIFY_DEF_H_

#include "HwmBaseMacroDef.h"
#include "HwmErrorCodeDef.h"

namespace hwmsdkagent
{

/********************************************以下是枚举定义*****************************************************************/

    /** 
     * [en]This enumeration is used to describe the notify id.
     * [cn]通知Id
     */
    typedef enum tagHwmNotifyId
    {
        HWM_NOTIFY_ID_START,                                              /**< [en]The start of notify id
                                                                               [cn]通知Id最小边界值 */

        HWM_NOTIFY_ID_KICKED_OUT,                                         /**< [en]The sdk was kicked out
                                                                               [cn]sdk 登录账号被踢 */
        HWM_NOTIFY_ID_SHARE_STATE,                                        /**< [en]The share state is changed
                                                                               [cn]共享状态变更 */
        HWM_NOTIFY_ID_RECV_SHARE_STATE,                                   /**< [en]The receive share state is changed
                                                                               [cn]接收共享状态变更 */
        HWM_NOTIFY_ID_CONF_INFO,                                          /**< [en]The conf info is changed
                                                                               [cn]会议信息更新 */
        HWM_NOTIFY_ID_CONF_STATE,                                         /**< [en]The conf state is changed
                                                                               [cn]会议状态变更 */
        HWM_NOTIFY_ID_REMOTE_CONTROL_STATE,                               /**< [en]Remote control state
                                                                               [cn]获取远程控制状态变更 */
        HWM_NOTIFY_ID_BE_REMOTE_CONTROLED_STATE,                          /**< [en]Controlled remotely state
                                                                               [cn]授予他人远程控制状态变更 */
        HWM_NOTIFY_ID_CLICK_INJECT_BTN,                                   /**< [en]Click Inject button
                                                                               [cn]点击注入按钮 */
        HWM_NOTIFY_ID_REFRESH_PAIR_CODE,                                  /**< [en]The pair code is changed
                                                                               [cn]配对码刷新 */
        HWM_NOTIFY_ID_CORPORATION_CONFIG,                                 /**< [en]The corporation config is changed
                                                                               [cn]企业配置刷新 */
        HWM_NOTIFY_ID_SDK_DISCONNECTED,                                   /**< [en]The sdk is disconnected
                                                                               [cn]sdk连接断开 */
        HWM_NOTIFY_ID_CONF_INCOMING,                                      /**< [en]The conf is coming
                                                                               [cn]会议来电 */
        HWM_NOTIFY_ID_CONF_LIST,                                          /**< [en]The conf list
                                                                               [cn]会议列表 */
        HWM_NOTIFY_ID_CALL_STATE,                                         /**< [en]The call state is changed
                                                                               [cn]通话状态变更 */
        HWM_NOTIFY_ID_CALL_INFO,                                          /**< [en]The call info is changed
                                                                               [cn]通话信息更新 */
        HWM_NOTIFY_ID_QUERY_OTHER_NUMBER,                                 /**< [en]Query other number Notify
                                                                               [cn]查询其他号码 */
        HWM_NOTIFY_ID_QUERY_AVATAR,                                       /**< [en]Query avatar Notify
                                                                               [cn]查询头像 */
        HWM_NOTIFY_ID_QUERY_DEPARTMENT_INFO,                              /**< [en]Query department info Notify
                                                                               [cn]查询部门信息 */
        HWM_NOTIFY_ID_MEETING_CONFIGURATION,                              /**< [en]Meeting configuration
                                                                               [cn]会议配置项上报 */
        HWM_NOTIFY_ID_CONF_LIST_FOR_WELINK,                               /**< [en]The conf list
                                                                               [cn]会议列表(新加三个url) */
        HWM_NOTIFY_ID_CALL_INCOMING,                                      /**< [en]On Call Incoming
                                                                               [cn]来电通知 */
        HWM_NOTIFY_ID_CALL_RECORDINFO,                                    /**< [en]On Call record info
                                                                               [cn]通话记录 */
        HWM_NOTIFY_ID_LOGIN_RESULT_CHANGE,                                /**< [en]Login result change
                                                                               [cn]登陆结果变化 */
        HWM_NOTIFY_ID_SHOW_EXTERNAL_CONF_INFO_WND,                        /**< [en]Show external conf info wnd
                                                                               [cn]显示外部会议信息框 */
        HWM_NOTIFY_ID_DESTROY_EXTERNAL_CONF_INFO_WND,                     /**< [en]Destroy external conf info wnd
                                                                               [cn]销毁外部会议信息框 */
        HWM_NOTIFY_ID_QUERY_CONTACT_AVATAR,                               /**< [en]Query contact avatar Notify
                                                                               [cn]查询联系人头像 */
        HWM_NOTIFY_ID_ON_LOGIN_AUTH_EXPIRED,                              /**< [en]Authenticate expired
                                                                               [cn]登录凭证失效通知 */
        HWM_NOTIFY_ID_ON_ANNOTION_STATE_UPDATA,                           /**< [en]Annotation State Updata
                                                                               [cn]标注状态变更通知 */
        HWM_NOTIFY_ID_MIC_INPUT_LEVEL_CHANGE,                             /**< [en]Mic input level change
                                                                               [cn]麦克风输入等级变化 */
        HWM_NOTIFY_ID_SPEAKER_OUTPUT_LEVEL_CHANGE,                        /**< [en]Speaker output level change
                                                                               [cn]扬声器输出等级变化 */
        HWM_NOTIFY_ID_AVDEVICE_CTRL_STATE_CHANGE,                         /**< [en]AVDevice control state change
                                                                               [cn]音视频设备状态变化 */
        HWM_NOTIFY_ID_MIC_LEVEL_CHANGE,                                   /**< [en]Mic level change
                                                                               [cn]麦克风音柱变化 */
        HWM_NOTIFY_ID_ATTENDEE_COUNT_CHANGE,                              /**< [en]Attendee count change
                                                                               [cn]与会者人数变化通知 */
        HWM_NOTIFY_ID_RENDER_WINDOW_INFO_LIST,                            /**< [en]Render window handle change
                                                                               [cn]窗口句柄变化通知 */
        HWM_NOTIFY_ID_AUDIO_RAW_DATA_FRAME,                               /**< [en]Audio raw data frame 
                                                                               [cn]音频裸码流 */
        HWM_NOTIFY_ID_JOIN_VMRCONF_CONFLICT_INFO,                         /**< [en]Join vmrconf conflict info
                                                                               [cn]加入VMR会议冲突详情 */
        HWM_NOTIFY_ID_RESERVED_CLICK_INJECT_BTN,                          /**< [en]Reserved Click Inject button
                                                                               [cn]保留的点击注入按钮 */
        HWM_NOTIFY_ID_EXTEND_CONF_DURATION,                               /**< [en]Extend conf duration
                                                                               [cn]会议即将结束，需要延长会议时间的通知 */
        HWM_NOTIFY_ID_USER_CORP_INFO,                                     /**< [en]User corp info change
                                                                               [cn]用户企业信息变化通知 */
        HWM_NOTIFY_ID_APPLICATION_INFO,                                   /**< [en]Application info
                                                                               [cn]收到会议应用通知消息，json字符串 */
        HWM_NOTIFY_ID_QUERY_CORP_DEPARTMENT_INFO,                         /**< [en]Query Corp department info
                                                                               [cn]批量获取企业信息，json字符串 */
        HWM_NOTIFY_ID_ONCONTACTAVATARCHANGED,                             /**< [en] Notify of contact avatar changed
                                                                               [cn] 联系人头像变更通知 */
        HWM_NOTIFY_ID_CONF_IS_SHARE_LOCKED_CHANGED,                       /**< [en] Notify of conf share locked state changed
                                                                               [cn] 会议是否共享锁定状态变化通知 */
        HWM_NOTIFY_ID_SERVER_DOMAIN_STRATEGY,                             /**< [en]Server domain strategy
                                                                               [cn]域名策略变化通知 */
        HWM_NOTIFY_ID_ONAUDIOQUALITYNOTIFY,                                   /**< [en]This class is about audio quality notify.
                                                                               [cn]音频质量通知 */
        HWM_NOTIFY_ID_ONPROXYACCOUNTINFOCHANGED,                          /**< [en] Notify of proxy account info changed
                                                                               [cn] 代理账号信息变更通知 */
        HWM_NOTIFY_ID_ONCONFENDEDNOTIFY,                                   /**< [en] This class is about the notification of an ended conference.
                                                                               [cn] 会议结束通知 */
        HWM_NOTIFY_ID_ONSHOWVOICEPRINTSTATEMENT,                          /**< [en] Notify of show voiceprint statement
                                                                               [cn] 功能声明显示通知 */
        HWM_NOTIFY_ID_ONPOORNETWORKQUALITYINFONOTIFY,                                   /**< [en] This class is about the notification of low quality network.
                                                                               [cn] 弱网提示通知 */
        HWM_NOTIFY_ID_ONCONFEVENTINFONOTIFY,                                   /**< [en]Notify of conf event info
                                                                               [cn]会中事件信息上报通知 */
        HWM_NOTIFY_ID_ONSCANINFOFORJOINCONFNOTIFY,                             /**< [en] Notify of scan join conf result
                                                                               [cn] 扫码入会通知 */
        HWM_NOTIFY_ID_ONAPPCFGCHANGED,                                   /**< [en] meeting config notify
                                                                               [cn] 跟随高级参数返回的会议配置项 */
        HWM_NOTIFY_ID_ONSPEAKERLISTCHANGED,                                   /**< [en]Notify of speakerlist
                                                                               [cn]发言人变更的通知 */
        HWM_NOTIFY_ID_ONVIDEOSTREAMTYPECHANGED,                                   /**< [en]Notify of video stream type info
                                                                               [cn]视频流类型的变化通知 */
        HWM_NOTIFY_ID_ONPAIRVERIFYCODENOTIFY,                                   /**< [en] Notify of pair verify code.
                                                                               [cn] 配对验证码通知 */
        HWM_NOTIFY_ID_ONPAIRLINKLISTNOTIFY,                                   /**< [en] Notify of pair link list.
                                                                               [cn] 配对链路列表通知 */
        HWM_NOTIFY_ID_ONRECVMSGFROMPAIRLINKNOTIFY,                                   /**< [en] Notify of msg from pair link.
                                                                               [cn] 配对链路中消息上报 */
        HWM_NOTIFY_ID_ONVIDEOATTENDEELISTCHANGED,                                   /**< [en]Notify of video attendee list change
                                                                               [cn]视频与会者列表变更的通知 */
        HWM_NOTIFY_ID_ONANNOTATIONSTATECHANGED,                                   /**< [en]Notify of annotation state change
                                                                               [cn]标注状态变化通知 */
        HWM_NOTIFY_ID_ONPAIRLINKSUCCESSNOTIFY,                                   /**< [en] Notify of pair link suceess.
                                                                               [cn] 配对链路成功通知 */
        HWM_NOTIFY_ID_P2P_CONF_RECORD,                                      /**< [en] Notify of p2p conf record.
                                                                               [cn] 会议记录通知 */
        HWM_NOTIFY_ID_ONSHAREVMRINFONOTIFY,                                   /**< [en]This is about share vmr info notify.
                                                                               [cn]共享vmr信息通知 */
        HWM_NOTIFY_ID_ONERRORMSGLISTCHANGE,                                   /**< [en Notify of error msg list.
                                                                               [cn] 错误码提示列表上报 */
        HWM_NOTIFY_ID_ONREQUESTMEDIASEPARATELOGNOTIFY,                         /**< [en] Notify of request media separate log
                                                                               [cn] 请求媒体分离日志，拷贝日志操作的通知 */
        HWM_NOTIFY_ID_ONPROXYINFOCHANGE,                                   /**< [en] Notify of proxy info change
                                                                               [cn] 代理信息变化通知 */
        HWM_NOTIFY_ID_ON_ABNORMAL_LEAVE_MEETING_NOTIFY,                    /**< [en] Notice of abnormal leave meeting
                                                                               [cn] 异常断开的会议通知 */
        HWM_NOTIFY_ID_ONOPERATEEXTERNALATTENDEENOTIFY,                                   /**< [en] Notify of invite or hang up invitee
                                                                               [cn] 通知邀请或挂断外部邀请者 */
        HWM_NOTIFY_ID_ONCOMPLAINNOTIFY,                                   /**< [en] Notify of complain
                                                                               [cn] 举报通知 */
        HWM_NOTIFY_ID_ONMEETINGINFOCHANGED,                               /**< [en]Notify of conf info
                                                                               [cn]会中信息更新通知 */
        HWM_NOTIFY_ID_ONWAITINGLISTCHANGED,                               /**< [en] Notify of the waiting list
                                                                               [cn] 等候室成员列表变更的通知 */
        HWM_NOTIFY_ID_ONUSERSAVEPATHCHANGED,                              /**< [en] User data path change notification
                                                                               [cn] 用户数据路径变化通知 */
        HWM_NOTIFY_ID_ONEXTERNALCALLALLNOTIFY,                                   /**< [en] Notify external invitee of invite all not in conf
                                                                               [cn] 外部与会者的批量邀请操作的通知 */
        HWM_NOTIFY_ID_ONADDATTENDEENOTIFY,                                   /**< [en] Notify of the add attendee
                                                                               [cn] 添加与会者结果通知 */
        HWM_NOTIFY_ID_ONSELFLOCALRECORDSTATENOTIFY,                       /**< [en] Notify of local record state
                                                                               [cn] 本地录制状态通知 */
        HWM_NOTIFY_ID_ONMULTISHARETYPECHANGED,                            /**< [en] Notify of multi-share type change
                                                                               [cn] 会议是否支持多人共享通知 */
        HWM_NOTIFY_ID_ONDOUBLECLICKPARTICIPANTLISTITEMNOTIFY,             /**< [en] Notify of double click participant list item
                                                                               [cn] 双击与会者项通知 */
        HWM_NOTIFY_ID_ONATTENDEELISTCHANGED,                                   /**< [en] Notify of the attendee list
                                                                               [cn] 与会者列表变更的通知 */
        HWM_NOTIFY_ID_ONSHAREAUDIOSTATECHANGED,                                   /**< [en] Notify of share audio state change
                                                                               [cn] 共享音频状态变化通知 */
        HWM_NOTIFY_ID_ONREALTIMESUBTITLEINFONOTIFY,                                   /**< [en] Notify of the real time subtitle info
                                                                               [cn] 实时字幕信息的通知 */
        HWM_NOTIFY_ID_ONSUBTITLERECORDNOTIFY,                                   /**< [en] Notify of the subtitle record info
                                                                               [cn] 字幕记录消息的通知 */
        HWM_NOTIFY_ID_ONSUBTITLESTATECHANGED,                                   /**< [en] Notify of subtitle state change
                                                                               [cn] 字幕状态变更通知 */
        HWM_NOTIFY_ID_ONWAITINGROOMSTATECHANGED,                                   /**< [en] Notify of waiting room state change
                                                                               [cn] 等候室状态变更通知 */
        HWM_NOTIFY_ID_ONSTARTLOCALRECORDOPERATIONINTERRUPTNOTIFY,                                   /**< [en] Notify of local record operation interrupt notify
                                                                               [cn] 本地录制操作中断通知 */
        HWM_NOTIFY_ID_ONCREATECONFFINISHEDNOTIFY,                                   /**< [en] Create Conf Finished Notify. when create conf, will receive this notify
                                                                               [cn] 完成创建会议通知 */
        HWM_NOTIFY_ID_ONLOGINSTATECHANGENOTIFY,                                   /**< [en]This is about login state change notify.
                                                                               [cn]登录状态变化通知 */
/* auto generate code insert 2, forbit delete */
        HWM_NOTIFY_ID_END                                                 /**< [en]The end of notify id
                                                                               [cn]通知Id最大边界值 */
    } HwmNotifyId;

    /** 
     * [en]Conf media type.
     * [cn]会议类型
     */
    typedef enum tagHwmConfMediaType
    {
        HWM_AUDIO_AND_DATA,        /**< [en]Audio and data
                                        [cn]音频数据会议 */
        HWM_VIDEO_AND_DATA,        /**< [en]Video and data
                                        [cn]视频数据会议 */

        HWM_CONF_MEDIA_TYPE_BUTT
    } HwmConfMediaType;

    /** 
     * [en]Language type.
     * [cn]语言类型
     */
    typedef enum tagHwmLanguage
    {
        HWM_LANGUAGE_ZH_CN,             /**< [en]zh-CN
                                             [cn]中文 */
        HWM_LANGUAGE_EN_GB,             /**< [en]en-GB
                                             [cn]英文 */
        HWM_LANGUAGE_CUSTOMIZED,        /**< [en]Customized
                                             [cn]自定义语言 */

        HWM_LANGUAGE_BUTT

    } HwmLanguage;

    /** 
     * [en]Auth type.
     * [cn]鉴权类型
     */
    typedef enum tagHwmAuthType
    {
        HWM_AUTH_TYPE_ACCOUNT_AND_PASSWORD = 0,        /**< [en]Auth by account and password
                                                            [cn]账号密码鉴权 */
        HWM_AUTH_TYPE_APPID,                           /**< [en]Auth by appId
                                                            [cn]appId鉴权 */
        HWM_AUTH_TYPE_BUTT

    }HwmAuthType;

    /** 
     * [en]Share type.
     * [cn]共享类型
     */
    typedef enum tagHwmShareType
    {
        HWM_SHARE_TYPE_MONITOR,          /**< [en]Share monitor
                                              [cn]屏幕共享 */
        HWM_SHARE_TYPE_APP,              /**< [en]Share app
                                              [cn]程序共享 */
        HWM_SHARE_TYPE_WHITE_BOARD,      /**< [en]Share white board
                                              [cn]白板共享 */
        HWM_SHARE_TYPE_ALL,              /**< [en]All Share 
                                              [cn]全类型共享 */
        HWM_SHARE_TYPE_BUTT
    } HwmShareType;

    /** 
     * [en]Conf state.
     * [cn]状态类型
     */
    typedef enum tagHwmState
    {
        HWM_STATE_OFF,         /**< [en]Off state
                                    [cn]关闭状态 */
        HWM_STATE_ON,          /**< [en]On state
                                    [cn]开启状态 */

        HWM_STATE_BUTT
    } HwmState;



    /**
    * [en]Stop share reason.
    * [cn]停止共享原因
    */
    typedef enum tagHwmStopShareReason
    {
        HWM_STOP_SHARE_BY_NORMAL,           /**< [en]Stop sharing normally
                                                 [cn]正常停止共享 */
        HWM_STOP_SHARE_BY_REJOIN_CONF       /**< [en]MMR transfer
                                                 [cn]MMR迁移 */
    } HwmStopShareReason;

    /**
    * [en]Conf coming state.
    * [cn]来电状态类型
    */
    typedef enum tagHwmConfComingState
    {
        HWM_CONF_COMING_STATE_START = 1,   /**< [en]Init state
                                                [cn]初始状态 */
        HWM_CONF_COMING_STATE_ACCEPT,      /**< [en]Accept state
                                                [cn]接听状态 */
        HWM_CONF_COMING_STATE_REJECT,      /**< [en]Reject state
                                                [cn]拒绝状态 */
        HWM_CONF_COMING_STATE_TIMEOUT,     /**< [en]Timeout state
                                                [cn]未响应状态 */

        HWM_CONF_COMING_STATE_BUTT
    } HwmConfComingState;

    /** 
     * [en]Click inject button type.
     * [cn]点击注入按钮类型
     */
    typedef enum tagHwmClickInjectBtn
    {
        HWM_CLICK_INJECT_BTN_INVITE,                          /**< [en]Invite button
                                                                   [cn]邀请按钮 */
        HWM_CLICK_INJECT_BTN_CALL_OTHER_NUM,                  /**< [en]Call other number button
                                                                   [cn]呼叫其他号码按钮 */
        HWM_CLICK_INJECT_BTN_ATTENDEE,                        /**< [en]Show attendees button
                                                                   [cn]与会者按钮 */
        HWM_CLICK_INJECT_BTN_CHAT,                            /**< [en]Show chat button
                                                                   [cn]聊天按钮 */
        HWM_CLICK_INJECT_BTN_SHARE,                           /**< [en]Share button
                                                                   [cn]共享按钮 */
        HWM_CLICK_INJECT_BTN_LEAVE,                           /**< [en]Leave conf button
                                                                   [cn]离开会议按钮 */
        HWM_TOOLS_INJECT_BTN_CUSTOM,                          /**< [en]User Custome button
                                                                   [cn]用户自定义按钮 */
        HWM_CLICK_INJECT_BTN_GUEST_INVITE,                    /**< [en]Guest Invite button
                                                                   [cn]来宾邀请按钮 */
        HWM_CLICK_INJECT_BTN_FEEDBACK,                        /**< [en]Feedback button
                                                                   [cn]反馈按钮 */
        HWM_CLICK_INJECT_BTN_COPY_CONF_INFO,                  /**< [en]Copy conf info button
                                                                   [cn]复制会议信息按钮 */
        HWM_CLICK_INJECT_BTN_PARTICIPANT_DETAIL,              /**< [en]Participant detail  button
                                                                   [cn]与会者详情按钮 */
        HWM_CLICK_INJECT_BTN_COPY_AUDIENCE_CONF_INFO,         /**< [en]Copy audience conf info button
                                                                   [cn]复制观众会议信息按钮 */
        HWM_CLICK_INJECT_BTN_CALL_ALL,                        /**< [en]"Call All" Button at participant list
                                                                   [cn]与会者列表“全部呼叫”按钮 */
        HWM_CLICK_INJECT_BTN_RECALL,                          /**< [en]Recall button
                                                                   [cn]重新呼叫按钮 */
        HWM_CLICK_INJECT_BTN_BUTT
    } HwmClickInjectBtn;

    /** 
     * [en]Monitor.
     * [cn]屏幕枚举
     */
    typedef enum tagHwmMonitor
    {
        HWM_MONITOR_MAIN = 1,               /**< [en]Main monitor
                                                 [cn]主显示器 */
        HWM_MONITOR_SECONDARY,              /**< [en]Secondary monitor
                                                 [cn]副显示器 */

        HWM_MONITOR_BUTT
    } HwmMonitor;

    /**
     * [en]Monitor mode
     * [cn]屏幕模式
     */
    typedef enum tagHwmMonitorMode
    {
        HWM_MONITOR_MODE_PRIMARY_SECONDARY = 0,      /**< [en]Primary secondary mode
                                                          [cn]主副屏模式 */
        HWM_MONITOR_MODE_MULTI_MONITOR,              /**< [en]Multi monitor mode
                                                          [cn]多屏模式 */

        HWM_MONITOR_MODE_BUTT
    } HwmMonitorMode;

    /** 
     * [en]Monitor.
     * [cn]会议角色
     */
    typedef enum tagHwmConfRole
    {
        HWM_CONF_ROLE_ATTENDEE = 0,           /**< [en]Indicates attendee
                                               <br>[cn]普通与会者 */
        HWM_CONF_ROLE_CHAIRMAN,               /**< [en]Indicates chairman
                                               <br>[cn]主席 */
        HWM_CONF_ROLE_AUDIENCE,               /**< [en]Indicates audience
                                               <br>[cn]观众 */
        HWM_CONF_ROLE_COHOST,                 /**< [en]Indicates cohost
                                               <br>[cn]联席主持人 */
        HWM_CONF_ROLE_WAITING,                 /**< [en]Indicates waiting
                                               <br>[cn]等候室成员 */
        HWM__CONF_ROLE_BUTT
    } HwmConfRole;

    /** 
     * [en]Conf end reason.
     * [cn]会议结束原因
     */
    typedef enum tagHwmConfEndReason
    {
        HWM_CONF_END_REASON_LEAVE_CONF_HANGUP = 0,                         /**< [en]Leave conf
                                                                            <br>[cn]离开会议 */
        HWM_CONF_END_REASON_STOP_CONF_HANGUP,                              /**< [en]Conf is end
                                                                            <br>[cn]会议已结束*/
        HWM_CONF_END_REASON_CHAIR_HANGUP,                                  /**< [en]Hang up by chairman
                                                                            <br>[cn]被主持人移出会场 */
        HWM_CONF_END_REASON_SESSION_TIMER_TIMEOUT,                         /**< [en]Session timer timeout
                                                                            <br>[cn]网络中断 */
        HWM_CONF_END_REASON_NOSTREAM_HANGUP,                               /**< [en]No stream
                                                                            <br>[cn]网络异常 */
        HWM_CONF_END_REASON_CORP_CONFERENCE_RESOURCE_HAS_BEEN_RUN_OUT,     /**< [en]Conf resource has been run out
                                                                            <br>[cn]企业资源已达上限 */
        HWM_CONF_END_REASON_CONF_ONLY_SAME_ENTERPRISE,                     /**< [en]Only the same enterprise can join the conference.
                                                                            <br>[cn]只允许企业内用户加入会议 */
        HWM_CONF_END_REASON_CONF_ONLY_INVITED,                             /**< [en]Only invited participants can join the conference.
                                                                            <br>[cn]只允许被邀请者加入会议 */
        HWM_CONF_END_REASON_CONF_IS_LOCKED,                                /**< [en]Conference is locked.
                                                                            <br>[cn]会议被锁定 */
        HWM_CONF_END_ERR_VMR_NOT_BEEN_HOLD,                                /**< [en]vmr has not been hold.
                                                                            <br>[cn]VMR会议来宾不允许激活会议 */
        HWM_CONF_END_REASON_VMR_CONF_CONFLICT,                             /**< [en]Vmr conf conflict
                                                                            <br>[cn]VMR会议冲突 */
        HWM_CONF_END_REASON_SERVER_ERROR,                                  /**< [en]server error
                                                                            <br>[cn]服务器异常 */
        HWM_CONF_END_REASON_NUM_OF_PAR_EXCEEDS_UPPER_LIMIT,                /**< [en]num of par exceeds upper limit.
                                                                            <br>[cn]与会方超出专用VMR套餐的最大与会人数 */
        HWM_CONF_END_REASON_CONF_NUM_OVER_MAX_ALLOWED = 111071116,         /**< [en]conf number over max allowed.
                                                                            <br>[cn]超出最大在线会议数限制 */
        HWM_CONF_END_REASON_PARTICIPANT_REACH_MAX_NUM = 111072504,         /**< [en]Max participants in a single meeting reached.
                                                                            <br>[cn]达到系统单个会议人数上限 */
        HWM_CONF_END_REASON_PARTICIPANT_CONF_NOT_EXIST = 111081002,         /**< [en]Site meeting does not exist or is ended.
                                                                            <br>[cn]会场所在会议不存在或已结束 */
        HWM_CONF_END_REASON_CONF_CONFLICT = 111111008,                      /**< [en]hangup for joinconf conflict.
                                                                            <br>[cn]多端入会冲突，导致离开会议 */
        HWM_CONF_END_REASON_END_CONF_NET_BREAK = 411000100,                /**< [en]End the meeting with no stream due to disconnection of network.
                                                                                [cn]无码流结束会议网络断开 */
        HWM_CONF_END_REASON_END_EXPIRATION = 414100069,                     /**< [en]Invalid user, enterprise or SP.
                                                                            <br>[cn]用户，企业或SP失效 */
        HWM_CONF_END_REASON_SDK_CHAIR_END_CONF = 414100074,                 /**< [en]Chair end conf.
                                                                            <br>[cn]主持人结束会议 */
        HWM_CONF_END_REASON_SDK_TIMEOVER_END_CONF = 414100075,              /**< [en]Timeover end conf.
                                                                            <br>[cn]会议到时间结束会议 */
        HWM_CONF_END_REASON_CALLEE_REFUSED_END_CONF = 414100076,            /**< [en]callee refused.
                                                                             <br>[cn] 被叫拒接 */
        HWM_CONF_END_REASON_CALLEE_TIMEOUT_END_CONF = 414100077,            /**< [en]callee timeout.
                                                                             <br>[cn] 被叫超时 */
        HWM_CONF_END_FORCE_OPEN_CAMERA_HANGUP = 414100078,                  /**< [en]force open camera conf hangup.
                                                                             <br>[cn]强制视频会议挂断 */
        HWM_CONF_END_REASON_PROJECTION_FAILED = 414100080,                      /**< [en]conf end for projection failed.
                                                                                     [cn] 投屏失败导致会议结束 */
        HWM_CONF_END_REASON_PROJECTION_CANCEL = 414100082,                      /**< [en]conf end for cancel.
                                                                                     [cn] 投屏协商中大屏取消 */
        HWM_CONF_END_REASON_PROJECTION_BY_SENDER_WITH_TWO_MEMBERS = 414100083,  /**< [en]Indicates end projection by sender with two members.
                                                                                     [cn] 两方投屏端结束投屏 */
        HWM_CONF_END_REASON_PROJECTION_BY_RECEIVER = 414100084,                 /**< [en]Indicates end projection by receiver.
                                                                                     [cn] 大屏端结束投屏 */
        HWM_CONF_END_REASON_PROJECTION_BY_SENDER_WITH_MULTI_MEMBERS = 414100085,/**< [en]projection by sender with multi members.
                                                                                     [cn] 多方投屏会议投屏端结束投屏 */
        HWM_CONF_END_REASON_RTC_SDK_NETWORK_FAILED = 990000053,             /**< [en]network error.
                                                                            <br>[cn]网络问题 */
        HWM_CONF_END_REASON_OVER_MAX_PARTICIPANT_NUMBER = 111072101,        /**< [en]Max participant amount reached.
                                                                            <br>[cn]超过设置的会议方数 */
        HWM_CONF_END_MANAGER_SHARE_VMR_NOT_ENOUGH = 111071151,              /**< [en]Share VMR not enough.
                                                                            <br>[cn]无共享云会议室资源 */
        HWM_CONF_END_MANAGER_NO_UPSCALE_VMR = 112030001,                    /**< [en]No Upscale vmr.
                                                                            <br>[cn]无高档可用的VMR资源 */
        HWM_CONF_END_REASON_BUTT
    } HwmConfEndReason;

    /** 
     * [en]Media type.
     * [cn]媒体类型
     */
    typedef enum tagHwmMediaType
    {
        HWM_MEDIA_TYPE_AUDIO,        /**< [en]Audio
                                          [cn]音频 */
        HWM_MEDIA_TYPE_VIDEO,        /**< [en]Video
                                          [cn]视频 */

        HWM_MEDIA_TYPE_BUTT
    } HwmMediaType;

    /** 
     * [en]Enable type.
     * [cn]功能配置开关类型
     */
    typedef enum tagHwmEnableFeatureType
    {
        HWM_ENABLE_FEATURE_TYPE_MULTI_MONITOR,            /**< [en]Multi-monitor switch
                                                               [cn]多显示器模式开关 */
        HWM_ENABLE_FEATURE_TYPE_SHOW_HANGUP_ATTENDEE,     /**< [en]Show hangup attendee switch
                                                               [cn]显示离会与会者开关 */
        HWM_ENABLE_FEATURE_TYPE_HOWLING_DETECTION,        /**< [en]Howling detection switch
                                                               [cn]啸叫检测开关 */
        HWM_ENABLE_FEATURE_TYPE_HIGH_RESOLUTION,          /**< [en]High resolution switch
                                                               [cn]1080P开关 */
        HWM_ENABLE_FEATURE_TYPE_MIC_SWITCH,               /**< [en]Microphone change switch
                                                               [cn]麦克风开关 */
        HWM_ENABLE_FEATURE_TYPE_CAM_SWITCH,               /**< [en]Camera change switch
                                                               [cn]摄像头开关 */
        HWM_ENABLE_FEATURE_TYPE_HIDE_EXTERNAL_LABEL,      /**< [en]Hide external label
                                                               [cn]隐藏外部标签 */
        HWM_ENABLE_FEATURE_AUTO_MIC_VOLUME,               /**< [en]Automatic microphone volume adjustment switch
                                                               [cn]自动调节麦克风音量开关 */
        HWM_ENABLE_FEATURE_BREAKOUT_CONF,                 /**< [en]Breakout conf switch
                                                               [cn]分组讨论开关 */
        HWM_ENABLE_FEATURE_CONFIRM_RECORD,                /**< [en]recording confirm
                                                               [cn]录制确认 */
        HWM_ENABLE_FEATURE_VOICEPRINT_NOISE_REDUCE,       /**< [en]Voiceprint noise reduce
                                                               [cn]声纹降噪 */
        HWM_ENABLE_FEATURE_DEFAULT_SHARE_AUDIO,           /**< [en]Default value for share audio
                                                               [cn]默认共享音频开关 */
        HWM_ENABLE_FEATURE_SUPPORT_DISCONNECT_AUDIO,      /**< [en]Support Disconnect audio
                                                               [cn]支持断开音频功能 */
        HWM_ENABLE_FEATURE_DISCONNECT_AUDIO_TO_JOIN_CONF, /**< [en]Disconnect audio to join conf
                                                               [cn]是否断开音频入会 */
        HWM_ENABLE_FEATURE_CPU_REDUCTION_DETECT,          /**< [en]CPU frequency reduction detection
                                                               [cn]是否启用CPU降频检测 */
        HWM_ENABLE_FEATURE_WITHOUT_MAIN_FRAME,            /**< [en]Config without main frame
                                                               [cn]配置无主界面
                                                               [doc:disable] */
        HWM_ENABLE_FEATURE_SUPPORT_GUEST_INVITE,          /**< [en]Is support guest invite.
                                                               [cn]是否支持与会者邀请 */
        HWM_ENABLE_FEATURE_HIDE_INVITE_RESULT_TOAST,      /**< [en]Hide invite result toast.
                                                               [cn]是否隐藏与会者邀请结果提示 */
        HWM_ENABLE_FEATURE_SUPPORT_AUTO_ACCEPT_REMOTE_CONTROL,          /**< [en]Is support auto accept remote control.
                                                                             [cn]是否支持自动接受远程控制(仅对win平台生效) */
        HWM_ENABLE_FEATURE_HIDE_OFFLINE_PARTICIPANT_LIST, /**< [en]Is support hide the unjoined conference tab in the participant list.
                                                               [cn]是否支持隐藏与会者列表未入会标签 */
        HWM_ENABLE_FEATURE_HIDE_VB_RISK_TIP,              /**< [en]Hide virtual background risk tip.
                                                               [cn]是否隐藏虚拟背景隐私风险提示 */
        HWM_ENABLE_FEATURE_CONF_END_SHOW_TIPS,            /**< [en]Is conf end show tips
                                                               [cn]是否会议结束显示提示 */
        HWM_ENABLE_FEATURE_TYPE_BUTT
    } HwmEnableFeatureType;

    /**
     * [en]Conf server type
     * [cn]会议服务类型
     */
    typedef enum tagHwmConfServerType
    {
        CONF_SERVER_TYPE_MCU = 0,      /**< [en]Indicates conference server type MCU
                                            [cn]MCU会议 */
        CONF_SERVER_TYPE_RTC,          /**< [en]Indicates conference server type RTC
                                            [cn]RTC会议 */
    } HwmConfServerType;

    /**
     * [en]This structure is summary state.
     * [cn]会议纪要状态
     */
    typedef enum tagHwmSummaryState
    {
        SUMMARY_STATE_CLOSE = 0,                 /**< [en]Indicates summary close
                                                      [cn]会议纪要关闭 */
        SUMMARY_STATE_OPEN,                      /**< [en]Indicates summary open
                                                      [cn]会议纪要开启 */
    }HwmSummaryState;

    /**
     * [en]This enum is used to describe auto mute type<br>
     * [cn] 自动静音类型
     */
    typedef enum tagHwmAutoMuteType
    {
        AUTO_MUTE_TYPE_DEFAULT, /**< [en]Indicates auto mute type of default. [cn]默认 */
        AUTO_MUTE_TYPE_MUTE,    /**< [en]Indicates auto mute type of mute. [cn]静音 */
        AUTO_MUTE_TYPE_UNMUTE,  /**< [en]Indicates auto mute type of unmute. [cn]非静音 */
    }HwmAutoMuteType;

    /** 
     * [en]permit call in type.
     * [cn]允许呼入范围类型
     */
    typedef enum tagHwmJoinConfPermissionType
    {
        RESTRICTION_CALL_IN_ALL = 0,                   /**< [en]All user
                                                            [cn]所有用户 */
        RESTRICTION_CALL_IN_NON_ANONYMOUSE,            /**< [en]Non-anonymouse user
                                                            [cn]非匿名用户 */
        RESTRICTION_CALL_IN_COMPANY,                   /**< [en]Company user
                                                            [cn]企业内用户 */
        RESTRICTION_CALL_IN_INVITED,                   /**< [en]Invited user
                                                            [cn]被邀请用户 */
    } HwmJoinConfPermissionType;

    /** 
     * [en]conf list update type.
     * [cn]会列表更新方式
     */
    typedef enum tagHwmConflistUpdateType
    {
        CONFLIST_UPDTAE_ALL = 0,                   /**< [en]all update
                                                        [cn]全量更新 */
        CONFLIST_UPDATE_ADD,                       /**< [en]add
                                                        [cn]增加 */
        CONFLIST_UPDATE_DELETE,                    /**< [en]delete
                                                        [cn]删除 */
    } HwmConflistUpdateType;

    /** 
     * [en]vmr id type.
     * [cn]vmr id类型
     */
    typedef enum tagHwmVmrIdType
    {
        RANDOM_MEETING_ID = 0,                   /**< [en]random meeting id
                                                      [cn]随机会议id */
        PERSONAL_MEETING_ID,                     /**< [en] personal meeting id
                                                      [cn]个人会议id */
        CLOUD_MEETING_ROOM_ID,                   /**< [en]vmr meeting id
                                                      [cn]云会议室id */
    } HwmVmrIdType;

    /**
     * [en]vmr type.
     * [cn]vmr 类型
     */
    typedef enum tagHwmVmrType
    {
        COMMERCIAL_TYPE = 0,                        /**< [en]Indicates commercial type
                                                         [cn]商用版本*/
        TRIAL_TYPE,                                 /**< [en]Indicates trial type
                                                         [cn]试用版本*/
    } HwmVmrType;

    /**
    * [en]WaterMark font color.
    * [cn]水印字体颜色
    */
    typedef enum tagHwmWaterMarkColorType
    {
        HWM_WATERMARK_COLOR_TYPE_LIGHT = 0,         /**< [en]light color
                                                          <br>浅色 #CCCCCC*/
        HWM_WATERMARK_COLOR_TYPE_STANDARD,          /**< [en]standard color
                                                          <br>标准色 #999999*/
        HWM_WATERMARK_COLOR_TYPE_DARKER,            /**< [en]dark color
                                                          <br>深色 #666666*/
    }HwmWaterMarkColorType;
    
    /** 
     * [en]server site type.
     * [cn]服务站点类型
     */
    typedef enum tagHwmSiteType
    {
        SITE_TYPE_CHINA = 0,                   /**< [en]site of China
                                                 <br>中国站点 （默认） */
        SITE_TYPE_AP,                         /**< [en] site of Asia
                                                 <br>[cn]亚太站点 */
    } HwmSiteType;
    
    /**
     * [en]This enum is used to describe attendee type<br>
     * [cn]成员类型
     */
    typedef enum tagHwmAttendeeType
    {
        ATTENDEE_TYPE_NORMAL = 0,                               /**< [en]Indicates normal: Voice, HD, SD participants address
                                                                [cn]语音、高清、标清与会者地址 */
        ATTENDEE_TYPE_TELEPRESENCE,                             /**< [en]Indicates telepresence participants address type, single screen, three screen telepresence all belong to this
                                                                [cn]智真与会者地址类型，单屏、三屏智真均属此类 */
        ATTENDEE_TYPE_TERMINAL,                                 /**< [en]Indicates conference room or hard terminal
                                                                [cn]会议室或硬终端 */
        ATTENDEE_TYPE_OUTSIDE,                                  /**< [en]Indicates outside attendee
                                                                [cn]外部与会人 */
        ATTENDEE_TYPE_CUSTOMNUMBER,                             /**< [en]Indicates custom number
                                                                [cn]custom number*/
        ATTENDEE_TYPE_MOBILE,                                   /**< [en]Indicates mobile user
                                                                [cn]软终端用户手机 */
        ATTENDEE_TYPE_ANONYMOUS,                                /**< [en]Indicates anonymous user
                                                                [cn]匿名用户 */
        ATTENDEE_TYPE_TELEPHONE,                                /**< [en]Indicates telephone user
                                                                [cn]电话用户 */
        ATTENDEE_TYPE_BOARD,                                    /**< [en]Indicates board user
                                                                [cn]白板用户 */
        ATTENDEE_TYPE_IDEAHUB,                                  /**< [en]Indicates ideahub user
                                                                [cn]海思芯片的大屏设备 */
        ATTENDEE_TYPE_HWVISION,                                 /**< [en]Indicates hwvision user
                                                                [cn]智慧屏 */
        ATTENDEE_TYPE_WELINKC                                   /**< [en]Indicates welinkc user
                                                                [cn]welink大众版 */
    } HwmAttendeeType;

    /**
    * [en]This struct is used to describe the status of low net work
    * [cn]网络状态
    */
    typedef enum tagHwmLowNetWorkStatus
    {
        LOW_NET_WORK_STATUS_NORMAL,         /**< [en]Indicates staus normal
                                                 [cn]网络正常*/
        LOW_NET_WORK_STATUS_BAD,            /**< [en]Indicates staus bad
                                                 [cn]网络差*/
        LOW_NET_WORK_STATUS_VERY_BAD,       /**< [en]Indicates staus very bad
                                                 [cn]网络非常差*/
    }HwmLowNetWorkStatus;

    /**
    * [en]watch item param
    * [cn]选看入参
    */
    typedef enum tagHwmWndType
    {
        HWM_WND_TYPE_NORMAL,             /**< [en]Normal window
                                              [cn]普通窗口 */
        HWM_WND_TYPE_MAIN,               /**< [en]Main window
                                              [cn]主要窗口 */
    }HwmWndType;

    /**
    * [en]Stream type
    * [cn]流类型
    */
    typedef enum tagHwmStreamType
    {
        STREAM_TYPE_NONE = 0,         /**< [en]No stream
                                           [cn]没有流
                                           [ios:rename:none]*/
        STREAM_TYPE_PICTURE,          /**< [en]Picture stream
                                           [cn]图片流
                                           [ios:rename:picture]*/
        STREAM_TYPE_VIDEO,            /**< [en]Video stream
                                           [cn]视频流
                                           [ios:rename:video]*/
    } HwmStreamType;

    /**
    * [en]Record auth type.
    * [cn]录播鉴权方式
    */
    typedef enum tagHwmRecordAuthType
    {
        REOCRD_AUTH_TYPE_ANYONE = 0,        /**< [en]
                                                 [cn]可通过连接观看/下载（不拼接nonce）*/
        REOCRD_AUTH_TYPE_IN_COMPANY_USER,   /**< [en]
                                                 [cn]企业用户可观看/下载 */
        REOCRD_AUTH_TYPE_ATTENDEE,          /**< [en]
                                                 [cn]与会者可观看/下载*/
    } HwmRecordAuthType;

    /**
    * [en]allow join conference user type.
    * [cn]允许加入会议的用户类型
    */
    typedef enum tagHwmConfAllowJoinUserType
    {
        CONF_ALLOW_JOIN_ANYONE = 0,                 /**< [en]Anyone
                                                         [cn]所有用户。
                                                         [ios:rename:Anyone]*/
        CONF_ALLOW_JOIN_LOGINED_USER,               /**< [en]logined user
                                                         [cn]已登录用户。
                                                         [ios:rename:LoginedUser]*/
        CONF_ALLOW_JOIN_IN_COMPANY_USER,            /**< [en]Company user
                                                         [cn]企业内用户。
                                                         [ios:rename:InCompanyUser]*/
        CONF_ALLOW_JOIN_INVITED_USER,               /**< [en]Invited user
                                                         [cn]被邀请用户。
                                                         [ios:rename:InvitedUser]*/
    }HwmConfAllowJoinUserType;

    /**
    * [en]This enum is used to describe create conference model
    * [cn] 创建会议model
    */
    typedef enum tagHwmConfCreateMode
    {
        CONF_CREATE_MODE_DEFAULT = 0,            /**< [en]Indicates default
                                                      [cn]保留 */
        CONF_CREATE_MODE_P2PTransToConf = 1,     /**< [en]Indicates p2p transfer to conf
                                                      [cn]2转3 */
        CONF_CREATE_MODE_MmrP2PTransToConf = 2,  /**< [en]Indicates mmr p2p transfer to conf
                                                      [cn]mmr2转3 */
        CONF_CREATE_MODE_MMR_P2P = 3,            /**< [en]Indicates mmr p2p.
                                                      [cn]mmr点对点*/
        CONF_CREATE_MODE_LOCAL_PROJECT = 4       /**< [en]Indicates local project.
                                                      [cn]本地投屏*/
    }HwmConfCreateMode;

    /**
    * [en]This enum is used to describe share state
    * [cn] 数据共享状态
    */
    typedef enum tagHwmShareState
    {
        CONF_SHARE_STATE_CLOSE = 0,   /**< [en]Indicates no one is sharingh
                                           [cn]非数据共享状态 */
        CONF_SHARE_STATE_OPEN = 1     /**< [en]Indicates some one is sharing
                                           [cn]数据共享状态 */
    }HwmShareState;

    /**
    * [en]This enum is used to describe conference recording mode.
    * [cn]会议录制模式
    */
    typedef enum tagHwmConfRecordMode
    {
        CONF_RECORD_DISABLE,                /**< [en]Indicates disable record
                                                 [cn]禁止录制 */
        CONF_RECORD_LIVE,                   /**< [en]Indicates live
                                                 [cn]直播模式 */
        CONF_RECORD_RECORD,                 /**< [en]Indicates record broadcast
                                                 [cn]录播模式 */
        CONF_RECORD_LIVE_AND_RECORD,        /**< [en]Indicates live broadcast and record broadcast
                                                 [cn]直播 + 录播模式 */
    }HwmConfRecordMode;

    /**
    * [en]This enum is used to describe conference IM mode.
    * [cn]会中聊天模式
    */
    typedef enum tagHwmConfIMType
    {
        CONF_IM_TYPE_RTM = 0,       /**< [en]Indicates use welink-rtm.
                                         [cn]使用welink-rtm实现会中聊天 */
        CONF_IM_TYPE_CIM            /**< [en]Indicates use conf im.
                                         [cn]使用会控自带IM实现会中聊天 */
    } HwmConfIMType;

    /**
    * [en]This enumeration is used to describe verify mode.
    * [cn]认证模式
    */
    typedef enum tagHwmVerifyMode
    {
        VERIFY_MODE_NONE = 0,                       /**< [en]Indicates no authentication.
                                                         [cn]不认证 */
        VERIFY_MODE_SERVER,                         /**< [en]Indicates authentication server.
                                                         [cn]认证服务端 */
        VERIFY_MODE_BUTT                            
    }HwmVerifyMode;

    /**
    * [en]Custom image scene.
    * [cn]自定义图标场景
    */
    typedef enum tagHwmUICustomImageScene
    {
        CLOUD_RECORD_ICON_IMAGE_SCENE,              /**< [en]Cloud record image
                                                         [cn]会中云录制主图标（云录制菜单弹框、与会者列表、共享工具条） */
        MAIN_WINDOW_CLOUD_RECORD_ICON_SCENE,        /**< [en]Main window cloud record icon
                                                         [cn]主窗口云录制ICON小图标 */
        MAIN_WINDOW_CLOUD_RECORD_LOGO_SCENE,        /**< [en]Main window cloud record logo
                                                         [cn]主窗口云录制LOGO大图标 */
    } HwmUICustomImageScene;

    /**
    * [en]This enum is used to describe the status of local record.
    * [cn]本地录制状态
    */
    typedef enum tagHwmLocalRecordStatus
    {
        LOCAL_RECORD_STATUS_START = 0,      /**< [en]Indicates start local record
                                                 [cn]开始本地录制 */
        LOCAL_RECORD_STATUS_STOPPED = 1,    /**< [en]Indicates stopped local record
                                                 [cn]停止本地录制 */
        LOCAL_RECORD_STATUS_PAUSED = 2,     /**< [en]Indicates paused local record
                                                 [cn]暂停本地录制 */
        LOCAL_RECORD_STATUS_RESUMED = 3     /**< [en]Indicates resumed local record
                                                 [cn]恢复本地录制 */
    } HwmLocalRecordStatus;

    /**
    * [en]This struct is used to describe deploy type.
    * [cn]部署类型参数
    */
    typedef enum tagHwmDeployType
    {
        CLOUD_MODE = 0,     /**< [en]Indicates cloud mode
                                 [cn]云上模式 */
        SINK_MODE,          /**< [en]Indicates sink mode
                                 [cn]下沉模式 */
    }HwmDeployType;

    /**
    * [en]This enumeration is used to describe login state.
    * [cn]登录状态
    */
    typedef enum tagHwmLoginState
    {
        LOGIN_STATUS_UN_LOGIN = 0,                      /**< [en]Unlogin.
                                                             [cn]未登录 */
        LOGIN_STATUS_LOGINING,                          /**< [en]Logining.
                                                             [cn]登录中 */
        LOGIN_STATUS_LOGINED,                           /**< [en]Logined.
                                                             [cn]已登录 */
        LOGIN_STATUS_LOGOUTING,                         /**< [en]Logouting.
                                                             [cn]登出中 */
        LOGIN_STATUS_BUTT                               /**< [en]Invalid
                                                             [cn]无效值 */
    }HwmLoginState;

    /**
    * [en]Name show type.
    * [cn]姓名显示风格
    */
    typedef enum tagHwmNameShowType
    {
        FIRST_LETTER,                               /**< [en]First letter
                                                         [cn]显示拼音首字母 */
        FAMILY_NAME,                                /**< [en]Family name
                                                         [cn]显示姓氏 */
    } HwmNameShowType;

    /**
    * [en]Avatar shape.
    * [cn]头像形状
    */
    typedef enum tagHwmAvatarShape
    {
        CIRCLE,                                     /**< [en]Circle
                                                         [cn]圆形头像 */
    } HwmAvatarShape;

    /**
    * [en]This enum is used to describe the operate of local record.
    * [cn]本地录制操作类型
    */
    typedef enum tagHwmLocalRecordOperateType
    {
        LOCAL_RECORD_OPERATE_TYPE_START = 0,      /**< [en]Indicates start local record
                                                       [cn]开始本地录制 */
        LOCAL_RECORD_OPERATE_TYPE_STOP = 1,       /**< [en]Indicates stopped local record
                                                       [cn]停止本地录制 */
        LOCAL_RECORD_OPERATE_TYPE_PAUSE = 2,      /**< [en]Indicates paused local record
                                                       [cn]暂停本地录制 */
        LOCAL_RECORD_OPERATE_TYPE_RESUME = 3      /**< [en]Indicates resumed local record
                                                       [cn]恢复本地录制 */
    } HwmLocalRecordOperateType;

    /**
    * [en]This enumeration is used to describe the subtitle translation language type.
    * [cn]字幕翻译语言类型
    */
    typedef enum tagHwmTargetLanguageType
    {
        SUBTITLE_LANGUAGE_DEFAULT = 0,  /**<  [en]Indicates is default     lan.
                                              [cn]默认不翻译 */
        SUBTITLE_LANGUAGE_CN = 1,           /**<  [en]Indicates is Chinese     lan.
                                              [cn]中文 */
        SUBTITLE_LANGUAGE_EN = 2,           /**<  [en]Indicates is English     lan.
                                              [cn]英文 */
        SUBTITLE_LANGUAGE_GE = 3,           /**<  [en]Indicates is Germany     lan.
                                              [cn]德文 */
        SUBTITLE_LANGUAGE_FR = 4,           /**<  [en]Indicates is French      lan.
                                              [cn]法语 */
        SUBTITLE_LANGUAGE_RU = 5,           /**<  [en]Indicates is Russian     lan.
                                              [cn]俄语 */
        SUBTITLE_LANGUAGE_JA = 6,           /**<  [en]Indicates is Japanese    lan.
                                              [cn]日语 */
        SUBTITLE_LANGUAGE_KO = 7,           /**<  [en]Indicates is Korean      lan.
                                              [cn]韩语 */
        SUBTITLE_LANGUAGE_ES = 8,           /**<  [en]Indicates is Spanish     lan.
                                              [cn]西班牙语 */
        SUBTITLE_LANGUAGE_PT = 9,           /**<  [en]Indicates is Portuguese  lan.
                                              [cn]葡萄牙语 */
        SUBTITLE_LANGUAGE_AR = 10,           /**<  [en]Indicates is Arabic      lan.
                                              [cn]阿拉伯语 */
        SUBTITLE_LANGUAGE_IT = 11,           /**<  [en]Indicates is Italian     lan.
                                              [cn]意大利语 */
        SUBTITLE_LANGUAGE_TH = 12,           /**<  [en]Indicates is Thai        lan.
                                              [cn]泰语*/
        SUBTITLE_LANGUAGE_ID = 13,           /**<  [en]Indicates is Indonesian  lan.
                                              [cn]印度尼西亚语*/
        SUBTITLE_LANGUAGE_MS = 14,           /**<  [en]Indicates is Malay       lan.
                                              [cn]马来语*/
        SUBTITLE_LANGUAGE_TR = 15            /**<  [en]Indicates is Turkish     lan.
                                              [cn]土耳其语*/
    } HwmTargetLanguageType;

    /**
    * [en]This enumeration is used to describe the interrupt type.
    * [cn]中断类型
    */
    typedef enum tagHwmInterruptType
    {
        SELECT_SAVE_PATH = 0,                     /**< [en]Indicates select save path
                                                       [cn]选择录制文件存放地址 */
        RISK_TIP = 1,                             /**< [en]Indicates risk tip confirm
                                                       [cn]开启安全录制提示 */
        INFLUENCE_RECORD_FOR_GALLERY = 2,         /**< [en]Indicates influence record for gallery
                                                       [cn]画廊模式录制效果不佳，需切换到演讲者视图 */
        SAVE_PATH_NOT_WRITEABLE = 3,              /**< [en]Indicates save path not writeable
                                                       [cn]路径无写入权限 */
        SAVE_TEMP_RECORD_FILE = 4,                /**< [en]Indicates save temp record file
                                                       [cn]保留临时录制文件提示 */
        HDCLOUD_PERFORMANCE_CONSUMPTION = 5,      /**< [en]Indicates hdcloud performance consumption confirm
                                                       [cn]云桌面会增加性能消耗 */
        NO_SPEAKER_DEVICE = 6                     /**< [en]Indicates no speaker device
                                                       [cn]无扬声器设备 */
    } HwmInterruptType;

    /**
    * [en]This struct is used to describe auto invite type.
    * [cn]自动邀请状态
    */
    typedef enum tagHwmAutoInviteType
    {
        AUTO_INVITE_NONE,           /**<[en]Indicates not set (default open auto-invite)
                                        [cn]不设置（默认自动邀请）*/
        AUTO_INVITE_OPEN,           /**<[en]Indicates auto-invite open.
                                        [cn]自动邀请开启 */
        AUTO_INVITE_CLOSE,          /**<[en]Indicates auto-invite close.
                                        [cn]自动邀请关闭 */
    } HwmAutoInviteType;

/* auto generate code insert, forbit delete */
/********************************************以下是结构体定义*****************************************************************/

    /** 
     * [en]Sdk info.
     * [cn]sdk信息
     */
    typedef struct tagHwmSdkInfo
    {
        char version[HWM_MAX_CLIENT_VERSION_LEN];        /**< [en]The version of sdk
                                                              [cn]版本号 */
    }HwmSdkInfo;

    /**
     * [en]login result info.
     * [cn]登录结果信息
     */
    typedef struct tagHwmLoginResult
    {
        char userUuid[HWM_MAX_DEVICE_UUID_LEN];     /**<[en]Indicates UUID.
                                                        [cn]UUID(由系统分配的真实的唯一用户标识) */
        char account[HWM_MAX_ACCOUNT_LEN];          /**<[en]account.
                                                        [cn]账号 */
        char thirdAccount[HWM_MAX_ACCOUNT_LEN];     /**<[en]third account.
                                                        [cn]第三方账号  */
        bool basicCallAbility;                      /**<[en]Indicates has call ability.
                                                        [cn]是否有点对点呼叫能力 */
        char corpId[HWM_MAX_CORP_ID_LEN];           /**<[en]Indicates corp id.
                                                        [cn]企业ID */
    }HwmLoginResult;

    /**
     * [en]logout result info.
     * [cn]登出结果信息
     */
    typedef struct tagHwmLogoutResult
    {
        char userUuid[HWM_MAX_DEVICE_UUID_LEN];     /**<[en]Indicates UUID.
                                                        [cn]UUID(由系统分配的真实的唯一用户标识) */
        char account[HWM_MAX_ACCOUNT_LEN];          /**<[en]account.
                                                        [cn]账号 */
        char thirdAccount[HWM_MAX_ACCOUNT_LEN];     /**<[en]third account.
                                                        [cn]第三方账号  */
    }HwmLogoutResult;

    /** 
     * [en]Share state info.
     * [cn]发送端共享状态信息
     */
    typedef struct tagHwmShareStateInfo
    {
        HwmState state;                             /**< [en]The share state
                                                         [cn]共享状态 */
        char name[HWM_MAX_DISPLAY_NAME_LEN];        /**< [en]The name
                                                         [cn]共享者名称 */
        char number[HWM_MAX_NUMBER_LEN];            /**< [en]The number
                                                         [cn]共享者号码 */
        HwmMonitor monitor;                         /**< [en]Index of monitor
                                                         [cn]屏幕类型 */
        HwmShareType shareType;                     /**< [en]Share type
                                                         [cn]共享类型 */
        HWND appHandle;                             /**< [en]App window handle
                                                         [cn]程序窗口句柄 */
        HwmStopShareReason stopShareReason;         /**< [en]Stop share reason
                                                         [cn]停止共享原因 */
    }HwmShareStateInfo;

    /** 
     * [en]Share state info.
     * [cn]接收端共享状态信息
     */
    typedef struct tagHwmRecvShareStateInfo
    {
        HwmState state;                             /**< [en]The share state
                                                         [cn]共享状态 */
        char name[HWM_MAX_DISPLAY_NAME_LEN];        /**< [en]The name
                                                         [cn]共享者名称 */
        char number[HWM_MAX_NUMBER_LEN];            /**< [en]The number
                                                         [cn]共享者号码 */
    }HwmRecvShareStateInfo;

    /** 
     * [en]Conf info.
     * [cn]会议信息
     */
    typedef struct tagHwmConfInfo
    {
        char url[HWM_MAX_URL_LEN];                      /**< [en]The url
                                                             [cn]会议链接 */
        char confId[HWM_MAX_CONF_ID_LEN];               /**< [en]Conf id
                                                             [cn]会议id */
        HwmConfRole role;                               /**< [en]Conf role
                                                             [cn]会议角色 */
        char chairmanPwd[HWM_MAX_CONF_PASSWORD_LEN];    /**< [en]Chairman passwoed
                                                             [cn]主席密码 */
        char generalPwd[HWM_MAX_CONF_PASSWORD_LEN];     /**< [en]general passwoed
                                                             [cn]来宾密码 */
        char subject[HWM_MAX_SUBJECT_LEN];              /**< [en]conf subject
                                                             [cn]会议主题 */
        char startTime[HWM_MAX_TIME_FORMATE_LEN];       /**< [en]start conf time
                                                             [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间 */
        char endTime[HWM_MAX_TIME_FORMATE_LEN];         /**< [en]edn conf time
                                                             [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间 */
        long long startTimeStamp;                       /**< [en]Indicates conference start time
                                                             [cn]会议开始时间(时间戳，单位秒) */
        long long endTimeStamp;                         /**< [en]Indicates conference end time
                                                             [cn]会议结束时间(时间戳，单位秒) */
        char scheduserName[HWM_MAX_USER_NAME_LEN];      /**< [en]Indicates scheduser name
                                                             [cn]预订者姓名 */
        char customInfo[HWM_MAX_CUSTOM_INFO_LEN];       /**< [en]Indicates User-defined extended information
                                                             [cn]自定义扩展信息 */
        bool isWebinar;                                 /**< [en]Indicates whether the conference is web conferencre.
                                                             [cn]是否是网络研讨会 */
        bool isOtherCorpConf;                           /**< [en]is other corp conf.
                                                             [cn]是否是外部企业的会议：如果是加入外部企业的会议或者匿名入会是true，否则是false */
        bool isCreator;                                 /**< [en]Indicates whether the user is the creator of the conference 
                                                             [cn]是否是会议预订者*/
        bool isInBreakoutSubConf;                       /**< [en]Indicates whether the user is in breakout sub conf
                                                             [cn]是否在讨论组中*/
    }HwmConfInfo;

    /** 
     * [en]Conf state info.
     * [cn]会议状态信息
     */
    typedef struct tagHwmConfStateInfo
    {
        HwmState state;                 /**< [en]The state
                                             [cn]会议状态 */
        HwmConfEndReason reason;        /**< [en]ConfEndReason
                                             [cn]离开会议原因 */
        bool isP2PConf;                 /**< [en]is p2p conf
                                             [cn]是否立即会议。 */
    }HwmConfStateInfo;

    /** 
     * [en]Remote control state info.
     * [cn]共享中远程控制状态信息
     */
    typedef struct tagHwmRemoteControlStateInfo
    {
        HwmState state;                               /**< [en]The share state
                                                           [cn]状态 */
        char name[HWM_MAX_DISPLAY_NAME_LEN];          /**< [en]The name
                                                           [cn]控制者名称 */
        char number[HWM_MAX_NUMBER_LEN];              /**< [en]The number
                                                           [cn]控制者号码 */
    }HwmRemoteControlStateInfo;

    /** 
     * [en]window info.
     * [cn]窗口信息
     */
    typedef struct tagHwmWindowInfo
    {
        int left;               /**< [en]The left coordinates
                                     [cn]左侧坐标 */
        int top;                /**< [en]The top coordinates
                                     [cn]上侧坐标 */
        unsigned int width;     /**< [en]The width
                                     [cn]宽度 */
        unsigned int height;    /**< [en]The height
                                     [cn]高度 */
    } HwmWindowInfo;

    /** 
     * [en]Pair Code.
     * [cn]配对码
     */
    typedef struct tagHwmPairCodeInfo
    {
        char pairCode[HWM_MAX_NUMBER_LEN];    /**< [en]Pair Code
                                                   [cn]配对码 */
        unsigned long long validTime;         /**< [en]Indicates valid time.
                                                   [cn]截止时间 */
    } HwmPairCodeInfo;

    /** 
     * [en]Corporation configuration information.
     * [cn]企业配置信息
     */
    typedef struct tagHwmCorpConfigInfo
    {
        bool enablePstn;                                  /**< [en]Is enable Pstn
                                                               [cn]是否支持手机呼叫 */
        bool enableSms;                                   /**< [en]Is enable sms
                                                               [cn]是否支持短信通知 */
        bool enableRecord;                                /**< [en]Is enable conference record
                                                               [cn]是否支持会议录制 */
        bool enableHighResolution;                        /**< [en]Is enable High Resolution
                                                               [cn]1080p企业配置设置*/
        char pstnNumber[HWM_MAX_NUMBER_LEN];              /**< [en]Pstn Number
                                                               [cn]pstn呼叫号码*/
        bool allowGuestStartConf;                         /**< [en]Indicates whether is allow guest start conf.
                                                               [cn]是否允许来宾提前启动会议*/
        unsigned int allowGuestStartConfTime;               /**< [en]Indicates join before host time.
                                                               [cn]允许来宾提前入会时间范围(单位：分钟) 0-随时，n-提前n分钟启动会议*/
        bool enableShowAddressBookStructure;              /**< [en]Is enable Show AddressBook
                                                               [cn]是否支持通讯录显示 */
        bool enableRoomsLocalRecord;                      /**< [en]Is enable Rooms local record
                                                               [cn]大屏是否支持本地录制 */
        bool supportController;                           /**< [en]Is support controller
                                                               [cn]是否支持控制器 */
        bool enableProjection;                            /**< [en]Is enable projection
                                                               [cn]是否支持共享投屏 */
        bool corpEnableSummary;                           /**< [en]Indicates corp enable summary
                                                               [cn]企业是否支持会议纪要 */
        bool corpEnableForbidScreenShots;                 /**< [en]Indicates corp enable forbid screen shots
                                                               [cn]企业是否支持禁止截屏 */
        bool supportMultiShare;                           /**< [en]Is support multi share
                                                               [cn]企业是否支持多人共享 */
        bool supportCollaborateCapability;                /**< [en]Is support collaborate
                                                               [cn]企业是否支持新辅流 */
        bool enableSelfCascadingMeeting;                  /**< [en]Is support cascading meeting
                                                               [cn]企业是否支持加入级联会议 */
        bool enableCrossCorpCascading;                    /**< [en]Is support across-enterprises cascading meeting
                                                               [cn]企业是否支持跨企业加入级联会议 */
        bool enableDataGuardAudio;                        /**< [en]Is enable data guard audio
                                                               [cn]企业是否支持音频暗水印 */
        bool enableDataGuardVideo;                        /**< [en]Is enable data guard video
                                                               [cn]企业是否支持视频暗水印 */
    } HwmCorpConfigInfo;

    /** 
     * [en]Conf coming information.
     * [cn]会议来电信息
     */
    typedef struct tagHwmConfIncomingInfo
    {
        HwmConfComingState state;                              /**< [en]Conf coming state
                                                                    [cn]来电状态 */
        HwmMediaType mediaType;                                /**< [en]Media type
                                                                    [cn]媒体类型 */
        bool isP2PConf;                                        /**< [en]is p2p conf
                                                                    [cn]是否立即会议。 */
        char confId[HWM_MAX_CONF_ID_LEN];                      /**< [en]Conf id
                                                                    [cn]会议id */
        char vmrId[HWM_MAX_VMR_ID_LEN];                        /**< [en]Indicates VMR conference id
                                                                    [cn]VMR会议ID */
        char thirdUserId[HWM_MAX_USER_ID_LEN];                 /**< [en]The attendee's third account
                                                                    [cn]与会者三方账号，appId登录时使用 */
        char invitorName[HWM_MAX_DISPLAY_NAME_LEN];            /**< [en]Invitor name.
                                                                    [cn]邀请者的姓名。会议自动外邀时是预订人，会中邀请时是操作人 */
        char invitorAliasCN[HWM_MAX_DISPLAY_NAME_LEN];         /**< [en]Invitor alias Chinese name.
                                                                    [cn]邀请者的中文别名 */
        char invitorAliasEN[HWM_MAX_DISPLAY_NAME_LEN];         /**< [en]Invitor alias English name.
                                                                    [cn]邀请者的英文别名 */
        char invitorExtendedField[HWM_MAX_OPEN_CUSTOM_PARA_LEN]; /**< [en]Invitor Indicates schedule.
                                                                      [cn]邀请者的扩展字段 */
        char invitorOrgId[HWM_MAX_ORG_ID_LENGTH];              /**< [en]Indicates org id.
                                                                    [cn]企业id */
        char schedulerName[HWM_MAX_DISPLAY_NAME_LEN];	       /**< [en]Indicates schedule user name.
                                                                    [cn]预订者姓名 */
        char schedulerAliasCN[HWM_MAX_DISPLAY_NAME_LEN];       /**< [en]Indicates schedule alias Chinese name.
                                                                    [cn]预订者中文别名 */
        char schedulerAliasEN[HWM_MAX_DISPLAY_NAME_LEN];	   /**< [en]Indicates schedule alias English name.
                                                                    [cn]预订者英文别名 */
        char schedulerExtendedField[HWM_MAX_OPEN_CUSTOM_PARA_LEN]; /**< [en]Indicates schedule extended field.
                                                                        [cn]预订者的扩展字段 */
    } HwmConfIncomingInfo;

    /**
    * [en]This enum is used to describe conference state.
    * [cn]会议状态
    */
    typedef enum tagHwmConfState
    {
        HWM_CONF_STATE_SCHEDULE = 0,        /**< [en]Indicates schedule state
                                                 [cn]预定状态*/
        HWM_CONF_STATE_CREATING,            /**< [en]Indicates be creating state
                                                 [cn]正在创建状态*/
        HWM_CONF_STATE_GOING,               /**< [en]Indicates conf going state
                                                 [cn]会议已经开始*/
        HWM_CONF_STATE_DESTROYED,           /**< [en]Indicates conf is destroyed
                                                 [cn]会议已经关闭*/
    }HwmConfState;

    /**< [en]Indicates conference type.
    *[cn]会议类型
    */
    typedef enum tagConferenceType
    {
        CONF_TYPE_COMMON = 0,       /**< [en]Indicates common conference.
                                         [cn]普通会议 */
        CONF_TYPE_CYCLE,            /**< [en]Indicates cycle conference.
                                         [cn]周期会议 */
    }ConferenceType;

    /**
    * [en]cycle type.
    * [cn]周期类型
    */
    typedef enum tagCycleType
    {
        CYCLE_TYPE_DAY = 0,        /**< [en]Indicates cycle by day.
                                        [cn]以天为周期 */
        CYCLE_TYPE_WEEK,           /**< [en]Indicates cycle by week.
                                        [cn]以周为周期 */
        CYCLE_TYPE_MONTH,          /**< [en]Indicates cycle by month.
                                        [cn]以月为周期 */
    }HwmCycleType;

    /**
    * [en]Indicates cycle conference param.
    * [cn]周期会议的参数
    */
    typedef struct tagCycleConfParam
    {
        long long startDate;                          /**< [en]Indicates conference start date.
                                                           [cn]（已废弃，推荐使用字段startTimeStamp）开始日期-时间戳，精度秒(0时区) */
        long long endDate;                            /**< [en]Indicates conference end date.
                                                           [cn]（已废弃，推荐使用字段endTimeStamp）结束日期-时间戳，精度秒(0时区) */
        long long startTimeStamp;                     /**< [en]Indicates conference start time
                                                           [cn]开始时间，startTimeStamp、startDate二选一，优先使用startTimeStamp(时间戳，单位秒) */
        long long endTimeStamp;                       /**< [en]Indicates conference end time
                                                           [cn]结束时间，endTimeStamp、endDate二选一，优先使用endTimeStamp(时间戳，单位秒) */
        HwmCycleType cycleType;                          /**< [en]Indicates cycle type. [cn]周期类型 */
        unsigned int interval;                          /**< [en]Indicates cycle interval. [cn]周期区间  1、周期类型选择了按天，表示每几天召开一次，取值范围[1,15]；2、周期类型选择了Week，表示每几周召开一次，取值范围[1,5]；3、周期类型选择了Month，interval表示隔几月，取值范围[1,3] */
        char listPoints[HWM_MAX_CONF_POINTS_LENGTH];   /**< [en]Indicates conference points. [cn]周期内的会议召开点。仅当按周和月时有效。数据格式(中间用逗号隔开):1,3,5,7 */
        unsigned int preRemindDays;                     /**< [en]Indicates prior notificate days. [cn]周期子会议提前通知天数。 */
    }HwmCycleConfParam;


    /**< [en]Indicates cycle conference param.
    *    [cn]周期子会议的参数
    **/
    typedef struct tagSubCycleConfParam
    {
        char subConfID[HWM_MAX_ACCOUNT_ID_LEN];         /**< [en]Indicates sub conference id. [cn]子会议唯一标识UUID */
        HwmMediaType confMediaType;                     /**< [en]Indicates media type [cn]会议媒体类型 */
        long long startTime;                            /**< [en]Indicates conference start time. [cn]（已废弃，推荐使用字段startTimeStamp）会议起始时间 */
        long long endTime;                              /**< [en]Indicates conference end time. [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间 */
        long long startTimeStamp;                       /**< [en]Indicates conference start time
                                                             [cn]会议开始时间(时间戳，单位秒) */
        long long endTimeStamp;                         /**< [en]Indicates conference end time
                                                             [cn]会议结束时间(时间戳，单位秒) */
        bool isAutoRecord;                              /**< [en]Indicates whether record automatically when conference begin.[cn]会议开始后是否自动开启录制  */
        unsigned int recordAuthType;                    /**< [en]Indicates record auth type. [cn]录播鉴权方式  0:可通过连接观看/下载（不拼接nonce）1:企业用户可观看/下载 2:与会者可观看/下载 */
        HwmJoinConfPermissionType callInRestriction;     /**< [en]Indicates call in restriction. [cn]呼入限制 */
        bool allowGuestStartConf;                       /**< [en]Indicates is allow guest start conf. [cn]允许来宾启动会议 */
        unsigned int allowGuestStartConfTime;           /**< [en]Indicates join before host time. [cn]允许来宾提前入会时间范围(单位：分钟) 0-随时，n-提前n分钟启动会议*/
    }HwmSubCycleConfParam;

    /**
    * [en]Conf list information.
    * [cn]会议列表信息
    */
    typedef struct tagHwmConfListInfo
    {
        char confId[HWM_MAX_CONF_ID_LEN];                   /**< [en]Indicates conference id
                                                                 [cn]会议id */
        char confSubject[HWM_MAX_SUBJECT_LEN];              /**< [en]Indicates conference subject
                                                                 [cn]会议主题 */
        char accessNumber[HWM_MAX_ACCESS_NUM_LEN];          /**< [en]Indicates conference access number
                                                                 [cn]会议接入码 */
        char chairmanPwd[HWM_MAX_PASSWORD_LEN];             /**< [en]Indicates chairman password
                                                                 [cn]主席密码 */
        char guestPwd[HWM_MAX_PASSWORD_LEN];                /**< [en]Indicates general password
                                                                 [cn]来宾密码 */  
        char audiencePwd[HWM_MAX_CONF_PASSWORD_LEN];		/**< [en]Indicates the password of audience.
                                                                 [cn]观众密码 */
        long long startTime;                                /**< [en]Indicates conference start time
                                                                 [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间 时间戳 */
        long long endTime;                                  /**< [en]Indicates conference end time
                                                                 [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间 时间戳 */
        long long startTimeStamp;                           /**< [en]Indicates conference start time
                                                                 [cn]会议开始时间(时间戳，单位秒) */
        long long endTimeStamp;                             /**< [en]Indicates conference end time
                                                                 [cn]会议结束时间(时间戳，单位秒) */
        char timeZone[MAX_TIME_ZONE_LEN];                   /**< [en]Indicates time zone
                                                                 [cn]时区 */
        HwmMediaType mediaType;                             /**< [en]Indicates media type
                                                                 [cn]媒体类型*/
        char scheduserName[HWM_MAX_USER_NAME_LEN];          /**< [en]Indicates scheduser name
                                                                 [cn]预订者姓名 */
        char vmrConferenceId[HWM_MAX_VMR_CONF_ID_LEN];      /**< [en]Indicates VMR conference id
                                                                 [cn]VMR会议显示ID */
        bool supportTerminal;                               /**< [en]Indicates whether is support invite Terminal.
                                                                 [cn]是否支持邀请硬终端入会 */
        char chairJoinUri[HWM_MAX_URL_LEN];                 /**< [en]the uri used by chairman to join conference. 
                                                                 [cn]主持人加入会议uri链接 */
        char guestJoinUri[HWM_MAX_URL_LEN];                 /**< [en]Indicates the uri for general to join conference.
                                                                 [cn]来宾加入会议uri链接 */
        char audienceJoinUri[HWM_MAX_URL_LEN];				/**< [en]Indicates the uri for audience to join conference.
                                                                 [cn]观众加入会议的链接 */
        HwmConfState confStateType;                         /**< [en]Indicates conference state.
                                                                 [cn]会议状态 */
        bool isWebinar;										/**< [en]Indicates whether the conference is web conferencre.
                                                                 [cn]是否是网络研讨会 */
        HwmConfRole selfConfRole;							/**< [en]Indicates self role.
                                                                 [cn]本人在会议中的角色 */
        ConferenceType conferenceType;                      /**< [en]Indicates conference type.
                                                                 [cn]会议类型 */
        HwmCycleConfParam cycleParam;                          /**< [en]Indicates cycle conference param.
                                                                 [cn]周期会议的参数 */
        unsigned int subConfSize;                           /**< [length for subConfParam][en]Indicates cycle sub conference size.
                                                                 [cn]周期子会议数量 */
        HwmSubCycleConfParam *subConfParam;                 /**< [en]Indicates cycle sub conference param.
                                                                 [cn]周期子会议参数 */
        char customInfo[HWM_MAX_CUSTOM_INFO_LEN];           /**< [en]Indicates User-defined extended information
                                                                 [cn]自定义扩展信息 */
    } HwmConfListInfo;

    /** 
     * [en]Vmr information.
     * [cn]云会议室信息
     */
    typedef struct tagHwmVmrInfo
    {
        char vmrConferenceId[HWM_MAX_CONF_ID_LEN];        /**< [en]Indicates vmr conference id
                                                               [cn]vmr会议id */
        char vmrId[HWM_MAX_VMR_CONF_ID_LEN];              /**< [en]Indicates vmr id
                                                               [cn]云会议室id */
        char chairmanPwd[HWM_MAX_PASSWORD_LEN];           /**< [en]Indicates chairman password of the vmr conf
                                                               [cn]vmr会议主席密码 */
        char guestPwd[HWM_MAX_PASSWORD_LEN];              /**< [en]Indicates guest password of the vmr conf
                                                               [cn]vmr会议来宾密码 */
        HwmVmrIdType type;                                /**< [en]Indicates the type of the vmr
                                                               [cn]vmr类型 */
        int maxParties;                                   /**< [en]Indicates the max party size of the vmr
                                                               [cn]云会议室最大方数 */
        bool vmrEnable;                                   /**< [en]Indicates whether the vmr is enable
                                                               [cn]云会议室是否可用 */
        char name[HWM_MAX_VMR_NAME_LEN];                  /**< [en]Indicates the name of the vmr
                                                               [cn]云会议室名称 */
        unsigned long long remainingHours;                /**< [en]Indicates remaining hours. 
                                                               [cn]剩余时间 单位：小时*/
        unsigned long long expireDate;                    /**< [en]Indicates expire data. 
                                                               [cn]过期时间 时间戳*/
        HwmVmrType vmrType;                               /**< [en]Indicates VMR type.
                                                               [cn]VMR模式，0商用，1试用 */
        unsigned int duration;                            /**< [en]Indicates max time for trial users.
                                                               [cn]试用会议的最大时长，0表示不限制时长 */
        bool allowGuestStartConf;                         /**< [en]Indicates whether is allow guest start conf.
                                                               [cn]是否允许来宾提前启动会议*/
        HwmJoinConfPermissionType joinConfRestrictionType;/**< [en]Indicates the user type allowed to join the conference.
                                                               [cn]允许入会范围限制。默认所有用户。*/
        bool isOpenWaitingRoom;                           /**< [en]Indicates whether is open waiting room
                                                               [cn]等候室开启开关。
                                                               说明：需要等候室功能开通后才能生效*/
    } HwmVmrInfo;

    /**
    * [en]This structure is used to describe corp type
    * [cn]企业类型
    **/
    typedef enum tagHwmCorpType
    {
        HWM_CORP_TYPE_ENTERPRISE = 0,           /**< [en]Enterprise version, also known as flagship version.
                                                     [cn]企业版，即旗舰版 */
        HWM_CORP_TYPE_PUBLIC_REGISTER,          /**< [en]Public enterprises, phone or email user.
                                                     [cn]公共企业，手机、邮箱注册时会放到该企业内 */
        HWM_CORP_TYPE_PUBLIC_VISION,            /**< [en]Public enterprises, smart screens user.
                                                     [cn]公共企业，智慧屏用户自动开户时会放到该企业内 */
        HWM_CORP_TYPE_PUBLIC_WHITE_BOARD,       /**< [en]Public enterprises, board user.
                                                     [cn]公共企业，大屏用户自动开户时会放到该企业内 */
        HWM_CORP_TYPE_PUBLIC_CONSUMER,          /**< [en]Public TOC Consumers.
                                                     [cn]公共TOC消费者企业 */
        HWM_CORP_TYPE_FREE,                     /**< [en]Free version.
                                                     [cn]免费版 */
        HWM_CORP_TYPE_PROFESSIONAL              /**< [en]Professional version, also known as Flexus version.
                                                     [cn]专业版, 即Flexus版 */
    }HwmCorpType;

    /**
    * [en]Vmr list info.
    * [cn]云会议室列表信息
    */
    typedef struct tagHwmVmrListInfo
    {
        unsigned int numOfVmrs;                             /**< [en]Indicates the number of specific vmr conference.
                                                                 [cn]云会议室个数
                                                                 [length for vmrs] */
        HwmVmrInfo* vmrs;                                   /**< [en]Indicates the specific vmr conference information.
                                                                 [cn]云会议室信息 */
        bool isEnableShareVmr;                              /**< [en]Indicates whether is share vmr.
                                                                 [cn]是否开启共享vmr */
        HwmCorpType corpType;                               /**< [en]Indicates corp type.(only for windows)
                                                                 [cn]企业类型(仅对win平台生效)
                                                                 [doc:disable]
                                                                 [mac:disable] */
    }HwmVmrListInfo;

    /**
    * [en]This enum is used to describe attendee state.
    * [cn]成员状态
    */
    typedef enum tagConfAttendeeState
    {
        CONF_ATTENDEE_STATE_IN_CONF = 0,     /**< [en]Indicates in conference
                                                             [cn]会议中
                                                             [ios:rename:InConf]*/
        CONF_ATTENDEE_STATE_CALLING,         /**< [en]Indicates is calling
                                                             [cn]正在呼叫
                                                             [ios:rename:Calling]*/
        CONF_ATTENDEE_STATE_JOINING,         /**< [en]Indicates is joining conference
                                                             [cn]正在加入会议
                                                             [ios:rename:Joining]*/
        CONF_ATTENDEE_STATE_LEAVED,          /**< [en]Indicates have leaved
                                                             [cn]已经离开
                                                             [ios:rename:Leaved]*/
        CONF_ATTENDEE_STATE_NO_EXIST,        /**< [en]Indicates not exist
                                                             [cn]用户不存在
                                                             [ios:rename:NoExist]*/
        CONF_ATTENDEE_STATE_BUSY,            /**< [en]Indicates callee is busy
                                                             [cn]被叫用户忙
                                                             [ios:rename:Busy]*/
        CONF_ATTENDEE_STATE_NO_ANSWER,       /**< [en]Indicates no answer
                                                             [cn]用户无应答
                                                             [ios:rename:NoAnswer]*/
        CONF_ATTENDEE_STATE_REJECT,          /**< [en]Indicates user reject answer
                                                             [cn]用户拒绝接听
                                                             [ios:rename:Reject]*/
        CONF_ATTENDEE_STATE_CALL_FAILED,     /**< [en]Indicates call failed
                                                             [cn]呼叫失败
                                                             [ios:rename:Failed]*/
    }ConfAttendeeState;

    /**
    * [en]This structure is used to describe user corp info notify type
    * [cn]客户企业信息变化通知类型
    */
    typedef enum tagHwmUserCorpInfoNotifyType
    {
        HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_DELETE = 0,              /**< [en]Indicates user delete
                                                                          [cn]用户已注销 */
        HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_JOIN_NEW_CORP,           /**< [en]Indicates join new corp
                                                                          [cn]用户已加入新的企业（接受邀请、创建企业变成新企业的用户） */
        HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_LEAVE_CURRENT_CORP,      /**< [en]Indicates leave current corp
                                                                          [cn]用户已被移出当前企业（企业管理员删除、解散、用户主动离开企业变成注册用户） */
        HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_RESET,                   /**< [en]Indicates Smartrooms user is reset activation code or user is deleted
                                                                          [cn]用户重置（Smartrooms账号被重置激活码或者账号被删除） */
        HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_VMR_CHANGE,              /**< [en]Indicates vmr change
                                                                          [cn]用户vmr变化 */
        HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_NAME_CHANGE,             /**< [en]Indicates user name change
                                                                          [cn]用户姓名变更 */
        HWM_USER_CORP_INFO_NOTIFY_TYPE_USER_STATUS_CHANGE,           /**< [en]Indicates user status change
                                                                          [cn]接入账号状态变化 */
    }HwmUserCorpInfoNotifyType;

    /** 
     * [en]This struct is used to describe attendee info(before join conference)
     * [cn]与会者信息(入会前)
     */
    typedef struct tagHwmAttendeeInfo
    {
        char number[HWM_MAX_NUMBER_LEN];                    /**< [en]Indicates number
                                                                 [cn]号码 */
        char name[HWM_MAX_USER_NAME_LEN];                   /**< [en]Indicates name
                                                                 [cn]可选，与会者名称 */
        char aliasCN[HWM_MAX_DISPLAY_NAME_LEN];             /**< [en]Indicates chinese alias.
                                                                 [cn]中文别名（获取会中与会者信息使用）
                                                                 [cs_allowNull:Y] */
        char aliasEN[HWM_MAX_DISPLAY_NAME_LEN];             /**< [en]Indicates english alias.
                                                                 [cn]英文别名（获取会中与会者信息使用）
                                                                 [cs_allowNull:Y] */
        char extendedField[HWM_MAX_EXTENDED_FIELD_LEN];     /**< [en]Indicates extended field.
                                                                 [cn]扩展字段 */
        char email[HWM_MAX_EMAIL_LEN];                      /**< [en]Indicates email
                                                                 [cn]可选，电子邮箱地址 */
        char sms[HWM_MAX_PHONE_NUM_LEN];                    /**< [en]Indicates sms
                                                                 [cn]可选，短信通知手机号码 */
        bool isMute;                                        /**< [en]Indicates whether is mute
                                                                 [cn]是否闭音 */
        bool isAutoInvite;                                  /**< [en]Indicates whether is auto invite 
                                                                 [cn]是否自动外邀 */
        HwmConfRole  role;                                  /**< [en]Indicates role
                                                                 [cn]会议成员角色 */
        HwmAttendeeType type;                               /**< [en]This enum is used to describe attendee type<br>
                                                                 [cn]成员类型 */
        char thirdUserId[HWM_MAX_USER_ID_LEN];              /**< [en]The attendee's third account
                                                                 [cn]与会者三方账号，appId登录时使用*/
        char userUuid[HWM_MAX_NUMBER_LEN];                  /**< [en]Indicates user account
                                                                 [cn]与会唯一标识（welink使用） */
        ConfAttendeeState callStatus;                       /**< [en]Indicates participant state.
                                                                 [cn]与会者状态 */
        bool isAnonymous;                                   /**< [en]Indicates whether is anonymous.
                                                                 [cn]是否匿名用户(匿名方式加入会议) */
        char orgId[HWM_MAX_ORG_ID_LENGTH];                  /**< [en]Indicates org id.
                                                                 [cn]企业id */
        char accountId[MAX_ACCOUNT_ID_LEN];                 /**< [en]Indicates account id.
                                                                 [cn]可选，华为云会议账号 */
        bool isSelf;                                        /**< [en]is self.
                                                                 [cn]是否是自己 */
        bool isCollaborator;                                /**< [en]Indicates isCollaborator. 
                                                                 [cn]是否是协作者 */
        unsigned int userId;                                /**< [en]Indicates userId.
                                                                 [cn]与会者唯一标识
                                                                 [doc:disable] */
        bool hasModifyCustomInfoInConfCapability;           /**< [en]Indicates has modify custom info in conf capbility.
                                                                 [cn]是否支持会中修改参数能力 
                                                                 [doc:disable] */
    } HwmAttendeeInfo;

    /**
     * [en]VMR conf Id type.
     * [cn]云会议室的会议ID类型
     */
    typedef enum tagHwmVmrConfIdType
    {
        HWM_VMR_CONF_ID_TYPE_FIXED = 0,                    /**< [en]VMR conf Id type is fixed
                                                                [cn]云会议室的会议ID类型是固定类型 */

        HWM_VMR_CONF_ID_TYPE_RANDOM                        /**< [en]VMR conf Id type is random
                                                                [cn]云会议室的会议ID类型是随机类型 */
    }HwmVmrConfIdType;

    /**
     * [en]Conference information in detail.
     * [cn]会议详细信息
     */
    typedef struct tagHwmConfDetail
    {
        HwmConfListInfo confListInfo;                       /**< [en]Indicates conference basic info
                                                                 [cn]会议基本信息 */
        char vmrId[HWM_MAX_VMR_ID_LEN];                     /**< [en]Indicates VMR conference id
                                                                 [cn]VMR会议ID */
        bool vmrFlag;                                       /**< [en]Indicates whether is VMR conference
                                                                 [cn]是否是VMR会议 */
        bool isRecordOn;                                    /**< [en]whether record the conference
                                                                 [cn]是否录制会议 */
        bool isLiveOn;                                      /**< [en]Reserved.This field is used to transparently transmit conference details when editing a conference.
                                                                 [cn]保留。编辑会议时透传会议详情此字段 */
        bool isAutoRecord;                                  /**< [en]whether auto record the conference
                                                                 [cn]是否自动录制会议 */
        bool isGuestFreePwd;                                /**< [en]Indicates whether is guest free password
                                                                 [cn]是否来宾免密 */
        bool isMailOn;                                      /**< [en]Indicates whether is send email notify
                                                                 [cn]是否发送邮件通知 */
        bool isSmsOn;                                       /**< [en]Indicates whether is send sms
                                                                 [cn]是否发送短信通知 */
        bool isEmailCalenderOn;                             /**< [en]Indicates whether is send calendar notify
                                                                 [cn]是否发送日历通知 */
        HwmJoinConfPermissionType joinConfRestrictionType;  /**< [en]Call in restriction
                                                                 [cn]入会限制 */
        HwmAttendeeInfo* attendees;                         /**< [en]Indicates attendee list
                                                                 [cn]与会者列表 */
        unsigned int attendeeLen;                           /**< [en]Indicates the size of the attendee list
                                                                 [cn]与会者列表长度 */
        HwmConfServerType confServerType;                   /**< [en]Conference type
                                                                <[cn]会议服务器类型 1:RTC or 0:MCU */
        bool isOpenWaitingRoom;                             /**< [en]Indicates waiting room state.
                                                                 [cn]是否开启等候室 */
        HwmVmrConfIdType vmrConfIdType;                     /**< [en]VMR conf Id type.
                                                                 [cn]云会议室的会议ID类型 */
        bool allowGuestStartConf;                           /**< [en]Indicates whether is allow guest start conf.
                                                                 [cn]是否允许来宾提前启动会议*/
        bool forbiddenScreenShots;                          /**< [en] disable screenshots
                                                                 [cn] 是否禁止截屏 */
        unsigned int allowGuestStartConfTime;               /**< [en]Indicates join before host time.
                                                                 [cn]允许来宾提前入会时间范围(单位：分钟) 0-随时，n-提前n分钟启动会议*/
        char appAttribute[HWM_MAX_APP_ATTRIBUTE_LEN];       /**< [en]app attribute.
                                                                 [cn]第三方应用属性*/
        unsigned int concurrentParticipants;                /**< [en]concurrent participants.
                                                                 [cn]会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数*/
        bool supportSummary;                                /**< [en]Indicates supportSummary.
                                                                 [cn]支持会议纪要 */
        HwmSummaryState defaultSummaryState;                /**< [en]Indicates record include summary by default
                                                                 [cn]会议云录制是否包含纪要，初始值（周期会议暂不支持） */
        HwmAutoMuteType autoMuteMode;                       /**< [en]Indicates is auto mute of soft terminal
                                                                 [cn]软终端是否自动静音*/
        HwmAutoMuteType hardTerminalAutoMuteMode;           /**< [en]Indicates is auto mute of hard terminal
                                                                 [cn]硬终端是否自动静音*/
        bool supportMultiShare;                             /**< [en]Indicates support multi-share.
                                                                 [cn]是否支持多人共享 */
        bool supportWatermark;                              /**< [en]Indicates whether is support watermark.
                                                                 [cn]是否支持水印*/
        bool autoPublishSummary;                            /**< [en]Indicates Whether auto publish summary. 
                                                                 [cn]是否自动发布纪要（免人工审核）*/
        bool supportDataGuardAudio;                         /**< [en]Indicates whether is support data guard audio.
                                                                 [cn]是否支持音频暗水印 */
        bool supportDataGuardVideo;                         /**< [en]Indicates whether is support data guard video.
                                                                 [cn]是否支持视频暗水印 */
    } HwmConfDetail;

    /**
    * [en]This struct is used to describe the slider.
    * [cn]滑块信息
    */
    typedef struct tagHwmSliderParam
    {
        char shadowImageName[HWM_MAX_FILE_PATH_LEN];        /**< [en]Background picture
                                                                 [cn]背景图片 */
        char sliderImageName[HWM_MAX_FILE_PATH_LEN];        /**< [en]Slider picture
                                                                 [cn]滑块图片 */
        unsigned int pointY;                                /**< [en]The y-axis position of the slider
                                                                 [cn]滑块的y轴位置 */
    }HwmSliderParam;

    /**
    * [en]This enumeration is used to describe the call type.
    * [cn]呼叫类型
    */
    typedef enum tagHwmCallType
    {
        CALL_TYPE_AUDIO,             /**< [en]Indicates  audio call
                                          [cn]音频呼叫 */
        CALL_TYPE_VIDEO,             /**< [en]Indicates  video call
                                          [cn]视频呼叫 */
        CALL_TYPE_BUTT               /**< [en]Indicates invalid type call
                                          [cn]无效类型呼叫 */
    }HwmCallType;

    /**
    * [en]Call state
    * [cn]通话状态
    */
    typedef enum tagHwmCallState
    {
        HWM_CALL_STATE_INCOMING,               /**< [en]Incoming state
                                                    [cn]来电状态*/
        HWM_CALL_STATE_HANGUP,                 /**< [en]Hangup state
                                                    [cn]挂断状态 */
        HWM_CALL_STATE_CALLINGOUT,             /**< [en]Callingout state
                                                    [cn]呼出状态*/
        HWM_CALL_STATE_CONNECTED,              /**< [en]Connected state
                                                    [cn]接通状态 */
    } HwmCallState;

    /**
    * [en]Call end reason.
    * [cn]通话结束原因
    */
    typedef enum tagHwmCallEndReason
    {
        HWM_CALL_END_REASON_INVALID = 0,

        HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLER,          /**< [en]Hangup by caller(connected)
                                                                      [cn]主叫挂断（接通）*/
        HWM_CALL_END_REASON_CONNECTED_HANGUP_BY_CALLEE,          /**< [en]Hangup by callee(connected)
                                                                      [cn]被叫挂断（接通）*/
        HWM_CALL_END_REASON_HANGUP_BY_CALLER,                    /**< [en]Hangup by caller(unconnected)
                                                                      [cn]主叫挂断（未接通） */
        HWM_CALL_END_REASON_HANGUP_BY_CALLEE,                    /**< [en]Hangup by callee(unconnected)
                                                                      [cn]被叫挂断（未接通） */
        HWM_CALL_END_REASON_CALLEE_BUSY,                         /**< [en]Callee is busy(unconnected)
                                                                      [cn]被叫通话中（未接通） */
        HWM_CALL_END_REASON_CALLEE_ANSWER_TIMEOUT,               /**< [en]Callee no answer(unconnected)
                                                                      [cn]被叫超时未接听（未接通） */
        HWM_CALL_END_REASON_CALLEE_NUMBER_ERROR,                 /**< [en]Callee number error(unconnected)
                                                                      [cn]被叫号码错误（未接通） */
        HWM_CALL_END_REASON_FAILED,                              /**< [en]Call fail
                                                                      [cn]通话失败 */
    } HwmCallEndReason;

    /**
    * [en]Call state info.
    * [cn]通话状态信息
    */
    typedef struct tagHwmCallStateInfo
    {
        HwmCallState state;             /**< [en]Call state
                                             [cn]通话状态 */
        unsigned int callId;            /**< [en]Call id
                                             [cn]通话id */
    }HwmCallStateInfo;

    /**
    * [en]Call information
    * [cn]通话信息
    */
    typedef struct tagHwmCallInfo
    {
        HwmCallType callType;                            /**< [en]Call type
                                                              [cn]呼叫类型 */
        char number[HWM_MAX_NUMBER_LEN];                 /**< [en]Other party number
                                                              [cn]对方号码 */
        char name[HWM_MAX_USER_NAME_LEN];                /**< [en]Other party name
                                                              [cn]对方名称 */
        char startTime[HWM_MAX_TIME_FORMATE_LEN];        /**< [en]Start call time
                                                              [cn]呼叫开始时间 */
        char endTime[HWM_MAX_TIME_FORMATE_LEN];          /**< [en]End call time(is null before call end)
                                                              [cn]呼叫结束时间（通话结束前为空）*/
        bool isCallOut;                                  /**< [en]Is initiative call out
                                                              [cn]是否为主动呼出 */
        unsigned int callId;                             /**< [en]Call id
                                                              [cn]通话id */
    }HwmCallInfo;

    /**
    * [en]Call record information(after call end)
    * [cn]通话记录信息(通话结束后上报)
    */
    typedef struct tagHwmCallRecordInfo
    {
        HwmCallInfo callInfo;                            /**< [en]Call information
                                                              [cn]呼叫信息 */
        HwmCallEndReason reason;                         /**< [en]Call end reason
                                                              [cn]呼叫结束原因 */
    }HwmCallRecordInfo;

    /**
    * [en]Call coming information.
    * [cn]呼叫来电信息
    */
    typedef struct tagHwmCallIncomingInfo
    {
        HwmCallType callType;                            /**< [en]Indicates call type
                                                              [cn]呼叫类型 */
        char number[HWM_MAX_NUMBER_LEN];                 /**< [en]caller number
                                                              [cn]来电者号码 */
        char name[HWM_MAX_USER_NAME_LEN];                /**< [en]caller name
                                                              [cn]来电者姓名 */
        unsigned int callId;                             /**< [en]call ID
                                                              [cn]通话id */
    } HwmCallIncomingInfo;

    /**
    * [en]Incoming answer type
    * [cn]来电应答类型
    */
    typedef enum tagHWMIncomingAnswerType
    {
        HWM_INCOMING_ANSWER_NORMAL,                           /**< [en]incoming answer normal
                                                                   [cn]来电时应答采用原始体验弹窗选择 */
        HWM_INCOMING_ANSWER_DECLINE,                          /**< [en]incoming answer decline
                                                                   [cn]来电时拒接 */
        HWM_INCOMING_ANSWER_ANSWER,                           /**< [en]incoming answer answer
                                                                   [cn]来电时接听 */

        HWM_INCOMING_ANSWER_TYPE_BUTT

    } HWMInComingAnswerType;

    /**
    * [en]save path type
    * [cn]用户文件保存路径枚举
    */
    typedef enum tagHWMSavePathType
    {
        HWM_SAVE_PATH_LOCAL_RECORD,                           /**< [en]record save path
                                                                   [cn]本地录制文件保存路径 */

        HWM_SAVE_PATH_TYPE_BUTT

    } HWMSavePathType;

    /**
    * [en]user state
    * [cn]用户状态枚举 用于判断当前用户是否处于忙碌状态
    */
    typedef enum tagHwmUserState
    {
        HWM_STATE_IDLE,                                      /**< [en]idle state
                                                                  [cn]空闲状态 */
        HWM_STATE_IN_CONF,                                   /**< [en]in conf state
                                                                  [cn]会中状态 (包括会议来电、发起会议、会中)*/
        HWM_STATE_IN_CALL,                                   /**< [en]in call state
                                                                  [cn]呼叫中状态 (包括呼叫来电、发起呼叫、通话中)*/
        HWM_USER_STATE_BUTT
    } HwmUserState;

    /**
    * [en]share strategy type
    * [cn]屏幕共享策略类型
    */
    typedef enum tagHwmShareStrategyType
    {
        HWM_SHARE_STRATEGY_DEFINITION_FIRST,                 /**< [en]definition first
                                                                  [cn]清晰度优先 */
        HWM_SHARE_STRATEGY_FLUENCY_FIRST,                    /**< [en]fluency first
                                                                  [cn]流畅度优先 */
        HWM_SHARE_STRATEGY_DEFINITION_AND_FLUENCY,           /**< [en]definition and fluency
                                                                  [cn]清晰且流畅模式，注：有带宽压力，三方自行保证
                                                                  [doc:disable] */
        HWM_SHARE_STRATEGY_TYPE_BUTT
    } HwmShareStrategyType;
    // 屏幕ID枚举
    typedef enum tagHwmScreenType
    {
        SCREEN_ONE = 1,            /**< [en]The screen's ID is ONE.
                                        [cn]屏幕ID为1 */
        SCREEN_TWO,                /**< [en]The screen's ID is TWO.
                                        [cn]屏幕ID为2 */
        SCREEN_BUTT
    }HwmScreenType;

    // 窗口句柄的类型
    typedef enum tagHwmHwndType
    {
        VIDEO_WND_TYPE,			      /**< [en]The handle type of window is video.
                                           [cn]窗口句柄的类型为视频 */
        SCREEN_ID,                    /**< [en]The handle type of window is screen's ID.
                                           [cn]窗口句柄的类型为屏幕ID */
        SHARE_RENDER,			      /**< [en]The handle type of window is share render.
                                           [cn]窗口句柄的类型为共享渲染类型 */
        HWND_BUTT_TYPE
    } HwmHwndType;

    // 窗口句柄信息
    typedef struct tagHwndInfo
    {
        HWND renderHandle;	          /**< [en]The render window handle.when hwndType is SCREEN_ID，the renderHandle Indicate screen id.
                                           [cn]渲染视图的窗口句柄.当hwndType为SCREEN_ID，renderHandle代表屏幕的ID 其中值大于1*/
        HwmHwndType hwndType;		  /**< [en]The window handle type.
                                           [cn]窗口句柄的类型 */
        bool isBigView;               /**< [en]Large video window for the speaker
                                           [cn]是否演讲者大视频窗口 */
    } HwndInfo;

    // 窗口句柄列表信息
    typedef struct tagHwmHwndInfo
    {
        HwndInfo hwndInfoList[HWM_MAX_HWND_INFO_LIST_LEN];        /**< [en]Indicates video window handle list
                                                                       [cn]视频窗口句柄列表   */
        int hwndListLength;         	                          /**< [en]Indicates video window handle list's length
                                                                       [cn]窗口句柄列表的实际长度 */
    } HwmHwndListInfo;
    /**
    * [en]Device type.
    * [cn]设备类型
    */
    typedef enum tagHwmDeviceType
    {
        HWM_DEVICE_TYPE_MIC,                                    /**< [en]Indicates microphone device
                                                                     [cn]麦克风设备 */
        HWM_DEVICE_TYPE_SPEAKER,                                /**< [en]Indicates Speaker device
                                                                     [cn]扬声器设备 */
        HWM_DEVICE_TYPE_CAMERA,                                 /**< [en]Indicates Camera device
                                                                     [cn]视频设备 */
    } HwmDeviceType;

    /**
    * [en]16-bit precision PCM.
    * [cn]16位精度PCM
    */
    typedef enum tagAudioFrameType {
        AUDIO_FRAME_TYPE_PCM16
    } AudioFrameType;

    /**
    * [en]Report audio stream frame data.
    * [cn]上报音频码流帧数据
    */
    typedef struct tagAudioFrameData
    {
        AudioFrameType eFrameType;          /**< [en]Indicates frameType.
                                                 [cn]音频帧类型 */
        signed int iSamples;                /**< [en]Indicates samples.
                                                 [cn]每个声道的采样点数,iSamples=iSamplesPerSec * 10ms /1000 */
        signed int iSamplesPerSec;          /**< [en]Indicates samplesPerSec.
                                                 [cn] 采样率*/
        signed int iBytesPerSample;         /**< [en]Indicates bytesPerSample.
                                                 [cn]每个采样点的字节数,pcm数据一般16bit */
        signed int iChannels;               /**< [en]Indicates channels.
                                                 [cn]声道数 */
        char  *pBuffer;                     /**< [en]Indicates buffer.
                                                 [cn]数据缓冲区,长度=iSamples*iBytesPerSample*iChannels */
        signed int uiDataLen;               /**< [en]Indicates data length.
                                                 [cn]编码后或解码前使用该字段表示数据长度，加解密处理后需更新此字段值 */
        signed int uiBufferLen;             /**< [length for pBuffer]
                                                 [en]Indicates pBuffer length.[cn]缓冲区长度，编码后数据进行第三方加密，数据长度会变大，防止溢出 */
    } AudioFrameData;

    /**
    * [en]Self avatar info
    * [cn]个人头像信息
    */
    typedef struct tagHwmSelfAvatarInfo
    {
        char path[HWM_MAX_FILE_PATH_LEN];                   /**< [en] path
                                                                 [cn] 图片全路径
                                                                 [cs_allowNull:N] */
    }HwmSelfAvatarInfo;

    /**
    * [en]This struct is used to describe conference end info
    * [cn]会议结束信息
    */
    typedef struct tagHwmConfEndInfo
    {
        HwmConfEndReason reason;        /**< [en]ConfEndReason
                                             [cn]离会原因。 */
        hwmsdk::HwmErrCode originalReason; /**< [en]original ConfEndReason
                                                [cn]原始离会原因。 
                                                [doc:disable] */
        bool isP2PConf;                 /**< [en]is p2p conf
                                             [cn]是否立即会议。 */
        char confId[HWM_MAX_CONF_ID_LEN]; /**< [en]Conf id
                                               [cn]会议id。*/
    }HwmConfEndInfo;

    /**
    * [en]Entry of show voiceprint statement.
    * [cn]打开声纹降噪功能声明的入口
    */
    typedef enum tagHwmVoiceprintStatementEntry
    {
        VOICEPRINT_STATEMENT_ENTRY_CHECK_STATEMENT = 0,     /**< [en]Indicates check statement
                                                                 [cn]点击"功能声明"打开*/
        VOICEPRINT_STATEMENT_ENTRY_OPEN_NOISE_REDUCE,       /**< [en]Indicates open voiceprint noise reduce
                                                                 [cn]点击"声纹降噪"打开 */
    }HwmVoiceprintStatementEntry;

    /**
    * [en]Show voiceprint statement info
    * [cn]打开声纹降噪功能声明信息
    */
    typedef struct tagHwmShowVoiceprintStatementInfo
    {
        HwmVoiceprintStatementEntry entry;                  /**<  [en]entry of show statement
                                                                  [cn]打开功能声明入口 */
    } HwmShowVoiceprintStatementInfo;

    /**
    * [en] Voiceprint record reading text
    * [cn] 声纹录入朗读文本
    */
    typedef struct tagHwmVoiceprintRecordReadingText
    {
        char content[HWM_MAX_READING_TEXT_CONTENT_LEN];         /**< [en]Reading text content
                                                                     [cn]朗读文本内容 */
        char title[HWM_MAX_READING_TEXT_TITLE_LEN];             /**< [en]Reading text title
                                                                     [cn]朗读文本标题 */
        HwmLanguage language;                                   /**< [en]Reading text language
                                                                     [cn]朗读文本语言 */
    }HwmVoiceprintRecordReadingText;

    /**
    * [en] Voiceprint record window config
    * [cn] 声纹录入窗口配置
    */
    typedef struct tagHwmVoiceprintRecordWindowConfig
    {
        HwmVoiceprintRecordReadingText* readingTextList;                            /**< [en]Indicates reading text list
                                                                                         [cn]朗读文本列表   */
        unsigned int readingTextListLength;         	                            /**< [en]Indicates reading text list's length
                                                                                         [cn]朗读文本列表的实际长度
                                                                                         [length for readingTextList] */
    }HwmVoiceprintRecordWindowConfig;

    /**
    * [en]This struct is used to describe the status of low net work
    * [cn]弱网状态信息
    */
    typedef struct tagHwmLowNetWorkStatusInfo
    {
        unsigned int packetLoss;          /**< [en]Indicates loss rate.
                                             [cn]丢包率*/
        unsigned int delay;               /**< [en]Indicates delay.
                                             [cn]时延*/
        unsigned int jitter;              /**< [en]Indicates jitter.
                                             [cn]抖动*/
        HwmLowNetWorkStatus status;     /**< [en]This struct is used to describe the status of low net work
                                             [cn]网络状态 */
    }HwmLowNetWorkStatusInfo;

    /**
    * [en]This struct is used to describe the QoS weak network prompt information
    * [cn]qos弱网提示信息
    */
    typedef struct tagHwmPoorNetWorkQualityInfo
    {
        char nickName[HWM_MAX_USER_NAME_LEN];   /**< [en]Indicates nickName
                                                         [cn]与会者名称。*/
        char number[HWM_MAX_NUMBER_LEN];        /**< [en]Indicates number
                                                         [cn]号码。如果填分配给账号的sip号码（如+99111244216210249）则呼叫该账号的App；
                                                             如果填PSTN号码（如18700000000），则通过VoIP网关呼叫该号码，前提是该企业已开通PSTN呼叫权限。
                                                             与thirdUserId二选一，账号密码鉴权时使用。*/
        char thirdUserId[HWM_MAX_USER_ID_LEN];  /**< [en]The attendee's third account
                                                         [cn]第三方用户ID。与number二选一，App ID鉴权时使用。 */
        char accountId[MAX_ACCOUNT_ID_LEN];     /**< [en]Indicates account id
                                                         [cn]华为云会议账号 */
        char orgId[HWM_MAX_ORG_ID_LENGTH];      /**< [en]Indicates org id.
                                                         [cn]企业id */
        bool isLocal;                           /**< [en]Indicates is local.
                                                         [cn]是否本端*/
        HwmLowNetWorkStatusInfo audioStatus;        /**< [en]Indicates is network status.
                                                         [cn]音频网络状态*/
        HwmLowNetWorkStatusInfo videoStatus;        /**< [en]Indicates is network status.
                                                         [cn]视频网络状态*/
        HwmLowNetWorkStatusInfo shareStatus;        /**< [en]Indicates is network status.
                                                         [cn]共享网络状态*/
    }HwmPoorNetWorkQualityInfo;

    /**
    * [en]User save path info.
    * [cn]设置用户保存路径信息
    */
    typedef struct tagHwmUserSavePathInfo
    {
        HWMSavePathType pathType;                   /**< [en]save path type
                                                         [cn]保存路径类型
                                                         [cs_allowNull:N] */
        char path[HWM_MAX_FILE_PATH_LEN];       /**< [en]save path
                                                         [cn]保存路径，注：绝对路径，需要UTF8编码
                                                         [cs_allowNull:N] */
    }HwmUserSavePathInfo;

    /**
    * [en]Set log path info.
    * [cn]设置日志路径信息
    */
    typedef struct tagHwmLogPathInfo
    {
        char path[HWM_MAX_FILE_PATH_LEN];       /**< [en]save path
                                                         [cn]保存路径，注：绝对路径，需要UTF8编码
                                                         [cs_allowNull:N] */
    }HwmLogPathInfo;

    /**
    * [en]
    * [cn]界面区域信息
    */
    typedef struct tagHwmRectInfo
    {
        int left;                  /**< [en]
                                              [cn]左边距 */
        int top;                 /**< [en]
                                              [cn]顶部边距 */
        int right;             /**< [en]
                                              [cn]右部边距 */
        int bottom;             /**< [en]
                                              [cn]右部边距 */
    } HwmRectInfo;

    /**
    * [en]watch item param
    * [cn]选看入参
    */
    typedef struct tagHwmWatchItem
    {
        int userId;                  /**< [en]Indicates userId.[cn]用户标识
                                           [cs_allowNull:N] */
        HWND renderHandle;	            /**< [en]The render window handle.
                                            [cn]视频窗口附着的父窗口句柄.*/
        HwmWndType wndType;                 /**< [en]Indicates type of window.
                                            [cn]窗口类型 */
        HwmRectInfo padding;                      /**< [en]
                                            [cn]视频显示区域边距 */
    }HwmWatchItem;

    /**
    * [en]Watch list info.
    * [cn]选看列表信息
    */
    typedef struct tagHwmWatchListInfo
    {
        unsigned int watchListSize;                          /**< [en]length for watchList.
                                                                [cn]选看选看个数
                                                                [cs_allowNull:N][length for watchList] */
        HwmWatchItem* watchList;                           /**< [en]watch info
                                                                [cn]选看信息。
                                                                [cs_allowNull:N] */
    }HwmWatchListInfo;

    /**
    * [en]Stream type info
    * [cn]视频流类型信息
    */
    typedef struct tagHwmVideoStreamTypeInfo
    {
        unsigned int userId;                                      /**< [en]UserId.
                                                                     [cn]用户的唯一标识ID */
        HwmStreamType streamType;                               /**< [en]Stream type.
                                                                     [cn]流类型 */
    } HwmVideoStreamTypeInfo;

    /**
    * [en]Speaker info.
    * [cn]发言人信息
    */
    typedef struct tagHwmConfSpeaker
    {
        unsigned int userId;                                       /**< [en]User Id
                                                                      [cn]用户唯一标识 */
        char name[HWM_MAX_DISPLAY_NAME_LEN];                 /**< [en]Display name.
                                                                      [cn]与会者显示名称 */
    } HwmConfSpeaker;

    /**
    * [en]Speakers info.
    * [cn]发言人列表信息
    */
    typedef struct tagHwmSpeakerList
    {
        unsigned int speakerSize;                                        /**< [en]Speaker number.
                                                                            [cn]发言人个数
                                                                            [length for speakers] */
        HwmConfSpeaker* speakers;                                      /**< [en]Speakers.
                                                                            [cn]发言人列表 */
    } HwmSpeakerList;

    /**
    * [en]Annotation wnd info
    * [cn]标注窗口信息
    */
    typedef struct tagHwmAnnotationWndInfo
    {
        HWND renderHandle;                /**< [en]The render window handle
                                               [cn]标注窗口附着的父窗口句柄 */
    } HwmAnnotationWndInfo;

    /**
    * [en]Annotation state info
    * [cn]标注状态信息
    */
    typedef struct tagHwmAnnotationStateInfo
    {
        HwmState annotationState;                               /**< [en]Annotation state
                                                                     [cn]标注状态 */
    } HwmAnnotationStateInfo;

    /**
    * [en]Annotation save confg info
    * [cn]标注保存配置信息
    */
    typedef struct tagHwmAnnotationSaveConfigInfo
    {
        char path[HWM_MAX_FILE_PATH_LEN];       /**< [en]save path
                                                         [cn]保存路径，注：绝对路径，需要UTF8编码
                                                         [cs_allowNull:N] */
    } HwmAnnotationSaveConfigInfo;

    /**
    * [en]This struct is used to describe basic call member info
    * [cn]呼叫基本成员信息
    */
    typedef struct tagHwmCallMemberInfo
    {
        char number[HWM_MAX_NUMBER_LEN];                 /**< [en]Indicates number.
                                                              [cn]号码 */
        char nickName[HWM_MAX_NAME_LEN];                 /**< [en]Indicates name.
                                                              [cn]成员名称 */
        char userUuid[HWM_MAX_ACCOUNT_ID_LEN];           /**< [en]Indicates the uuid. 
                                                              [cn]与会者uuid */
        char thirdUserId[HWM_MAX_ACCOUNT_ID_LEN];        /**< [en]Indicates the third part account.
                                                              [cn]第三方账号 */
        char extendedField[HWM_MAX_OPEN_CUSTOM_PARA_LEN]; /**< [en]Indicates extended field.
                                                               [cn]扩展字段 */
        char orgId[HWM_MAX_ORG_ID_LENGTH];                /**< [en]Indicates org id.
                                                               [cn]企业id */
    }HwmCallMemberInfo;

    /**
     * [en]This struct is used to describe P2P conference record info
     * [cn]立即会议记录
     */
    typedef struct tagHwmP2PConfRecordInfo
    {
        HwmCallMemberInfo callerInfo;                        /**< [en]Indicates caller infomation.
                                                                  [cn]主叫方信息 */
        HwmCallMemberInfo calleeInfo;                        /**< [en]Indicates callee infomation.
                                                                  [cn]被叫方信息 */
        int startTime;                                       /**< [en]Indicates calling start time.
                                                                  [cn]（已废弃，推荐使用字段startTimeStamp）呼叫开始时间，精度秒(0时区) */
        int endTime;                                         /**< [en]Indicates calling end time.
                                                                  [cn]（已废弃，推荐使用字段endTimeStamp）呼叫结束时间，精度秒(0时区) */
        long long startTimeStamp;                            /**< [en]Indicates conference start time
                                                                  [cn]会议开始时间(时间戳，单位秒) */
        long long endTimeStamp;                              /**< [en]Indicates conference end time
                                                                  [cn]会议结束时间(时间戳，单位秒) */
        bool isCallOut;                                      /**< [en]Indicates is call out
                                                                  [cn]是否为主动呼出 */
        HwmMediaType mediaType;                              /**< [en]Indicates media type.
                                                                  [cn]媒体类型 */
        hwmsdk::HwmErrCode resultCode;                       /**< [en]Error code.
                                                                  [cn]错误码 */
        char resultMsg[HWM_MAX_REASON_LEN];                  /**< [en]Error describe.
                                                                  [cn]错误描述 */
        bool isCallEstablished;                              /**< [en]Indicates whether the call is established.
                                                                  [cn]呼叫是否建立 */
    }HwmP2PConfRecordInfo;


    /**
    * [en]Error message info.
    * [cn]错误提示
    */
    typedef struct tagHwmErrorMessageInfo
    {
        char errorMessage[HWM_MAX_ERROR_MESSAGE_LEN];       /**< [en]error message
                                                                 [cn]错误提示，注：UTF8编码 */
    }HwmErrorMessageInfo;

    /**
    * [en]Toast info.
    * [cn]提示信息
    */
    typedef struct tagHwmToastInfo
    {
        char content[HWM_MAX_TOAST_CONTENT_LEN]; /**< [en]Toast content.
                                                          [cn]提示内容 */
        int duration;                          /**< [en]Toast duration.
                                                          [cn]提示持续时间（单位：秒） */
    }HwmToastInfo;

    /**
    * [en]Main Window info.
    * [cn]主窗口信息
    */
    typedef struct tagHwmMainWindowInfo
    {
        int x;                                 /**< [en]Indicates window's left offset from screen
                                                          [cn]窗口相对于屏幕左侧的偏移量。 */
        int y;                                 /**< [en]Indicates window's top offset from screen
                                                          [cn]窗口相对于屏幕顶端的偏移量。 */
        int width;                             /**< [en]Indicates window's width
                                                          [cn]窗口的宽度。 */
        int height;                            /**< [en]Indicates Window's height
                                                          [cn]窗口的高度。 */
        HWND handle;                           /**< [en]Window handle
                                                          [cn]窗口句柄 */
    } HwmMainWindowInfo;

    /**
    * [en]This structure is used to describe share vmr info notify
    * [cn]共享vmr信息
    */
    typedef struct tagHwmShareVmrInfo
    {
        bool isEnableShareVmr;                          /**< [en]Is enable share vmr
                                                                 [cn]共享vmr是否可用 */
    }HwmShareVmrInfo;

    /**
    * [en]This structure is used to describe start projection param.
    * [cn]发起投屏参数体
    */
    typedef struct tagHwmStartProjectionParam
    {
        char pairCode[HWM_MAX_PAIR_CODE_LEN];       /**< [en]Indicates pair code.
                                                    [cn]配对码
                                                    [cs_allowNull:N] */
        char randomNumber[HWM_MAX_RANDOM_LEN];      /**< [en]Indicates random number.
                                                    [cn]随机数
                                                    [cs_allowNull:Y] */
        char verifyCode[HWM_MAX_VERIFY_CODE_LEN];   /**< [en]SMS verification code.
                                                    [cn]验证码
                                                    [cs_allowNull:Y] */
    }HwmStartProjectionParam;

    /**
    * [en]This structure is used to describe start projection result.
    * [cn]发起投屏结果
    */
    typedef struct tagHwmStartProjectionResult
    {
        char randomNumber[HWM_MAX_RANDOM_LEN];                 /**< [en]Indicates random number.
                                                               [cn]随机数*/
    }HwmStartProjectionResult;

    /**
    * [en]This struct is used to describe conf extend config.
    * [cn]会议扩展配置
    */
    typedef struct tagHwmConfExtendConfig
    {
        unsigned int maxBitrateValue;                                     /**< [en]Indicates max bitrate. 
                                                                               [cn]探高上限值 */
        bool enableDetectMaxBWE;                                          /**< [en]Indicates is enable detect max bitrate. 
                                                                               [cn]是否开启探高 */
    }HwmConfExtendConfig;

    /**
    * [en]This struct is used to describe conference base info.
    * [cn]会议基础信息
    */
    typedef struct tagHwmConfBaseInfo
    {
        char confId[HWM_MAX_CONF_ID_LEN];                           /**< [en]Indicates conference id.
                                                                         [cn]会议id,加入会议时用到。如果是VMR会议，则此ID是真实会议ID，不用来显示；如果不是VMR会议，则用来显示。*/
        char vmrConfId[HWM_MAX_CONF_ID_LEN];                        /**< [en]Indicates virtual conference id.
                                                                         [cn]虚拟会议室ID，vmr会议下有效 */
        char confSubject[HWM_MAX_SUBJECT_LEN];                      /**< [cs_sensitive:hide][en]Indicates conference subject.
                                                                         [cn]会议主题 */
        long long startTime;                                        /**< [en]Indicates the conference start time.
                                                                         [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间-时间戳，精度秒(0时区) */
        long long endTime;                                          /**< [en]Indicates the conference end time.
                                                                         [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间-时间戳，精度秒(0时区) */
        long long startTimeStamp;                                   /**< [en]Indicates conference start time
                                                                         [cn]会议开始时间(时间戳，单位秒) */
        long long endTimeStamp;                                     /**< [en]Indicates conference end time
                                                                         [cn]会议结束时间(时间戳，单位秒) */
        long long serverCurrentTime;                                /**< [en]Indicates the conference end time.
                                                                         [cn]当前服务器时间 */
        char  timeZone[HWM_MAX_TIME_ZONE_LEN];                      /**< [en]Indicates time zone, optional, standard time zone for example "Asia/Shanghai" in PBX internal conference; Beijing is "56" in Mediax conference,refer to CONFCTRL_E_TIMEZONE.
                                                                         [cn]时区 */
        char hostPwd[HWM_MAX_CONF_PASSWORD_LEN];                    /**< [en]Indicates chairman password.
                                                                         [cn]会议主席密码 */
        char guestPwd[HWM_MAX_CONF_PASSWORD_LEN];                   /**< [en]Indicates guest password.
                                                                         [cn]来宾密码 */
        HwmMediaType mediaType;                                     /**< [en]Indicates the conferencn media type.
                                                                         [cn]会议媒体类型 */
        char scheduserUuid[HWM_MAX_ACCOUNT_ID_LEN];                 /**< [en]Indicates schedule uuid.
                                                                         [cn]预订者uuid */
        char scheduserName[HWM_MAX_DISPLAY_NAME_LEN];               /**< [en]Indicates schedule user name.
                                                                         [cn]预订者姓名 */
        char hostJoinUri[HWM_MAX_URL_LEN];                          /**< [en]Indicates the uri for chairman to join conference .
                                                                         [cn]主持人入会链接 */
        char guestJoinUri[HWM_MAX_URL_LEN];                         /**< [en]the uri for guest to join conference.
                                                                         [cn]来宾加入会议的链接 */
        char accessNumber[HWM_MAX_CONF_ACCESS_LEN];                 /**< [en]Indicates conference access number.
                                                                         [cn]会议接入码 */
        HwmConfRole selfConfRole;                                   /**< [en]Indicates the role of participant.
                                                                         [cn]本人在会议中的角色 */
        bool isWebinar;                                             /**< [en]Indicates whether the conference is web conferencre.
                                                                         [cn]是否是网络研讨会 */
        bool isCreator;                                             /**< [en]Indicates whether the user is the creator of the conference
                                                                         [cn]是否是会议预订者 */
        char audienceJoinUri[HWM_MAX_URL_LEN];                      /**< [en]Indicates the uri for audience to join conference.
                                                                         [cn]观众加入会议的链接 */
        char audiencePwd[HWM_MAX_CONF_PASSWORD_LEN];                /**< [en]Indicates the password of audience.
                                                                         [cn]观众密码 */
        HwmConfState confStateType;                                 /**< [en]Indicates conference state.
                                                                         [cn]会议状态 */
        ConferenceType conferenceType;                              /**< [en]Indicates conference type.
                                                                         [cn]会议类型 */
        HwmCycleConfParam cycleParam;                               /**< [en]Indicates cycle conference param.
                                                                         [cn]周期会议的参数 */
        unsigned int subConfSize;                                   /**< [en]Indicates cycle sub conference size.
                                                                         [cn]周期子会议数量 */
        HwmSubCycleConfParam *subConfParam;                         /**< [en]Indicates cycle sub conference param.
                                                                         [cn]周期子会议参数 */
        char confUuid[HWM_MAX_ACCOUNT_ID_LEN];                      /**< [en]Indicates conference uuid.
                                                                         [cn]会议uuid，投票服务使用。 */
        bool isExperienceConf;                                      /**< [en]Indicates is experience conf.
                                                                         [cn] 是否为周期体验会议 */
        char appAttribute[HWM_MAX_APP_ATTRIBUTE_LEN];               /**< [en]Indicates corp id.
                                                                         [cn]应用属性，UI根据不同应用拼接 */
        char openCustomPara[HWM_MAX_OPEN_CUSTOM_PARA_LEN];          /**< [en]Indicates User-defined data on the device side attribute.
                                                                         [cn]可选，端侧自定义数据，服务器不感知业务 */
        char liveRoomAddress[HWM_MAX_URL_LEN];                      /**< [en]Indicates live room address
                                                                         [cn]直播地址 */
        char breakoutID[HWM_MAX_CONF_ID_LEN];                       /**< [en]Indicates breakoutID.
                                                                         [cn]讨论分组ID，启动分组后，动态分组成员信息才有 */
        unsigned int breakoutConfLimit;                             /**< [en]Indicates breakoutConfLimit.
                                                                         [cn]分组会议子会场数目上限 */
        char recordLiveType[HWM_MAX_RECORD_LIVE_TYPE_LEN];          /**< [en]Indicates record live type.
                                                                         [cn]录制类型（mmr/rtc/rse）*/
        bool isHighResolution;                                      /**< [en]high resolution
                                                                         [cn]是否为超高清(1080p)会议 */
        bool isP2PConf;                                             /**< [en]Indicates p2p conf.
                                                                         [cn]是否立即会议 */
        bool isUseConfctrlTempToken;                                /**< [en]Indicates is use confctlr temporary token.
                                                                         [cn]是否使用会控临时token */
        unsigned int concurrentParticipants;                        /**< [en]concurrent participants.
                                                                         [cn]会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数 */
        bool isSupportE2E;                                          /**< [en]Indicates is support E2E encrypt.
                                                                         [cn]是否支持端到端加密 */
        bool isChipEncryptCall;                                     /**< [en]Indicates is chip encrypt call.
                                                                         [cn]是否保密通话 */
        HwmConfExtendConfig confExtendConfig;                       /**< [en]conf extend config.
                                                                         [cn]会议扩展配置 */
        HwmConfCreateMode immediatelyConfStartMode;                 /**< [en]Indicates immediatelyConfStartMode.
                                                                         [cn]即时创会类型 */
        HwmShareState shareState;                                   /**< [en]Indicates shareState.
                                                                         [cn]共享状态 */
        bool enableCollaborate;                                     /**< [en]Indicates enableCollaborate.
                                                                         [cn]是否使用辅流 */
        bool supportSummary;                                        /**< [en]Indicates supportSummary.
                                                                         [cn]支持会议纪要 */
        HwmSummaryState defaultSummaryState;                        /**< [en]Indicates defaultSummaryState.
                                                                         [cn]开启会议纪要 */
        bool supportMultiShare;                                     /**< [en]Indicates support multi-share.
                                                                         [cn]是否支持多人共享 */
        bool corpEnableWatermark;                                   /**< [en]Indicates is corp support water mark.
                                                                         [cn]企业是否支持会议水印 */
        bool corpEnableForbidScreenShots;                           /**< [en]Indicates is corp support forbidden screen shot.
                                                                         [cn]企业是否支持防截屏 */
        bool autoPublishSummary;                                    /**< [en]Indicates Whether auto publish summary. 
                                                                         [cn]是否自动发布纪要（免人工审核）*/
    }HwmConfBaseInfo;

    /**
    * [en]This structure is used to describe conf info.
    * [cn]会中信息
    */
    typedef struct tagHwmMeetingInfo
    {
        HwmConfBaseInfo baseInfo;                                  /**< [en]Indicates base information of conference.
                                                                        [cn]会议基本信息 */
        char imGroupId[HWM_MAX_GROUP_URI_LEN];                     /**< [en]Indicates im group id.
                                                                        [cn]im群组id */
        char orgId[HWM_MAX_ORG_ID_LENGTH];                         /**< [en]Indicates org id.
                                                                        [cn]企业id */
        HwmConfRecordMode recordMode;                              /**< [en]Indicates conference recording mode.
                                                                        [cn]会议媒体录制模式  */
        bool isSupport90P;                                         /**< [en]Indicates is support 90P.
                                                                        [cn]是否支持90P */
        bool supportBreakoutConf;                                  /**< [en]Indicates is support breakout conf.
                                                                        [cn]是否支持分组会议 */
        bool isBreakoutSubConf;                                    /**< [en]Indicates is breakout sub conf.
                                                                        [cn]是否是分组会议*/
        bool isCtd;                                                /**< [en]Indicates ctd.
                                                                        [cn]是否是ctd */
        HwmConfIMType imType;                                      /**< [en]Indicates im type.
                                                                        [cn]会中聊天类型，默认RTM  */
        char cimGroupId[HWM_MAX_CIM_GROUP_ID_LEN];                 /**< [en]Indicates conf im group id.
                                                                        [cn]CIM群组id */
        bool isSupportCloudVirtualBackground;                      /**< [en]Indicates support cloud virtual background.
                                                                        [cn]是否支持云虚拟背景 */
        bool supportGuestInviteAttendee;                           /**< [en]Indicates support guest invite attendee.
                                                                        [cn]是否支持来宾外邀 */
    }HwmMeetingInfo;

    /**
    * [en]attendee list info.
    * [cn]与会者列表信息
    */
    typedef struct tagHwmAttendeeListInfo
    {
        unsigned int numOfAttendee;                             /**< [en]length for attendees.
                                                                     [cn]入会者列表的长度
                                                                     [length for attendees] */
        HwmAttendeeInfo* attendees;                             /**< [en]Attendees info
                                                                     [cn]与会者基础信息 */
    }HwmAttendeeListInfo;

    /**
    * [en]Proxy info.
    * [cn]代理信息
    */
    typedef struct tagHwmCAVerifyInfo
    {
        HwmVerifyMode verifyMode;                    /**< [en]Indicates the verify mode
                                                          [cn]认证模式
                                                          [cs_allowNull:N] */
        char certPath[HWM_MAX_FILE_PATH_LEN];    /**< [en]Indicates the CA certificate path
                                                          [cn]证书存储路径
                                                          [cs_allowNull:Y] */
    }HwmCAVerifyInfo;

    /**
    * [en]This structure is used to describe add attendee result.
    * [cn]邀请与会者结果信息
    */
    typedef struct tagHwmAddAttendeeResult
    {
        char number[HWM_MAX_NUMBER_LEN];                 /**< [en]Indicates number.
                                                              [cn]号码 */
        char thirdUserId[HWM_MAX_USER_ID_LEN];           /**< [en]Indicates the third part account.
                                                              [cn]第三方账号 */
        hwmsdk::HwmErrCode resultCode;                   /**< [en]Error code.
                                                              [cn]错误码 */
        char extendedField[HWM_MAX_OPEN_CUSTOM_PARA_LEN]; /**< [en]Indicates extended field.
                                                               [cn]扩展字段 */
        char orgId[HWM_MAX_ORG_ID_LENGTH];                /**< [en]Indicates org id.
                                                               [cn]企业id */
    } HwmAddAttendeeResult;

    /**
    * [en]This structure is used to describe add attendee result list.
    * [cn]邀请与会者结果列表
    */
    typedef struct tagHwmAddAttendeeResultList
    {
        unsigned int addAttendeeResultSize;                    /**< [en]add attendee result size.
                                                                  [cn]添加与会者结果长度
                                                                  [length for addAttendeeResults] */
        HwmAddAttendeeResult* addAttendeeResults;            /**< [en]add attendee result list.
                                                                  [cn]添加与会者结果列表 */
    } HwmAddAttendeeResultList;

    /**
    * [en]This structure is used to describe custom text scene.
    * [cn]自定义文案场景
    */
    typedef enum tagHwmUICustomTextScene
    {
        CLOUD_RECORD_FINISHED_ALERT_SCENE,          /**< [en]Cloud Record Finished Alert
                                                         [cn]会中主动结束云录制场景 */
        CLOUD_RECORD_FINISHED_ALERT_IM_SCENE,       /**< [en]Cloud Record Finished Alert In Meeting(only for mac)
                                                         [cn]以离会方式结束云录制场景(仅对mac平台生效)
                                                         [win:disable]*/
        CLOUD_RECORD_MENU_TITLE_TEXT_SCENE,         /**< [en]Cloud recording title in the recording pop-up menu
                                                         [cn]录制弹框菜单中的云录制标题
                                                         [mac:disable]*/
        CLOUD_RECORD_MENU_DES_TEXT_SCENE,           /**< [en]Cloud recording description in the recording pop-up menu
                                                         [cn]录制弹框菜单中的云录制描述
                                                         [mac:disable]*/
        MAIN_WINDOW_CLOUD_RECORD_DES_TEXT_SCENE,    /**< [en]Cloud recording description in the main window
                                                         [cn]主窗口中的云录制描述
                                                         [mac:disable]*/
    } HwmUICustomTextScene;

    /**
    * [en]This structure is used to describe custom text info.
    * [cn]自定义文案信息
    */
    typedef struct tagHwmUICustomTextInfo
    {
        HwmLanguage languageType;                               /**< [en]Language type
                                                                     [cn]语言类型 */
        char languageCode[HWM_MAX_LOCATION_LEN];                /**< [en]Customized language location-name.
                                                                     [cn]自定义语言区域名
                                                                     [cs_allowNull:Y] */
        char customText[HWM_MAX_CUSTOM_CONTENT_LEN];            /**< [en]User custom text
                                                                     [cn]用户自定义文案 */
    } HwmUICustomTextInfo;

    /**
    * [en]This structure is used to describe custom scene and text info.
    * [cn]自定义场景文案信息
    */
    typedef struct tagHwmCustomSceneTextInfo
    {
        HwmUICustomTextScene scene;                             /**< [en]Custom text scene
                                                                     [cn]自定义文案场景 */
        unsigned int sceneTextListSize;                         /**< [en]Custom text size
                                                                     [cn]自定义文案列表长度 
                                                                     [length for sceneTextList] */
        HwmUICustomTextInfo* sceneTextList;                     /**< [en]Custom text list
                                                                     [cn]自定义文案列表 */
    } HwmCustomSceneTextInfo;

    /**
     * [en]This structure is used to describe custom scene and text info list.
     * [cn]自定义场景文案信息列表
    */
    typedef struct tagHwmCustomSceneTextInfoList
    {
        unsigned int customSceneTextInfoListSize;               /**< [en]Scene and custom ui text size
                                                                     [cn]自定义场景文案信息列表长度 
                                                                     [length for customSceneTextInfoList] */
        HwmCustomSceneTextInfo* customSceneTextInfoList;        /**< [en]Scene and custom ui text list
                                                                     [cn]自定义场景文案信息列表 */
    } HwmCustomSceneTextInfoList;

    /**
    * [en]This structure is used to describe auto hide tool bar param.
    * [cn]自动隐藏会控栏参数体
    */
    typedef struct tagHwmAutoHideToolBarParam
    {
        bool isAutoHide;                       /**< [en]Is auto hide
                                                        [cn]是否自动隐藏
                                                        [cs_allowNull:N] */
    }HwmAutoHideToolBarParam;

    /**
    * [en]This structure is used to describe custom scene and image info.
    * [cn]自定义场景图标信息
    */
    typedef struct tagHwmCustomSceneImageInfo
    {
        HwmUICustomImageScene scene;                            /**< [en]Custom image scene
                                                                     [cn]自定义图标场景 */
        char imagePath[HWM_MAX_FILE_PATH_LEN];              /**< [en]Custom image path
                                                                     [cn]自定义图标路径 */
        unsigned int width;                                       /**< [en]Custom image path
                                                                     [cn]自定义图标宽度 */
        unsigned int height;                                      /**< [en]Custom image path
                                                                     [cn]自定义图标高度 */
    } HwmCustomSceneImageInfo;

    /**
    * [en]This structure is used to describe custom scene and image info list.
    * [cn]自定义场景图标信息列表
    */
    typedef struct tagHwmCustomSceneImageInfoList
    {
        unsigned int customSceneImageInfoListSize;                /**< [en]Scene and custom ui image length
                                                                     [cn]自定义场景图标信息列表长度
                                                                     [length for customSceneImageInfoList] */
        HwmCustomSceneImageInfo* customSceneImageInfoList;      /**< [en]Scene and custom ui image list
                                                                     [cn]自定义场景图标信息列表 */
    } HwmCustomSceneImageInfoList;

    /**
    * [en]Incoming answer type
    * [cn]来电应答类型
    */
    typedef enum tagHwmInComingAnswerType
    {
        INCOMING_ANSWER_NORMAL,                           /**< [en]incoming answer normal
                                                          [cn]来电时应答采用原始体验弹窗选择 */
        INCOMING_ANSWER_DECLINE,                          /**< [en]incoming answer decline
                                                          [cn]来电时拒接 */
        INCOMING_ANSWER_ANSWER,                           /**< [en]incoming answer answer
                                                          [cn]来电时接听 */
        INCOMING_ANSWER_CUSTOM,                           /**< [en]incoming answer custom
                                                          [cn]来电时自定义弹框 */

        INCOMING_ANSWER_TYPE_BUTT

    } HwmInComingAnswerType;

    /**
    * [en]Incoming answer type info
    * [cn]来电应答类型信息
    */
    typedef struct tagHwmInComingAnswerTypeInfo
    {
        HwmInComingAnswerType type;                           /**< [en] incoming answer type
                                                              [cn] 来电应答类型 */
    } HwmInComingAnswerTypeInfo;

    /**
    * [en]accept conf param
    * [cn]接受会议邀请参数
    */
    typedef struct tagHwmAcceptConfParam
    {
        bool isAudioAccept;             /**< [en]is audio accept
                                             [cn]是否语音接听（仅立即视频会议时有效）
                                             [cs_allowNull:Y]*/
    } HwmAcceptConfParam;

    /**
    * [en]This struct is used to describe local record state info.
    * [cn]本地录制状态信息
    */
    typedef struct tagHwmLocalRecordStateInfo
    {
        HwmLocalRecordStatus status;                        /**< [en]Local record status
                                                                 [cn]本地录制状态 */
        char localRecordPath[HWM_MAX_FILE_PATH_LEN];        /**< [en]Local record file path
                                                                 [cn]本地录制文件路径 */
        long long startTime;                                /**< [en]Start time
                                                                 [cn]录制开始时间(时间戳，单位秒) */
    } HwmLocalRecordStateInfo;

    /**
    * [en]participant item info.
    * [cn]与会者列表子项信息
    */
    typedef struct tagHwmParticipantItemInfo
    {
        char number[HWM_MAX_NUMBER_LEN];                     /**< [en]Number
                                                                  [cn]号码 */
        char nickName[HWM_MAX_DISPLAY_NAME_LEN];             /**< [en]Nickname
                                                                  [cn]与会者昵称 */
        char thirdUserId[HWM_MAX_USER_ID_LEN];               /**< [en]The attendee's third account
                                                                  [cn]与会者三方账号，appId登录时使用 */
        char accountId[MAX_ACCOUNT_ID_LEN];                  /**< [en]Indicates account id
                                                                  [cn]华为云会议账号 */
        char extendedField[HWM_MAX_EXTENDED_FIELD_LEN];      /**< [en]Indicates extended field.
                                                                  [cn]扩展字段
                                                                  [doc:disable] */
        char orgId[HWM_MAX_ORG_ID_LENGTH];                   /**< [en]Indicates org id.
                                                                  [cn]企业id */
    } HwmParticipantItemInfo;

    /**
    * [en].
    * [cn]域名保底ip信息
    */
    typedef struct tagHwmGuaranteedIpAddress
    {
        char domain[HWM_MAX_URL_LEN];                                /**< [en]Domain
                                                                          [cn]域名 */
        char guaranteedIps[HWM_MAX_GURARTEENED_IP_ADDRESS_LEN];      /**< [en]Guaranteed IP address list. Multiple IP addresses are separated by semicolons (;). A maximum of four IP addresses are supported.
                                                                          [cn]保底ip列表，多个地址中间用分号隔开，最多支持4个地址 */
    }HwmGuaranteedIpAddress;

    /**
    * [en].
    * [cn]域名保底ip信息
    */
    typedef struct tagHwmGuaranteedIpAddressesParam
    {
        unsigned int addressListSize;                        /**< [en]Guaranteed IP address list length
                                                                [cn]保底ip信息list长度
                                                                [cs_allowNull:N][length for addressList] */
        HwmGuaranteedIpAddress* addressList;               /**< [en]Guaranteed IP address list
                                                                [cn]保底ip信息列表
                                                                [cs_allowNull:N] */
    }HwmGuaranteedIpAddressesParam;

    /**
    * [en]Self share state info
    * [cn]自己的开启共享状态信息
    */
    typedef struct tagHwmSelfShareStateInfo
    {
        HwmState state;                             /**< [en]The share state
                                                         [cn]开启共享状态。 */
    }HwmSelfShareStateInfo;

    /**
    * [en]This enumeration is used to describe login state info.
    * [cn]登录状态信息
    */
    typedef struct tagHwmLoginStateInfo
    {
        HwmLoginState loginState;                          /**< [en]Indicates the login state
                                                                [cn]登录模式 */
    }HwmLoginStateInfo;

    /**
    * [en]Avatar style
    * [cn]头像风格
    */
    typedef struct tagHwmAvatarStyle
    {
        char backgroundColor[HWM_MAX_COLOR_LEN];                  /**< [en]background color
                                                                       [cn]背景色
                                                                       [cs_allowNull:N] */
        char textColor[HWM_MAX_COLOR_LEN];                        /**< [en]text color
                                                                       [cn]文字颜色
                                                                       [cs_allowNull:N] */
        char phoneIconPath[HWM_MAX_FILE_PATH_LEN];                /**< [en]phone icon path
                                                                       [cn]手机图标
                                                                       [cs_allowNull:N] */
        char boardIconPath[HWM_MAX_FILE_PATH_LEN];                /**< [en]board icon path
                                                                       [cn]大屏图标
                                                                       [cs_allowNull:N] */
        HwmNameShowType nameShowType;                             /**< [en]Name show type
                                                                       [cn]姓名显示风格 */
        HwmAvatarShape avatarShape;                               /**< [en]Avatar shape
                                                                       [cn]头像形状 */
    }HwmAvatarStyle;

    /**
    * [en]Inner Http Proxy info.
    * [cn]内部Http代理信息
    */
    typedef struct tagHwmInnerHttpProxyInfo
    {
        char server[HWM_MAX_URL_LEN];                    /**< [en]The server address
                                                                  [cn]代理地址 */
        unsigned short port;                                     /**< [en]The server port
                                                                  [cn]代理端口 */
        char account[HWM_MAX_USERNAME_LEN];              /**< [en]The account
                                                                  [cn]代理账号 */
        char password[HWM_MAX_PASSWORD_LEN];             /**< [en]The password
                                                                  [cn]代理密码 */
    }HwmInnerHttpProxyInfo;

    /**
    * [en]This enumeration is used to describe login token info.
    * [cn]登录token信息
    */
    typedef struct tagHwmLoginTokenInfo
    {
        char loginToken[HWM_MAX_TOKEN_LEN];            /**< [en]Indicates the login token
                                                                [cn]登录token */
    }HwmLoginTokenInfo;
    /**
    * [en]Meeting Custom Info
    * [cn]会议自定义信息
    */
    typedef struct tagHwmMeetingCustomInfo
    {
        char customInfo[HWM_MAX_OPEN_CUSTOM_PARA_LEN];      /**< [en]Indicates the custom info
                                                                 [cn]自定义信息 */
    }HwmMeetingCustomInfo;

    /**
    * [en]Local record status info
    * [cn]本地录制状态信息
    */
    typedef struct tagHwmLocalRecordStatusInfo
    {
        HwmLocalRecordStatus state;                 /**< [en]The local record status
                                                         [cn]本地录制状态。 */
    }HwmLocalRecordStatusInfo;

    /**
    * [en]Local record permission info
    * [cn]本地录制权限信息
    */
    typedef struct tagHwmLocalRecordPermissionInfo
    {
        bool hasPermission;                    /**< [en]The local record permission
                                                        [cn]是否有本地录制权限。 */
    }HwmLocalRecordPermissionInfo;

    /**
    * [en]Setting vrbk default image mode
    * [cn]设置自定义虚拟背景默认图模式
    */
    typedef enum tagHwmSettingVrbkDefaultImageMode
    {
        HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_REPLACE_ALL,    /**< [en]Replace all
                                                                 [cn]全部替换, 覆盖内置的默认图片 */
        HWM_SETTING_VRBK_DEFAULT_IMAGE_MODE_APPEND,         /**< [en]Append
                                                                 [cn]基于内置的默认图片追加 */
    }HwmSettingVrbkDefaultImageMode;

    /**
    * [en]Virtual background image info
    * [cn]虚拟背景图信息
    */
    typedef struct tagHwmVirtualBackgroundImageInfo
    {
        char imagePath[HWM_MAX_FILE_PATH_LEN];   /**< [en]Image path
                                                          [cn]虚拟背景图片路径 */
    }HwmVirtualBackgroundImageInfo;

    /**
    * [en]This struct is used to describe Virtual background info.
    * [cn]虚拟背景信息
    */
    typedef struct tagHwmVirtualBackgroundInfo
    {
        HwmSettingVrbkDefaultImageMode mode;        /**< [en]Default image mode
                                                         [cn]设置自定义虚拟背景默认图模式 */
        HwmVirtualBackgroundImageInfo* imageList;   /**< [en]Image list
                                                         [cn]虚拟背景图列表 */
        unsigned int imageLength;                     /**< [en]Num of images
                                                         [cn]虚拟背景图个数
                                                         [length for imageList] */
    }HwmVirtualBackgroundInfo;


    /**
    * [en]This struct is used to describe the subtitle translation language type info.
    * [cn]字幕翻译语言类型信息
    */
    typedef struct tagHwmTargetLanguageTypeInfo
    {
        HwmTargetLanguageType targetLanguageType;     /**< [en]target language type.
                                                           [cn]字幕翻译语言类型 */
    } HwmTargetLanguageTypeInfo;

    /**
    * [en]This struct is used to describe the subtitle translation language type list.
    * [cn]字幕翻译语言类型列表
    */
    typedef struct tagHwmTargetLanguageTypeList
    {
        unsigned int targetLanguageTypeSize;                 /**< [en]target language type size.
                                                                  [cn]字幕翻译语言类型长度
                                                                  [cs_allowNull:N][length for targetLanguageTypes] */
        HwmTargetLanguageTypeInfo* targetLanguageTypes;      /**< [en]target language types.
                                                                  [cn]字幕翻译语言类型列表 
                                                                  [cs_allowNull:N] */
    } HwmTargetLanguageTypeList;

    /**
    * [en]This struct is used to describe the real time subtitle info.
    * [cn]实时字幕信息
    */
    typedef struct tagHwmRealTimeSubtitleInfo
    {
        unsigned int userId;                            /**< [en]Indicates user id.
                                                                 [cn]内部用户id */
        char   originalMsg[HWM_MAX_SUBTITLE_LEN];       /**< [en]Indicates Subtitle.
                                                                 [cn]字幕原文内容 */
        char   translatedMsg[HWM_MAX_SUBTITLE_LEN];     /**< [en]Indicates Subtitle.
                                                                 [cn]字幕翻译内容 */
        bool   isFinal;                                 /**< [en]Indicates is final.
                                                                 [cn]是否完整语句 */
        char   name[HWM_MAX_NAME_LEN];                  /**< [en]Indicates user name.
                                                                 [cn]用户名称 */
        char   aliasCN[HWM_MAX_NAME_LEN];               /**< [en]Indicates user aliasCN.
                                                                 [cn]用户中文别名 */
        char   aliasEN[HWM_MAX_NAME_LEN];               /**< [en]Indicates user aliasEN.
                                                                 [cn]用户英文别名 */
        bool   isExistVoicePrint;                       /**< [en]Indicates is exist voice print.
                                                                 [cn]是否携带声纹识别信息 */
        bool   isRecognize;                             /**< [en]Indicates isRecognize.
                                                                 [cn]是否匹配到声纹 */
        char   speakerCN[HWM_MAX_NAME_LEN];             /**< [en]Indicates speakerCN.
                                                                 [cn]发言人中文别名 */
        char   speakerEN[HWM_MAX_NAME_LEN];             /**< [en]Indicates speakerCN.
                                                                 [cn]发言人英文别名 */
        char   userCN[HWM_MAX_NAME_LEN];                /**< [en]Indicates userCN.
                                                                 [cn]声纹所属中文名 */
        char   userEN[HWM_MAX_NAME_LEN];                /**< [en]Indicates userEN.
                                                                 [cn]声纹所属英文名 */
        char   tag[HWM_MAX_NAME_LEN];                   /**< [en]Indicates tag.
                                                                 [cn]用户标识 */
        HwmTargetLanguageType translateLanguage;            /**< [en]Indicates translate language.
                                                                 [cn]字幕翻译语言类型 */
    } HwmRealTimeSubtitleInfo;

    /**
    * [en]This struct is used to describe subtitle record info.
    * [cn]字幕记录信息
    */
    typedef struct tagHwmSubtitleRecordInfo
    {
        HwmRealTimeSubtitleInfo realTimeSubtitleInfo;     /**< [en]Indicates real time subtitle.
                                                               [cn]实时字幕信息 */
        char   msgId[HWM_MAX_MSG_ID_LEN];             /**< [en]Indicates subtitle message id.
                                                               [cn]消息id,可以用来匹配字幕和翻译 */
        long long   timeStamp;                            /**< [en]Indicates subtitle time stamp.
                                                               [cn]字幕时间戳,UI可以用来显示字幕时间 */
    } HwmSubtitleRecordInfo;

    /**
    * [en]This struct is used to describe interrupt info.
    * [cn]中断信息
    */
    typedef struct tagHwmInterruptInfo
    {
        HwmInterruptType type;                            /**< [en]Indicates interrupt type.
                                                               [cn]中断类型 */
    } HwmInterruptInfo;

    /**
    * [en]This struct is used to describe create conference result.
    * [cn]创建会议结果
    */
    typedef struct tagHwmCreateConfResult
    {
        char confId[HWM_MAX_CONF_ID_LEN];                         /**< [en]Indicates conference id.
                                                                           [cn]会议id */
        char vmrConfId[HWM_MAX_CONF_ID_LEN];                      /**< [en]Indicates VMR conference id(only for mac)
                                                                           [cn]VMR会议id(仅对mac平台生效)
                                                                           [win:todo] */
        char hostPwd[HWM_MAX_CONF_PASSWORD_LEN];                  /**< [en]Indicates host pwd.
                                                                           [cn]主持人密码
                                                                           [cs_sensitive:hide] */
        char guestPwd[HWM_MAX_CONF_PASSWORD_LEN];                 /**< [en]Indicates guest pwd.
                                                                           [cn]来宾密码
                                                                           [cs_sensitive:hide] */
        HwmMediaType mediaType;                                       /**< [en]Media type(only for mac)
                                                                           [cn]会议媒体类型(仅对mac平台生效)
                                                                           [win:todo] */
        char guestJoinUri[HWM_MAX_URL_LEN];                       /**< [en]Indicates guest join url.
                                                                           [cn]来宾链接 */
        HwmConfRole selfConfRole;							          /**< [en]Indicates self role.
                                                                           [cn]本人在会议中的角色 */
        char subject[HWM_MAX_SUBJECT_LEN];                        /**< [en]Indicates conf subject.
                                                                           [cn]会议主题
                                                                           [cs_sensitive:subject]*/
        long long startTime;                                          /**< [en]Indicates conference start time.
                                                                           [cn]（已废弃，推荐使用字段startTimeStamp）会议开始时间，精度秒(0时区) */
        long long endTime;                                            /**< [en]Indicates conference end time.
                                                                           [cn]（已废弃，推荐使用字段endTimeStamp）会议结束时间 */
        long long startTimeStamp;                                     /**< [en]Indicates conference start time
                                                                           [cn]会议开始时间(时间戳，单位秒) */
        long long endTimeStamp;                                       /**< [en]Indicates conference end time
                                                                           [cn]会议结束时间(时间戳，单位秒) */
        char schedulerName[HWM_MAX_DISPLAY_NAME_LEN];             /**< [en]Indicates conf scheduler name.
                                                                           [cn]预约者名字
                                                                           [cs_sensitive:name] */
        char customInfo[HWM_MAX_CUSTOM_INFO_LEN];                 /**< [en]Indicates User-defined extended information
                                                                           [cn]自定义扩展信息 */
    }HwmCreateConfResult;

/* auto generate code insert 1, forbit delete */
}
#endif /* _HWM_AGENT_NOTIFY_DEF_H_ */
