﻿// demoAddAttendeeDlg2.cpp: 实现文件
//

#include "stdafx.h"
#include "demo.h"
#include "demoAddAttendeeDlg2.h"
#include "demoTools.h"


// demoAddAttendeeDlg2 对话框

IMPLEMENT_DYNAMIC(demoAddAttendeeDlg2, CDialogEx)

demoAddAttendeeDlg2::demoAddAttendeeDlg2(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_ADD_CONF_ATTENDEE_DIALOG, pParent)
    , attendeeInfo{0}
{
}

demoAddAttendeeDlg2::~demoAddAttendeeDlg2()
{
}

void demoAddAttendeeDlg2::OnOK()
{
    CString input;
    m_editName.GetWindowText(input);
    if(input.IsEmpty())
    {
        AfxMessageBox(_T("name empty!"));
        return;
    }

    CString userId;
    m_editNumber.GetWindowText(input);
    m_editThirdUserId.GetWindowText(userId);   
    if(input.IsEmpty() && userId.IsEmpty())
    {
        AfxMessageBox(_T("number or third part userid empty!"));
        return;
    }

    if (!input.IsEmpty()) // 可能有人输入特殊字符导致预约失败
    {
        for (int i = 0; i < input.GetLength(); i++)
        {
            const auto item = input[i];
            if ('0' <= item && item <= '9')
            {
                continue;
            }
            if (i == 0 && item == '+')
            {
                continue;
            }

            AfxMessageBox(_T("number input invalid character"));
            return;
        }
    }

    CTools::GetEditValue(attendeeInfo.name, sizeof(attendeeInfo.name), m_editName);
    CTools::GetEditValue(attendeeInfo.aliasCN, sizeof(attendeeInfo.aliasCN), m_editAliasCN);
    CTools::GetEditValue(attendeeInfo.aliasEN, sizeof(attendeeInfo.aliasEN), m_editAliasEN);
    CTools::GetEditValue(attendeeInfo.number, sizeof(attendeeInfo.number), m_editNumber);
    CTools::GetEditValue(attendeeInfo.email, sizeof(attendeeInfo.email), m_editEmail);
    CTools::GetEditValue(attendeeInfo.sms, sizeof(attendeeInfo.sms), m_editPhone);
    CTools::GetEditValue(attendeeInfo.thirdUserId, sizeof(attendeeInfo.thirdUserId), m_editThirdUserId);
    CTools::GetEditValue(attendeeInfo.orgId, sizeof(attendeeInfo.orgId), m_editOrgId);

    attendeeInfo.isMute = m_checkMute.GetCheck();
    attendeeInfo.isAutoInvite = m_checkInvite.GetCheck();

    CDialogEx::OnOK();
}

void demoAddAttendeeDlg2::OnCancel()
{
    CDialogEx::OnCancel();
}

void demoAddAttendeeDlg2::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_NAME, m_editName);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_ALIASCN, m_editAliasCN);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_ALIASEN, m_editAliasEN);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_NUMBER2, m_editNumber);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_EMAIL, m_editEmail);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_PHONE, m_editPhone);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_THIRD_USER_ID, m_editThirdUserId);
    DDX_Control(pDX, IDC_EDIT_ADD_ATTENDEE_ORG_ID, m_editOrgId);
    DDX_Control(pDX, IDC_CHECK_ADD_ATTENDEE_MUTE, m_checkMute);
    DDX_Control(pDX, IDC_CHECK_ADD_ATTENDEE_INVITE, m_checkInvite);
}

// demoAddAttendeeDlg2 消息处理程序