// demoAnnotationSaveConfigDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "demoAnnotationSaveConfigDlg.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"
#include "resource.h"

// demoAnnotationSaveConfigDlg Ի

IMPLEMENT_DYNAMIC(demoAnnotationSaveConfigDlg, CDialogEx)

demoAnnotationSaveConfigDlg::demoAnnotationSaveConfigDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_SAVE_ANNOTATION_DIALOG, pParent)
{

}

demoAnnotationSaveConfigDlg::~demoAnnotationSaveConfigDlg()
{
}

void demoAnnotationSaveConfigDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_ANNOTATION_SAVE_PATH, m_savePathEdit);
}


BEGIN_MESSAGE_MAP(demoAnnotationSaveConfigDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoAnnotationSaveConfigDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// demoAnnotationSaveConfigDlg Ϣ


void demoAnnotationSaveConfigDlg::OnBnClickedOk()
{
    CString savePathCString;
    m_savePathEdit.GetWindowText(savePathCString);
    string savePath = CTools::UNICODE2UTF(savePathCString.GetString());

    hwmsdkagent::HwmAnnotationSaveConfigInfo info{};
    strncpy_s(info.path, savePath.c_str(), HWM_MAX_FILE_PATH_LEN);
    int ret = hwmsdkagent::SaveAnnotation(&info);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("SaveAnnotation error");
        return;
    }
    CDialogEx::OnOK();
}