//
//  demoNotifyAndCallBackProc.h
//  EC_SDK_DEMO
//
//  Created by EC Open support team.
//  Copyright(C), 2018, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
//

#pragma once

#include "HwmAgentNotify.h"
using namespace hwmsdkagent;

class demoNotifyProc : public HwmAgentNotify
{
public:
    demoNotifyProc();
    ~demoNotifyProc();

public:
    /**
    * @brief [en] Notify of sdk disconnected.
    *        [cn] ӶϿ֪ͨ
    *
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnSdkDisconnected();

    /**
    * @brief [en] Notify of be kicked out.
    *        [cn] ¼֪ͨ
    *
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnKickedOut();

    /**
    * @brief [en] Notify of the config of corporation.
    *        [cn] ҵ֪ͨ
    *
    * @param [in] HwmCorpConfigInfo* data                 [en] Config data
    *                                                     [cn] Ϣ
    * @attention [en] More details of data in doc file
    *            [cn] dataṹ嶨ĵ
    **/
    virtual void OnCorpConfig(HwmCorpConfigInfo* data);

    /**
    * @brief [en] Notify of the info of corporation.
    *        [cn] ͻҵϢ仯֪ͨ
    *
    * @param [in] HwmCorpInfoNotifyType type                 [en] user corp info type
    *                                                        [cn] ͻҵϢ仯֪ͨ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnUserCorpInfo(HwmUserCorpInfoNotifyType type);

    /**
    * @brief [en] Notify of the conf incoming
    *        [cn] ֪ͨ
    *
    * @param [in] HwmConfIncomingInfo* data                 [en] Conf incoming info
    *                                                       [cn] Ϣ
    * @attention NA
    **/
    virtual void OnConfIncoming(HwmConfIncomingInfo* data);

    /**
    * @brief [en] Notify of conf state.
    *        [cn] ״̬֪ͨ
    *
    * @param [in] HwmConfStateInfo *confStateInfo             [en] Conf state info
    *                                                         [cn] ״̬Ϣ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnConfState(HwmConfStateInfo *confStateInfo);

    /**
    * @brief [en] Notify of conf info.
    *        [cn] Ϣ֪ͨ
    *
    * @param [in] HwmConfInfo *confInfo             [en] Conf info
    *                                               [cn] Ϣ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnConfInfo(HwmConfInfo *confInfo);

    /**
    * @brief [en] Notify of share state.
    *        [cn] ״̬֪ͨ
    *
    * @param [in] HwmShareStateInfo *shareStateInfo             [en] Share state info
    *                                                           [cn] ״̬Ϣ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnShareState(HwmShareStateInfo *shareStateInfo);

    /**
    * @brief [en] Notify of receive share state.
    *        [cn] յ״̬֪ͨ
    *
    * @param [in] HwmShareStateInfo *shareStateInfo             [en] Share state info
    *                                                           [cn] ״̬Ϣ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnRecvShareState(HwmRecvShareStateInfo *shareStateInfo);

    /**
    * @brief [en] Notify of start share.
    *        [cn] ע밴ť֪ͨ
    *
    * @param [in] HwmClickInjectBtn injectBtn             [en] Button type
    *                                                     [cn] ť
    * @param [in] void* data                              [en] Notify data
    *                                                     [cn] ֪ͨ
    * @param [in] const char* id                          [en] User custome menu id
    *                                                     [cn] ûԶ˵id
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnClickInjectBtn(HwmClickInjectBtn injectBtn, void* data, const char* id);

    /**
    * @brief [en] conf list notify. when login / bookconf / cancelconf, will receive this notify
    *        [cn] б֪ͨԤԼ߻ȡбʱյ֪ͨ»б
    *
    * @param [in] HwmConflistUpdateType updateType                [en] Update type of conf list
    *                                                             [cn] Ϣ
    * @param [in] const HwmConfListInfo *confInfoList             [en] conf info list
    *                                                             [cn] Ϣб
    * @param [in] unsigned int confInfoLen                        [en] the size of conf list
    *                                                             [cn] Ϣб
    */
    virtual void OnConfList(HwmConflistUpdateType updateType, const HwmConfListInfo *confInfoList, unsigned int confInfoLen);

    /**
    * @brief [en] Notify of call state.
    *        [cn] ͨ״̬֪ͨ
    *
    * @param [in] HwmCallStateInfo              [en] call state
    *                                           [cn] ͨ״̬
    * @attention [en] NA
    *            [cn] NA
    */
    virtual void OnCallState(const HwmCallStateInfo *callStateInfo);

    /**
    * @brief [en] Notify of call info
    *        [cn] ͨϢ֪ͨ
    *
    * @param [in] HwmCallInfo               [en] call info
    *                                       [cn] ͨϢ
    * @attention [en] NA
    *            [cn] NA
    */
    virtual void OnCallInfo(const HwmCallInfo *callInfo);

    /**
    * @brief [en] Notify of login error
    *        [cn] ¼Ͽ֪ͨ
    *
    * @param [in] unsigned int reason           [en] reason
    *                                           [cn] ¼Ͽԭ
    * @attention [en] NA
    *            [cn] NA
    */
    virtual void OnAuthenticateExpired(unsigned int reason);

    /**
    * @brief [en] Notify of AVDevice control state
    *        [cn] Ƶ豸״̬仯֪ͨ
    *
    * @param [in] HwmDeviceType deviceType          [en] Device type
    *                                               [cn] 豸
    * @param [in] bool isOpen                       [en] is open
    *                                               [cn] Ƿ
    * @attention [en] NA
    *            [cn] NA
    */
    virtual void OnAVDeviceCtrlStateChanged(HwmDeviceType deviceType, bool isOpen);

    /**
    * @brief [en] Notify of audio famme
    *        [cn] ϱƵ֪֡ͨ
    *
    * @param [in] AudioFrameData* pFrame             [en] Report audio stream frame data.
    *                                                [cn] ϱƵ֪֡ͨ
    * @attention [en] NA
    *            [cn] NA
    */
    virtual void OnAudioFrameNotify(const AudioFrameData* pFrame) override;
    /**
    * @brief [en] Notify of conf share locked state changed
    *        [cn] Ƿ״̬仯֪ͨ
    *
    * @param [in] bool isShareLocked                 [en] Is share locked
    *                                                [cn] Ƿ
    * @attention [en] NA
    *            [cn] NA
    */
    virtual void OnConfIsShareLockedChanged(bool isShareLocked) override;

    /**
    * @brief
    * [en] This class is about the notification of an ended conference.
    * [cn] ֪ͨ
    *
    * @detail
    * [en]
    * [cn] յ֪ͨʱʾѽ
    *
    * @param ret [type:SDKERR]
    * [en] Error code
    * [cn] 
    *
    * @param reason [type:HWM_CHAR*]
    * [en] Reason
    * [cn] 
    *
    * @param confEndInfo [type:HwmConfEndInfo*]
    * [en] Conf end info
    * [cn] ѽĻϢ
    */
    virtual void OnConfEndedNotify(const HwmConfEndInfo* confEndInfo) override;

    /**
    * @brief
    * [en] This class is about the callback of transfering point to point call to conference.
    * [cn] MMRԵ¼ص
    *
    * @param recordInfo [type:HwmP2PConfRecordInfo*]
    * [en] P2P conf record info
    * [cn] ¼Ϣ
    */
    virtual void OnP2PConfRecordNotify(HwmP2PConfRecordInfo* recordInfo) override;

    /**
    * @brief
    * [en]This class is about the notification of low quality network.
    * [cn]ʾ֪ͨ
    *
    * @param lowNetWorkType [type:PoorNetWorkQualityInfo*][cs_allowNull:N]
    * [en]
    * [cn]
    * @see PoorNetWorkQualityInfo
    *
    * @since:v1.0
    */
    virtual void OnPoorNetworkQualityInfoNotify(const HwmPoorNetWorkQualityInfo* poorNetWorkInfo) override;

    /**
    * @brief [en] Notify of show voiceprint statement
    *        [cn] ʾ֪ͨ
    *
    * @param [in] HwmVoiceprintStatementEntry entry     [en] entry of show voiceprint statement
    *                                                   [cn] 鿴Ĵ
    * @mac:disable
    */
    virtual void OnShowVoiceprintStatement(const HwmShowVoiceprintStatementInfo* info) override;

    /**
    * @brief
    * [en]Notify of speaker list
    * [cn]˱֪ͨ
    *
    * @param speakerList [type:HwmSpeakerList]
    * [en]Speaker list
    * [cn]б
    */
    virtual void OnSpeakerListChanged(const HwmSpeakerList* speakerList) override;

    /**
    * @brief
    * [en]Notify of video stream type info
    * [cn]Ƶ͵ı仯֪ͨ
    *
    * @param videoStreamTypeInfo [type:HwmVideoStreamTypeInfo]
    * [en]video stream type info
    * [cn]ƵϢ
    */
    virtual void OnVideoStreamTypeChanged(const HwmVideoStreamTypeInfo* videoStreamTypeInfo) override;

    /**
    * @brief
    * [en]Notify of annotation state change
    * [cn]ע״̬仯֪ͨ
    *
    * @param stateInfo [type:HwmAnnotationStateInfo*]
    * [en]Annotation state info
    * [cn]ע״̬Ϣ
    *
    * @js:disable
    */
    virtual void OnAnnotationStateChanged(const HwmAnnotationStateInfo* stateInfo) override;

    /**
    * @brief
    * [en]Notify of video attendee list change
    * [cn]Ƶб֪ͨ
    *
    * @js:disable
    */
    virtual void OnVideoAttendeeListChanged() override;

    /**
    * @brief
    * [en]Notify of conf info
    * [cn]Ϣ֪ͨ
    *
    * @param meetingInfo [type:HwmMeetingInfo*]
    * [en]Conf info
    * [cn]Ϣ
    */
    virtual void OnMeetingInfoChanged(const HwmMeetingInfo* meetingInfo) override;

    /**
    * @brief
    * [en] Notify of the waiting list
    * [cn] ȺҳԱб֪ͨ
    *
    * @param waitingList [type:HwmAttendeeListInfo*]
    * [en] Waiting list
    * [cn] ȺҳԱб
    */
    virtual void OnWaitingListChanged(const HwmAttendeeListInfo* waitingList) override;

    /**
    * @brief
    * [en] Notify of the add attendee
    * [cn] ߽֪ͨ
    *
    * @detail
    * [en]
    * [cn] ӶʱܻϱΡ
    *
    * @param addAttendeeResultList [type:HwmAddAttendeeResultList*]
    * [en] add attendee result list
    * [cn] ߽б
    **/
    virtual void OnAddAttendeeNotify(const HwmAddAttendeeResultList* addAttendeeResultList) override;

    /**
    * @brief
    * [en] Notify of local record state
    * [cn] ¼״̬֪ͨ
    *
    * @param localRecordStateInfo [type:HwmLocalRecordStateInfo*]
    * [en] Local record state info
    * [cn] ¼״̬Ϣ
    */
    virtual void OnSelfLocalRecordStateNotify(const HwmLocalRecordStateInfo* localRecordStateInfo) override;

    /**
    * @brief[en] User data path change notification
    *       [cn] û·仯֪ͨ
    *
    * @param userSavePathInfo [type:HwmUserSavePathInfo*]
    * [en] Path Info
    * [cn] ·Ϣ
    *
    * @mac:disable
    */
    virtual void OnUserSavePathChanged(const HwmUserSavePathInfo* userSavePathInfo) override;

    /**
    * @brief
    * [en] Notify of double click participant list item
    * [cn] ˫֪ͨ
    *
    * @detail
    * [en]
    * [cn] յ֪ͨʱû˫бе
    *
    * @param participantInfo [type:HwmParticipantItemInfo*]
    * [en] Participant info
    * [cn] Ϣ
    */
    virtual void OnDoubleClickParticipantListItemNotify(const HwmParticipantItemInfo* participantInfo) override;

    /**
    * @brief
    * [en] Notify of the attendee list
    * [cn] б֪ͨ
    *
    * @param attendeeList [type:HwmAttendeeListInfo]
    * [en] Attendee list
    * [cn] б
    **/
    virtual void OnAttendeeListChanged(const HwmAttendeeListInfo* attendeeList) override;

    // Ļ״̬֪ͨ
    virtual void OnSubtitleStateChanged(bool isOpen) override;

    // Ⱥ״̬֪ͨ
    virtual void OnWaitingRoomStateChanged(bool isOpen) override;

    /**
    * @brief
    * [en] Notify of the real time subtitle info
    * [cn] ʵʱĻϢ֪ͨ
    *
    * @param realTimeSubtitleInfo [type:HwmRealTimeSubtitleInfo*]
    * [en] Real Time Subtitle Info
    * [cn] ʵʱĻϢ
    **/
    virtual void OnRealTimeSubtitleInfoNotify(const HwmRealTimeSubtitleInfo* realTimeSubtitleInfo) override;

    /**
    * @brief
    * [en] Notify of the subtitle record info
    * [cn] Ļ¼Ϣ֪ͨ
    *
    * @param subtitleRecordInfo [type:HwmSubtitleRecordInfo*]
    * [en] Subtitle Record Info
    * [cn] Ļ¼Ϣ
    **/
    virtual void OnSubtitleRecordNotify(const HwmSubtitleRecordInfo* subtitleRecordInfo) override;

    // ¼Ʋж֪ͨ
    virtual void OnStartLocalRecordOperationInterruptNotify(const HwmInterruptInfo* info) override;

    //  ɴ֪ͨ
    virtual void OnCreateConfFinishedNotify(hwmsdk::HwmErrCode ret, const char* reason, HwmCreateConfResult *confInfo) override;

    // ¼״̬仯֪ͨ
    virtual void OnLoginStateChangeNotify(const HwmLoginStateInfo* loginStateInfo) override;

    /*********************************************Ǳ֪ͨ*********************************************/

    /**
    * @brief [en] Notify of pair code refresh.
    *        [cn] ˢ֪ͨ
    *
    * @param [in] HwmPairCodeInfo* data                   [en] Pair code data
    *                                                     [cn] 
    * @attention [en] Reserved
    *            [cn] ֪ͨ汾ʹ
    **/
    virtual void OnRefreshPairCode(HwmPairCodeInfo* data);

    /**
    * @brief [en] Notify of remote control state.
    *        [cn] õԶ̿״̬֪ͨ
    *
    * @param [in] HwmRemoteControlStateInfo *remoteControlStateInfo             [en] Remote control state
    *                                                                           [cn] Զ̿״̬Ϣ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnRemoteControlState(HwmRemoteControlStateInfo *remoteControlStateInfo);

    /**
    * @brief [en] Notify of be remote controled state.
    *        [cn] Զ̿״̬֪ͨ
    *
    * @param [in] HwmRemoteControlStateInfo *remoteControlStateInfo             [en] Remote control state
    *                                                                           [cn] Զ̿״̬Ϣ
    * @attention [en] NA
    *            [cn] NA
    **/
    virtual void OnBeRemoteControledState(HwmRemoteControlStateInfo *remoteControlStateInfo);

    /**
    * @brief [en] Notify of the call incoming
    *        [cn] ֪ͨ
    *
    * @param [in] HwmCallIncomingInfo* data                 [en] Call incoming info
    *                                                       [cn] Ϣ
    * @attention [en] Reserved
    *            [cn] ֪ͨ
    */
    virtual void OnCallIncoming(const HwmCallIncomingInfo* callIncomingInfo);

    /**
    * @brief [en] Notify of call recode info
    *        [cn] ͨ¼Ϣ֪ͨ
    *
    * @param [in] callRecordInfo                [en] call record info
    *                                           [cn] ͨ¼
    * @attention [en] Reserved
    *            [cn] ֪ͨ
    */
    virtual void OnCallRecordInfo(const HwmCallRecordInfo *callRecordInfo);
    /**
    * @brief [en] Notify of show external conf info wnd
    *        [cn] ʾⲿϢ֪ͨ
    *
    * @param [in] left                          [en] conf info wnd's left pos.
    *                                           [cn] Ϣ
    * @param [in] top                           [en] conf info wnd's top pos.
    *                                           [cn] Ϣ򶥲
    * @attention [en] Reserved
    *            [cn] ֪ͨ
    */
    virtual void OnShowExternalConfInfoWnd(int left, int top);
    /**
    * @brief [en] Notify of destroy external conf info wnd
    *        [cn] ⲿϢ֪ͨ
    * @attention [en] Reserved
    *            [cn] ֪ͨ
    */
    virtual void OnDestroyExternalConfInfoWnd();
    /**
    * @brief [en] Notify of query external contact avatar
    *        [cn] ѯⲿͨѶ¼ͷ֪ͨ
    * @param [in] account                       [en] account info
    *                                           [cn] ˻Ϣ
    * @param [in] thirdUserId                   [en] thirdUserId info
    *                                           [cn] ˻Ϣ
    * @param [in] sipNumber                     [en] sipNumber info
    *                                           [cn] sipϢ
    * @param [in] avatarPath                    [en] avatarPath info
    *                                           [cn] ͷ·Ϣ
    * @param [in] pathLen                       [en] pathLen info
    *                                           [cn] ·Ϣ
    * @attention [en] Reserved
    *            [cn] ֪ͨ
    */
    virtual void OnQueryContactAvatar(const char account[HWM_MAX_ACCOUNT_LEN], const char thirdUserId[HWM_MAX_ACCOUNT_LEN], const char sipNumber[HWM_MAX_NUMBER_LEN], char* avatarPath, int pathLen);

    /**
    * @brief [en] window handle list notify. when window handle changed, will receive this notify
    *        [cn] ھϢ֪ͨ
    *
    * @param [in] const HwmHwndListInfo* hwndInfo           [en] window handle info
    *                                                       [cn] ھϢ
    */
    virtual void OnRenderWindowInfoList(const HwmHwndListInfo* hwndInfo);
    /*********************************************Ǳ֪ͨ*********************************************/
};