﻿// demoSetDefaultVirtualBg.cpp: 实现文件
//

#include "stdafx.h"
#include "resource.h"
#include "demoSetDefaultVirtualBg.h"
#include "afxdialogex.h"
#include "HwmSdkAgent.h"
#include "demoTools.h"

// demoSetDefaultVirtualBg 对话框

IMPLEMENT_DYNAMIC(demoSetDefaultVirtualBg, CDialogEx)

demoSetDefaultVirtualBg::demoSetDefaultVirtualBg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_SET_DEFAULT_VIRTUAL_BACKGROUND, pParent)
    , m_mode(0)
{

}

demoSetDefaultVirtualBg::~demoSetDefaultVirtualBg()
{
}

void demoSetDefaultVirtualBg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_VRBG_IMAGES, m_vrbgImages);
    DDX_Radio(pDX, IDC_REPLACE_ALL, m_mode);
}


BEGIN_MESSAGE_MAP(demoSetDefaultVirtualBg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoSetDefaultVirtualBg::OnBnClickedOk)
END_MESSAGE_MAP()


// demoSetDefaultVirtualBg 消息处理程序


void demoSetDefaultVirtualBg::OnBnClickedOk()
{
    using namespace hwmsdkagent;
    UpdateData(1);
    std::vector<HwmVirtualBackgroundImageInfo> imgsInfo{};
    for (auto &iter : m_imagesPath)
    {
        HwmVirtualBackgroundImageInfo item{};
        strcpy_s(item.imagePath, iter.c_str());
        imgsInfo.push_back(item);
    }
    HwmVirtualBackgroundInfo bgInfo{};
    bgInfo.mode = static_cast<HwmSettingVrbkDefaultImageMode>(m_mode);
    bgInfo.imageList = imgsInfo.data();
    bgInfo.imageLength = imgsInfo.size();
    SetVirtualBackgroundDefaultImages(&bgInfo);
    CDialogEx::OnOK();
}


BOOL demoSetDefaultVirtualBg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    CString buff;
    buff.Preallocate(MAX_PATH);
    GetModuleFileName(nullptr, buff.GetBuffer(), MAX_PATH);
    PathRemoveFileSpec(buff.GetBuffer());
    PathAppend(buff.GetBuffer(), L"demoResource\\virtualbg");

    CString img;
    img.Preallocate(MAX_PATH);
    for (auto &iter : {L"1.jpg", L"2.jpg", L"3.jpg", L"4.jpg", L"5.jpg"})
    {
        PathCombine(img.GetBuffer(), buff, iter);
        m_vrbgImages.AddString(img);
        m_imagesPath.push_back(CTools::UNICODE2UTF(img.GetBuffer()));
    }

    return TRUE;
}
