// demoSetServerAddressDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "resource.h"
#include "demoSetServerAddressDlg.h"
#include "afxdialogex.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"

// demoSetServerAddressDlg Ի

IMPLEMENT_DYNAMIC(demoSetServerAddressDlg, CDialogEx)

demoSetServerAddressDlg::demoSetServerAddressDlg(CWnd* pParent /*=NULL*/)
    : CDialogEx(IDD_SET_SERVER_ADDRESS_DIALOG, pParent)
{

}

demoSetServerAddressDlg::~demoSetServerAddressDlg()
{
}

void demoSetServerAddressDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_SET_SERVER_ADDRESS, m_serverEdit);
    DDX_Control(pDX, IDC_EDIT_SERVER_PORT, m_portEdit);
}

// demoLoginDlg Ϣ

BOOL demoSetServerAddressDlg::OnInitDialog()
{
    CDialogEx::OnInitDialog();

    // ļȡϴε¼ʺ
    CString temp = _T("");
    CTools::getIniConfigParam(_T("LoginConfig"), _T("loginServer"), temp);
    m_serverEdit.SetWindowText(temp);
    CTools::getIniConfigParam(_T("LoginConfig"), _T("loginPort"), temp);
    m_portEdit.SetWindowText(temp);

    return TRUE;  // ǽõؼ򷵻 TRUE
}

BEGIN_MESSAGE_MAP(demoSetServerAddressDlg, CDialogEx)
    ON_BN_CLICKED(IDC_BUTTON_SET_SERVER_ADDRESS_OK, &demoSetServerAddressDlg::OnBnClickedButtonOk)
END_MESSAGE_MAP()


// demoSetServerAddressDlg Ϣ


void demoSetServerAddressDlg::OnBnClickedButtonOk()
{
    CString serverCString;
    CString portCString;
    m_serverEdit.GetWindowText(serverCString);
    m_portEdit.GetWindowText(portCString);

    hwmsdkagent::HwmServerInfo serverInfo;
    memset(&serverInfo, 0, sizeof(hwmsdkagent::HwmServerInfo));

    string server = CTools::UNICODE2UTF(serverCString.GetString());
    strncpy_s(serverInfo.serverAddr, server.c_str(), sizeof(serverInfo.serverAddr) - 1);
    serverInfo.serverPort = _ttoi(portCString);
    int ret = hwmsdkagent::SetServerAddress(&serverInfo);
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("Set server failed");
        return;
    }

    //ӿڵóɹ󽫵¼Ϣ浽ļ´ȡ
    CTools::writeIniConfigParam(_T("LoginConfig"), _T("loginServer"), serverCString);
    CTools::writeIniConfigParam(_T("LoginConfig"), _T("loginPort"), portCString);

    // TODO: ڴӿؼ֪ͨ
    CDialogEx::OnOK();
}
