﻿// demoApplyHostRoleDlg.cpp: 实现文件
//

#include "stdafx.h"
#include "demoApplyHostRoleDlg.h"
#include "afxdialogex.h"
#include "demo.h"
#include "demoTools.h"
#include "HwmSdkAgent.h"
#include "resource.h"


// demoApplyHostRoleDlg 对话框

IMPLEMENT_DYNAMIC(demoApplyHostRoleDlg, CDialogEx)

demoApplyHostRoleDlg::demoApplyHostRoleDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_APPLY_HOST_ROLE_DIALOG, pParent)
{

}

demoApplyHostRoleDlg::~demoApplyHostRoleDlg()
{
}

void demoApplyHostRoleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT_HOST_PASSWORD, m_passwordEdit);
}

void demoApplyHostRoleDlg::OnBnClickedOk()
{
    CString passwordCString;
    m_passwordEdit.GetWindowText(passwordCString);
    string password = CTools::UNICODE2UTF(passwordCString.GetString());
    int ret = hwmsdkagent::ApplyHostRole(password.c_str());
    if (hwmsdk::HWM_COMMON_SUCCESS != ret)
    {
        CTools::OutputRetStr("ApplyHostRole error");
        return;
    }
    CDialogEx::OnOK();
}


BEGIN_MESSAGE_MAP(demoApplyHostRoleDlg, CDialogEx)
    ON_BN_CLICKED(IDOK, &demoApplyHostRoleDlg::OnBnClickedOk)
END_MESSAGE_MAP()
